/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;

public abstract class MgmtMessage {

    public static class CaEntryWrapper {
        private NameId ident;
        private CaStatus status;
        private Certprofile.CertValidity maxValidity;
        private String signerType;
        private String signerConf;
        private String scepControl;
        private String crlControl;
        private String crlSignerName;
        private String cmpControl;
        private String cmpResponderName;
        private String scepResponderName;
        private boolean duplicateKeyPermitted;
        private boolean duplicateSubjectPermitted;
        private ProtocolSupport protocolSupport;
        private boolean saveRequest;
        private ValidityMode validityMode = ValidityMode.STRICT;
        private int permission;
        private int expirationPeriod;
        private int keepExpiredCertInDays;
        private String extraControl;
        private CaUris caUris;
        private byte[] certBytes;
        private int serialNoBitLen;
        private long nextCrlNumber;
        private int numCrls;
        private CertRevocationInfo revocationInfo;

        public CaEntryWrapper() {
        }

        public CaEntryWrapper(MgmtEntry.Ca caEntry) {
            this.ident = caEntry.getIdent();
            this.status = caEntry.getStatus();
            this.maxValidity = caEntry.getMaxValidity();
            this.signerType = caEntry.getSignerType();
            this.signerConf = caEntry.getSignerConf();
            if (caEntry.getScepControl() != null) {
                this.scepControl = caEntry.getScepControl().getConf();
            }
            if (caEntry.getCrlControl() != null) {
                this.crlControl = caEntry.getCrlControl().getConf();
            }
            this.crlSignerName = caEntry.getCrlSignerName();
            if (caEntry.getCmpControl() != null) {
                this.cmpControl = caEntry.getCmpControl().getConf();
            }
            this.cmpResponderName = caEntry.getCmpResponderName();
            this.scepResponderName = caEntry.getScepResponderName();
            this.duplicateKeyPermitted = caEntry.isDuplicateKeyPermitted();
            this.duplicateSubjectPermitted = caEntry.isDuplicateSubjectPermitted();
            this.protocolSupport = caEntry.getProtocoSupport();
            this.saveRequest = caEntry.isSaveRequest();
            this.validityMode = caEntry.getValidityMode();
            this.permission = caEntry.getPermission();
            this.expirationPeriod = caEntry.getExpirationPeriod();
            this.keepExpiredCertInDays = caEntry.getKeepExpiredCertInDays();
            if (caEntry.getExtraControl() != null) {
                this.extraControl = caEntry.getExtraControl().getEncoded();
            }
            this.caUris = caEntry.getCaUris();
            if (caEntry.getCert() != null) {
                try {
                    this.certBytes = caEntry.getCert().getEncoded();
                }
                catch (CertificateEncodingException ex) {
                    throw new IllegalStateException("could not encode certificate", ex);
                }
            }
            this.serialNoBitLen = caEntry.getSerialNoBitLen();
            this.nextCrlNumber = caEntry.getNextCrlNumber();
            this.numCrls = caEntry.getNumCrls();
            this.revocationInfo = caEntry.getRevocationInfo();
        }

        public NameId getIdent() {
            return this.ident;
        }

        public void setIdent(NameId ident) {
            this.ident = ident;
        }

        public CaStatus getStatus() {
            return this.status;
        }

        public void setStatus(CaStatus status) {
            this.status = status;
        }

        public Certprofile.CertValidity getMaxValidity() {
            return this.maxValidity;
        }

        public void setMaxValidity(Certprofile.CertValidity maxValidity) {
            this.maxValidity = maxValidity;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setSignerType(String signerType) {
            this.signerType = signerType;
        }

        public String getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(String signerConf) {
            this.signerConf = signerConf;
        }

        public String getScepControl() {
            return this.scepControl;
        }

        public void setScepControl(String scepControl) {
            this.scepControl = scepControl;
        }

        public String getCrlControl() {
            return this.crlControl;
        }

        public void setCrlControl(String crlControl) {
            this.crlControl = crlControl;
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName;
        }

        public String getCmpControl() {
            return this.cmpControl;
        }

        public void setCmpControl(String cmpControl) {
            this.cmpControl = cmpControl;
        }

        public String getCmpResponderName() {
            return this.cmpResponderName;
        }

        public void setCmpResponderName(String cmpResponderName) {
            this.cmpResponderName = cmpResponderName;
        }

        public String getScepResponderName() {
            return this.scepResponderName;
        }

        public void setScepResponderName(String scepResponderName) {
            this.scepResponderName = scepResponderName;
        }

        public boolean isDuplicateKeyPermitted() {
            return this.duplicateKeyPermitted;
        }

        public void setDuplicateKeyPermitted(boolean duplicateKeyPermitted) {
            this.duplicateKeyPermitted = duplicateKeyPermitted;
        }

        public boolean isDuplicateSubjectPermitted() {
            return this.duplicateSubjectPermitted;
        }

        public void setDuplicateSubjectPermitted(boolean duplicateSubjectPermitted) {
            this.duplicateSubjectPermitted = duplicateSubjectPermitted;
        }

        public ProtocolSupport getProtocolSupport() {
            return this.protocolSupport;
        }

        public void setProtocolSupport(ProtocolSupport protocolSupport) {
            this.protocolSupport = protocolSupport;
        }

        public boolean isSaveRequest() {
            return this.saveRequest;
        }

        public void setSaveRequest(boolean saveRequest) {
            this.saveRequest = saveRequest;
        }

        public ValidityMode getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(ValidityMode validityMode) {
            this.validityMode = validityMode;
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public int getExpirationPeriod() {
            return this.expirationPeriod;
        }

        public void setExpirationPeriod(int expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        public int getKeepExpiredCertInDays() {
            return this.keepExpiredCertInDays;
        }

        public void setKeepExpiredCertInDays(int keepExpiredCertInDays) {
            this.keepExpiredCertInDays = keepExpiredCertInDays;
        }

        public String getExtraControl() {
            return this.extraControl;
        }

        public void setExtraControl(String extraControl) {
            this.extraControl = extraControl;
        }

        public CaUris getCaUris() {
            return this.caUris;
        }

        public void setCaUris(CaUris caUris) {
            this.caUris = caUris;
        }

        public byte[] getCertBytes() {
            return this.certBytes;
        }

        public void setCertBytes(byte[] certBytes) {
            this.certBytes = certBytes;
        }

        public int getSerialNoBitLen() {
            return this.serialNoBitLen;
        }

        public void setSerialNoBitLen(int serialNoBitLen) {
            this.serialNoBitLen = serialNoBitLen;
        }

        public long getNextCrlNumber() {
            return this.nextCrlNumber;
        }

        public void setNextCrlNumber(long nextCrlNumber) {
            this.nextCrlNumber = nextCrlNumber;
        }

        public int getNumCrls() {
            return this.numCrls;
        }

        public void setNumCrls(int numCrls) {
            this.numCrls = numCrls;
        }

        public CertRevocationInfo getRevocationInfo() {
            return this.revocationInfo;
        }

        public void setRevocationInfo(CertRevocationInfo revocationInfo) {
            this.revocationInfo = revocationInfo;
        }

        public MgmtEntry.Ca toCaEntry() throws CertificateException, CaMgmtException, InvalidConfException {
            MgmtEntry.Ca rv = new MgmtEntry.Ca(this.ident, this.serialNoBitLen, this.nextCrlNumber, this.signerType, this.signerConf, this.caUris, this.numCrls, this.expirationPeriod);
            if (this.certBytes != null) {
                rv.setCert(X509Util.parseCert((byte[])this.certBytes));
            }
            if (this.cmpControl != null) {
                rv.setCmpControl(new CmpControl(this.cmpControl));
            }
            rv.setCmpResponderName(this.cmpResponderName);
            if (this.crlControl != null) {
                rv.setCrlControl(new CrlControl(this.crlControl));
            }
            rv.setCrlSignerName(this.crlSignerName);
            rv.setDuplicateKeyPermitted(this.duplicateKeyPermitted);
            rv.setDuplicateSubjectPermitted(this.duplicateSubjectPermitted);
            if (this.extraControl != null) {
                rv.setExtraControl(new ConfPairs(this.extraControl));
            }
            rv.setKeepExpiredCertInDays(this.keepExpiredCertInDays);
            rv.setMaxValidity(this.maxValidity);
            rv.setNextCrlNumber(this.nextCrlNumber);
            rv.setPermission(this.permission);
            rv.setProtocolSupport(this.protocolSupport);
            rv.setRevocationInfo(this.revocationInfo);
            rv.setSaveRequest(this.saveRequest);
            if (this.scepControl != null) {
                rv.setScepControl(new ScepControl(this.scepControl));
            }
            rv.setScepResponderName(this.scepResponderName);
            rv.setSerialNoBitLen(this.serialNoBitLen);
            rv.setSignerConf(this.signerConf);
            rv.setStatus(this.status);
            rv.setValidityMode(this.validityMode);
            return rv;
        }
    }

    public static class SignerEntryWrapper {
        private String name;
        private String type;
        private String conf;
        private byte[] encodedCert;
        private boolean faulty;

        public SignerEntryWrapper() {
        }

        public SignerEntryWrapper(MgmtEntry.Signer signerEntry) {
            this.name = signerEntry.getName();
            this.type = signerEntry.getType();
            this.conf = signerEntry.getConf();
            this.faulty = signerEntry.isFaulty();
            if (signerEntry.getBase64Cert() != null) {
                this.encodedCert = Base64.decode((String)signerEntry.getBase64Cert());
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setConf(String conf) {
            this.conf = conf;
        }

        public byte[] getEncodedCert() {
            return this.encodedCert;
        }

        public void setEncodedCert(byte[] encodedCert) {
            this.encodedCert = encodedCert;
        }

        public String getConf() {
            return this.conf;
        }

        public boolean isFaulty() {
            return this.faulty;
        }

        public void setFaulty(boolean faulty) {
            this.faulty = faulty;
        }

        public MgmtEntry.Signer toSignerEntry() {
            String base64Cert = null;
            if (this.encodedCert != null) {
                base64Cert = Base64.encodeToString((byte[])this.encodedCert);
            }
            MgmtEntry.Signer ret = new MgmtEntry.Signer(this.name, this.type, this.conf, base64Cert);
            ret.setConfFaulty(this.faulty);
            return ret;
        }
    }

    public static enum MgmtAction {
        addCa,
        addCaAlias,
        addCertprofile,
        addCertprofileToCa,
        addPublisher,
        addPublisherToCa,
        addRequestor,
        addRequestorToCa,
        addSigner,
        addUser,
        addUserToCa,
        changeCa,
        changeCertprofile,
        changePublisher,
        changeRequestor,
        changeSigner,
        changeUser,
        clearPublishQueue,
        exportConf,
        generateCertificate,
        generateCrlOnDemand,
        generateRootCa,
        getAliasesForCa,
        getCa,
        getCaAliasNames,
        getCaHasUsersForUser,
        getCaNameForAlias,
        getCaNames,
        getCaSystemStatus,
        getCert,
        getCertprofile,
        getCertprofileNames,
        getCertprofilesForCa,
        getCertRequest,
        getCrl,
        getCurrentCrl,
        getFailedCaNames,
        getInactiveCaNames,
        getPublisher,
        getPublisherNames,
        getPublishersForCa,
        getRequestor,
        getRequestorNames,
        getRequestorsForCa,
        getSigner,
        getSignerNames,
        getSuccessfulCaNames,
        getSupportedCertprofileTypes,
        getSupportedPublisherTypes,
        getSupportedSignerTypes,
        getUser,
        listCertificates,
        loadConf,
        notifyCaChange,
        refreshTokenForSignerType,
        removeCa,
        removeCaAlias,
        removeCertificate,
        removeCertprofile,
        removeCertprofileFromCa,
        removePublisher,
        removePublisherFromCa,
        removeRequestor,
        removeRequestorFromCa,
        removeSigner,
        removeUser,
        removeUserFromCa,
        republishCertificates,
        restartCaSystem,
        revokeCa,
        revokeCertficate,
        unlockCa,
        unrevokeCa,
        unrevokeCertificate;


        public static final MgmtAction ofName(String str) {
            for (MgmtAction action : MgmtAction.values()) {
                if (!action.name().equalsIgnoreCase(str)) continue;
                return action;
            }
            return null;
        }
    }
}

