/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import org.xipki.ca.api.profile.Certprofile;
import org.xipki.security.CrlReason;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;

public class RevokeSuspendedCertsControl {
    public static final String KEY_REVOCATION_ENABLED = "revokeSuspendedCerts.enabled";
    public static final String KEY_REVOCATION_REASON = "revokeSuspendedCerts.targetReason";
    public static final String KEY_UNCHANGED_SINCE = "revokeSuspendedCerts.unchangedSince";
    private CrlReason targetReason;
    private Certprofile.CertValidity unchangedSince;

    private RevokeSuspendedCertsControl() {
    }

    public RevokeSuspendedCertsControl(CrlReason targetReason, Certprofile.CertValidity unchangedSince) {
        this.targetReason = (CrlReason)Args.notNull((Object)targetReason, (String)"targetReason");
        this.unchangedSince = (Certprofile.CertValidity)Args.notNull((Object)unchangedSince, (String)"unchangedSince");
        switch (targetReason) {
            case AFFILIATION_CHANGED: 
            case CESSATION_OF_OPERATION: 
            case KEY_COMPROMISE: 
            case PRIVILEGE_WITHDRAWN: 
            case SUPERSEDED: 
            case UNSPECIFIED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid targetReason " + targetReason);
            }
        }
    }

    public void setUnchangedSince(Certprofile.CertValidity unchangedSince) {
        this.unchangedSince = unchangedSince;
    }

    public void setTargetReason(CrlReason targetReason) {
        this.targetReason = targetReason;
    }

    public CrlReason getTargetReason() {
        return this.targetReason;
    }

    public Certprofile.CertValidity getUnchangedSince() {
        return this.unchangedSince;
    }

    public String toString() {
        ConfPairs pairs = new ConfPairs();
        pairs.putPair(KEY_REVOCATION_REASON, this.targetReason.getDescription());
        pairs.putPair(KEY_UNCHANGED_SINCE, this.unchangedSince.toString());
        return pairs.getEncoded();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RevokeSuspendedCertsControl)) {
            return false;
        }
        RevokeSuspendedCertsControl obj2 = (RevokeSuspendedCertsControl)obj;
        return this.targetReason == obj2.targetReason && this.unchangedSince != obj2.unchangedSince;
    }
}

