/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.BadFormatException;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.security.KeyUsage;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;

public abstract class Certprofile
implements Closeable {
    public boolean isOnlyForRa() {
        return false;
    }

    protected Certprofile() {
    }

    @Override
    public void close() {
    }

    public X509CertVersion getVersion() {
        return X509CertVersion.v3;
    }

    public List<String> getSignatureAlgorithms() {
        return null;
    }

    public boolean includesIssuerAndSerialInAki() {
        return false;
    }

    public AuthorityInfoAccessControl getAiaControl() {
        return null;
    }

    public String incSerialNumber(String currentSerialNumber) throws BadFormatException {
        try {
            long currentSn;
            long l = currentSn = currentSerialNumber == null ? 0L : Long.parseLong(currentSerialNumber.trim());
            if (currentSn < 0L) {
                throw new BadFormatException("invalid currentSerialNumber " + currentSerialNumber);
            }
            return Long.toString(currentSn + 1L);
        }
        catch (NumberFormatException ex) {
            throw new BadFormatException(String.format("invalid serialNumber attribute %s", currentSerialNumber));
        }
    }

    public boolean isSerialNumberInReqPermitted() {
        return true;
    }

    public Set<ExtKeyUsageControl> getExtendedKeyUsages() {
        return null;
    }

    public Map<ASN1ObjectIdentifier, Set<GeneralNameMode>> getSubjectInfoAccessModes() {
        return null;
    }

    public abstract Map<ASN1ObjectIdentifier, ExtensionControl> getExtensionControls();

    public abstract void initialize(String var1) throws CertprofileException;

    public abstract CertLevel getCertLevel();

    public KeypairGenControl getKeypairGenControl() {
        return KeypairGenControl.ForbiddenKeypairGenControl.INSTANCE;
    }

    public abstract Set<KeyUsageControl> getKeyUsage();

    public abstract Integer getPathLenBasicConstraint();

    public abstract Date getNotBefore(Date var1);

    public abstract CertValidity getValidity();

    public abstract SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo var1) throws CertprofileException, BadCertTemplateException;

    public abstract SubjectInfo getSubject(X500Name var1) throws CertprofileException, BadCertTemplateException;

    public abstract ExtensionValues getExtensions(Map<ASN1ObjectIdentifier, ExtensionControl> var1, X500Name var2, X500Name var3, Extensions var4, Date var5, Date var6, PublicCaInfo var7) throws CertprofileException, BadCertTemplateException;

    public abstract boolean incSerialNumberIfSubjectExists();

    public int getMaxCertSize() {
        return 0;
    }

    public static enum X509CertVersion {
        v1(1),
        v2(2),
        v3(3);

        private int versionNumber;

        private X509CertVersion(int versionNumber) {
            this.versionNumber = versionNumber;
        }

        public int getVersionNumber() {
            return this.versionNumber;
        }

        public static X509CertVersion forName(String version) {
            Args.notNull((Object)version, (String)"version");
            for (X509CertVersion m : X509CertVersion.values()) {
                if (!m.name().equalsIgnoreCase(version)) continue;
                return m;
            }
            throw new IllegalArgumentException("invalid X509CertVersion " + version);
        }

        public static X509CertVersion forValue(int versionNumber) {
            for (X509CertVersion m : X509CertVersion.values()) {
                if (m.versionNumber != versionNumber) continue;
                return m;
            }
            throw new IllegalArgumentException("invalid X509CertVersion " + versionNumber);
        }
    }

    public static class SubjectInfo {
        private final X500Name grantedSubject;
        private final String warning;

        public SubjectInfo(X500Name grantedSubject, String warning) {
            this.grantedSubject = (X500Name)Args.notNull((Object)grantedSubject, (String)"grantedSubject");
            this.warning = warning;
        }

        public X500Name getGrantedSubject() {
            return this.grantedSubject;
        }

        public String getWarning() {
            return this.warning;
        }
    }

    public static class SubjectControl {
        private final Map<ASN1ObjectIdentifier, RdnControl> controls;
        private final Map<ASN1ObjectIdentifier, String> typeGroups;
        private final Map<String, Set<ASN1ObjectIdentifier>> groupTypes;
        private final Set<String> groups;
        private final List<ASN1ObjectIdentifier> types;

        public SubjectControl(List<RdnControl> controls, boolean keepRdnOrder) {
            Args.notEmpty(controls, (String)"controls");
            this.typeGroups = new HashMap<ASN1ObjectIdentifier, String>();
            ArrayList<ASN1ObjectIdentifier> sortedOids = new ArrayList<ASN1ObjectIdentifier>(controls.size());
            if (keepRdnOrder) {
                for (RdnControl rdnControl : controls) {
                    sortedOids.add(rdnControl.getType());
                }
            } else {
                HashSet<ASN1ObjectIdentifier> oidSet = new HashSet<ASN1ObjectIdentifier>();
                for (RdnControl rdnControl : controls) {
                    oidSet.add(rdnControl.getType());
                }
                List<ASN1ObjectIdentifier> list = SubjectDnSpec.getForwardDNs();
                for (ASN1ObjectIdentifier oid : list) {
                    if (!oidSet.contains(oid)) continue;
                    sortedOids.add(oid);
                }
                for (ASN1ObjectIdentifier oid : oidSet) {
                    if (sortedOids.contains(oid)) continue;
                    sortedOids.add(oid);
                }
            }
            this.types = Collections.unmodifiableList(sortedOids);
            HashSet<String> groupSet = new HashSet<String>();
            this.groupTypes = new HashMap<String, Set<ASN1ObjectIdentifier>>();
            this.controls = new HashMap<ASN1ObjectIdentifier, RdnControl>();
            for (RdnControl rdnControl : controls) {
                ASN1ObjectIdentifier type = rdnControl.getType();
                this.controls.put(type, rdnControl);
                String group = rdnControl.getGroup();
                if (StringUtil.isBlank((String)group)) continue;
                groupSet.add(group);
                this.typeGroups.put(type, group);
                Set<ASN1ObjectIdentifier> typeSet = this.groupTypes.get(group);
                if (typeSet == null) {
                    typeSet = new HashSet<ASN1ObjectIdentifier>();
                    this.groupTypes.put(group, typeSet);
                }
                typeSet.add(type);
            }
            this.groups = Collections.unmodifiableSet(groupSet);
        }

        public RdnControl getControl(ASN1ObjectIdentifier type) {
            Args.notNull((Object)type, (String)"type");
            return this.controls.isEmpty() ? SubjectDnSpec.getRdnControl(type) : this.controls.get(type);
        }

        public String getGroup(ASN1ObjectIdentifier type) {
            return this.typeGroups.get(Args.notNull((Object)type, (String)"type"));
        }

        public Set<ASN1ObjectIdentifier> getTypesForGroup(String group) {
            return this.groupTypes.get(Args.notNull((Object)group, (String)"group"));
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public List<ASN1ObjectIdentifier> getTypes() {
            return this.types;
        }
    }

    public static enum StringType {
        teletexString,
        printableString,
        utf8String,
        bmpString,
        ia5String;


        public ASN1Encodable createString(String text) {
            Args.notNull((Object)text, (String)"text");
            if (teletexString == this) {
                return new DERT61String(text);
            }
            if (printableString == this) {
                return new DERPrintableString(text);
            }
            if (utf8String == this) {
                return new DERUTF8String(text);
            }
            if (bmpString == this) {
                return new DERBMPString(text);
            }
            if (ia5String == this) {
                return new DERIA5String(text, true);
            }
            throw new IllegalStateException("should not reach here, unknown StringType " + this.name());
        }
    }

    public static class RdnControl {
        private final int minOccurs;
        private final int maxOccurs;
        private final ASN1ObjectIdentifier type;
        private Pattern pattern;
        private StringType stringType;
        private Range stringLengthRange;
        private String prefix;
        private String suffix;
        private String group;

        public RdnControl(ASN1ObjectIdentifier type) {
            this(type, 1, 1);
        }

        public RdnControl(ASN1ObjectIdentifier type, int minOccurs, int maxOccurs) {
            if (minOccurs < 0 || maxOccurs < 1 || minOccurs > maxOccurs) {
                throw new IllegalArgumentException(String.format("illegal minOccurs=%s, maxOccurs=%s", minOccurs, maxOccurs));
            }
            this.type = (ASN1ObjectIdentifier)Args.notNull((Object)type, (String)"type");
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
        }

        public int getMinOccurs() {
            return this.minOccurs;
        }

        public int getMaxOccurs() {
            return this.maxOccurs;
        }

        public ASN1ObjectIdentifier getType() {
            return this.type;
        }

        public StringType getStringType() {
            return this.stringType;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Range getStringLengthRange() {
            return this.stringLengthRange;
        }

        public void setStringType(StringType stringType) {
            this.stringType = stringType;
        }

        public void setStringLengthRange(Range stringLengthRange) {
            this.stringLengthRange = stringLengthRange;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }
    }

    public static class KeyUsageControl {
        private final KeyUsage keyUsage;
        private final boolean required;

        public KeyUsageControl(KeyUsage keyUsage, boolean required) {
            this.keyUsage = (KeyUsage)Args.notNull((Object)keyUsage, (String)"keyUsage");
            this.required = required;
        }

        public KeyUsage getKeyUsage() {
            return this.keyUsage;
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    public static class GeneralNameMode {
        private final GeneralNameTag tag;
        private final Set<ASN1ObjectIdentifier> allowedTypes;

        public GeneralNameMode(GeneralNameTag tag) {
            this.tag = (GeneralNameTag)((Object)Args.notNull((Object)((Object)tag), (String)"tag"));
            this.allowedTypes = null;
        }

        public GeneralNameMode(GeneralNameTag tag, Set<ASN1ObjectIdentifier> allowedTypes) {
            this.tag = (GeneralNameTag)((Object)Args.notNull((Object)((Object)tag), (String)"tag"));
            this.allowedTypes = CollectionUtil.isEmpty(allowedTypes) ? Collections.emptySet() : CollectionUtil.unmodifiableSet(allowedTypes);
        }

        public GeneralNameTag getTag() {
            return this.tag;
        }

        public Set<ASN1ObjectIdentifier> getAllowedTypes() {
            return this.allowedTypes;
        }
    }

    public static enum GeneralNameTag {
        otherName(0),
        rfc822Name(1),
        DNSName(2),
        x400Adress(3),
        directoryName(4),
        ediPartyName(5),
        uniformResourceIdentifier(6),
        IPAddress(7),
        registeredID(8);

        private final int tag;

        private GeneralNameTag(int tag) {
            this.tag = tag;
        }

        public int getTag() {
            return this.tag;
        }
    }

    public static class ExtKeyUsageControl {
        private final ASN1ObjectIdentifier extKeyUsage;
        private final boolean required;

        public ExtKeyUsageControl(ASN1ObjectIdentifier extKeyUsage, boolean required) {
            this.extKeyUsage = (ASN1ObjectIdentifier)Args.notNull((Object)extKeyUsage, (String)"extKeyUsage");
            this.required = required;
        }

        public ASN1ObjectIdentifier getExtKeyUsage() {
            return this.extKeyUsage;
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    public static class ExtensionControl {
        private final boolean critical;
        private final boolean required;
        private final boolean request;

        public ExtensionControl(boolean critical, boolean required, boolean request) {
            this.critical = critical;
            this.required = required;
            this.request = request;
        }

        public boolean isCritical() {
            return this.critical;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isRequest() {
            return this.request;
        }
    }

    public static class CertValidity
    implements Comparable<CertValidity> {
        private static final long SECOND = 1000L;
        private static final long MINUTE = 60000L;
        private static final long HOUR = 3600000L;
        private static final long DAY = 86400000L;
        private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
        private int validity;
        private Unit unit;

        private CertValidity() {
        }

        public CertValidity(int validity, Unit unit) {
            this.validity = Args.positive((int)validity, (String)"validity");
            this.unit = (Unit)((Object)Args.notNull((Object)((Object)unit), (String)"unit"));
        }

        public static CertValidity getInstance(String validityS) {
            int validity;
            String numValdityS;
            Unit unit;
            Args.notBlank((String)validityS, (String)"validityS");
            int len = validityS.length();
            char suffix = validityS.charAt(len - 1);
            if (suffix == 'y' || suffix == 'Y') {
                unit = Unit.YEAR;
                numValdityS = validityS.substring(0, len - 1);
            } else if (suffix == 'd' || suffix == 'D') {
                unit = Unit.DAY;
                numValdityS = validityS.substring(0, len - 1);
            } else if (suffix == 'h' || suffix == 'H') {
                unit = Unit.HOUR;
                numValdityS = validityS.substring(0, len - 1);
            } else if (suffix == 'm' || suffix == 'M') {
                unit = Unit.MINUTE;
                numValdityS = validityS.substring(0, len - 1);
            } else if (suffix >= '0' && suffix <= '9') {
                unit = Unit.DAY;
                numValdityS = validityS;
            } else {
                throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
            }
            try {
                validity = Integer.parseInt(numValdityS);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
            }
            return new CertValidity(validity, unit);
        }

        public void setValidity(int validity) {
            this.validity = Args.positive((int)validity, (String)"validity");
        }

        public int getValidity() {
            return this.validity;
        }

        public void setUnit(Unit unit) {
            this.unit = (Unit)((Object)Args.notNull((Object)((Object)unit), (String)"unit"));
        }

        public Unit getUnit() {
            return this.unit;
        }

        public Date add(Date referenceDate) {
            switch (this.unit) {
                case DAY: {
                    return new Date(referenceDate.getTime() + 86400000L - 1000L);
                }
                case YEAR: {
                    int day;
                    Calendar cal = Calendar.getInstance(TIMEZONE_UTC);
                    cal.setTime(referenceDate);
                    cal.add(1, this.validity);
                    cal.add(13, -1);
                    int month = cal.get(2);
                    if (month == 1 && (day = cal.get(5)) > 28) {
                        int year = cal.get(1);
                        day = CertValidity.isLeapYear(year) ? 29 : 28;
                    }
                    return cal.getTime();
                }
                case HOUR: {
                    return new Date(referenceDate.getTime() + 3600000L - 1000L);
                }
                case MINUTE: {
                    return new Date(referenceDate.getTime() + 60000L - 1000L);
                }
            }
            throw new IllegalStateException(String.format("should not reach here, unknown CertValidity.Unit %s", new Object[]{this.unit}));
        }

        private int approxMinutes() {
            switch (this.unit) {
                case HOUR: {
                    return 60 * this.validity;
                }
                case DAY: {
                    return 1440 * this.validity;
                }
                case YEAR: {
                    return (8760 * this.validity + 6 * this.validity) * 60;
                }
            }
            throw new IllegalStateException(String.format("should not reach here, unknown CertValidity.Unit %s", new Object[]{this.unit}));
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public int compareTo(CertValidity obj) {
            int thatMinutes;
            Args.notNull((Object)obj, (String)"obj");
            if (this.unit == obj.unit) {
                if (this.validity == obj.validity) {
                    return 0;
                }
                return this.validity < obj.validity ? -1 : 1;
            }
            int thisMinutes = this.approxMinutes();
            if (thisMinutes == (thatMinutes = obj.approxMinutes())) {
                return 0;
            }
            return thisMinutes < thatMinutes ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CertValidity)) {
                return false;
            }
            CertValidity other = (CertValidity)obj;
            return this.unit == other.unit && this.validity == other.validity;
        }

        public String toString() {
            switch (this.unit) {
                case HOUR: {
                    return this.validity + "h";
                }
                case DAY: {
                    return this.validity + "d";
                }
                case YEAR: {
                    return this.validity + "y";
                }
            }
            throw new IllegalStateException(String.format("should not reach here, unknown CertValidity.Unit %s", new Object[]{this.unit}));
        }

        private static boolean isLeapYear(int year) {
            if (year % 4 != 0) {
                return false;
            }
            if (year % 100 != 0) {
                return true;
            }
            return year % 400 == 0;
        }

        public static enum Unit {
            YEAR("y"),
            DAY("d"),
            HOUR("h"),
            MINUTE("m");

            private String suffix;

            private Unit(String suffix) {
                this.suffix = suffix;
            }

            public String getSuffix() {
                return this.suffix;
            }
        }
    }

    public static enum CertLevel {
        RootCA,
        SubCA,
        EndEntity;

    }

    public static class AuthorityInfoAccessControl {
        private final boolean includesCaIssuers;
        private final boolean includesOcsp;

        public AuthorityInfoAccessControl(boolean includesCaIssuers, boolean includesOcsp) {
            this.includesCaIssuers = includesCaIssuers;
            this.includesOcsp = includesOcsp;
        }

        public boolean isIncludesCaIssuers() {
            return this.includesCaIssuers;
        }

        public boolean isIncludesOcsp() {
            return this.includesOcsp;
        }
    }
}

