/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.Range;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class SubjectDnSpec {
    private static final Logger LOG;
    public static final Pattern PATTERN_DATE_OF_BIRTH;
    private static final Range RANGE_64;
    private static final Range RANGE_128;
    private static final Range RANGE_POSTAL_CODE;
    private static final Range RANGE_COUNTRY_NAME;
    private static final Range RANGE_POSTAL_ADDRESS;
    private static final Range RANGE_GENDER;
    private static final Range RANGE_DATE_OF_BIRTH;
    private static final Range RANGE_NAME;
    private static final Pattern PATTERN_GENDER;
    private static final Pattern PATTERN_COUNTRY;
    private static final Set<Certprofile.StringType> DIRECTORY_STRINGS;
    private static final Set<Certprofile.StringType> PRINTABLE_STRING_ONLY;
    private static final Set<Certprofile.StringType> IA5_STRING_ONLY;
    private static final Map<ASN1ObjectIdentifier, Certprofile.StringType> DFLT_STRING_TYPES;
    private static final Map<ASN1ObjectIdentifier, Range> RANGES;
    private static final Map<ASN1ObjectIdentifier, Pattern> PATTERNS;
    private static final Map<ASN1ObjectIdentifier, Certprofile.RdnControl> CONTROLS;
    private static final Map<ASN1ObjectIdentifier, Set<Certprofile.StringType>> STRING_TYPE_SET;
    private static final List<ASN1ObjectIdentifier> FORWARD_DNS;
    private static final Set<String> COUNTRY_AREA_CODES;

    private SubjectDnSpec() {
    }

    public static Range getStringLengthRange(ASN1ObjectIdentifier rdnType) {
        return RANGES.get(Args.notNull((Object)rdnType, (String)"rdnType"));
    }

    public static Pattern getPattern(ASN1ObjectIdentifier rdnType) {
        return PATTERNS.get(Args.notNull((Object)rdnType, (String)"rdnType"));
    }

    public static Certprofile.StringType getStringType(ASN1ObjectIdentifier rdnType) {
        return DFLT_STRING_TYPES.get(Args.notNull((Object)rdnType, (String)"rdnType"));
    }

    public static Certprofile.RdnControl getRdnControl(ASN1ObjectIdentifier rdnType) {
        Certprofile.RdnControl control = CONTROLS.get(Args.notNull((Object)rdnType, (String)"rdnType"));
        if (control == null) {
            control = new Certprofile.RdnControl(rdnType, 0, 9);
            control.setStringType(Certprofile.StringType.utf8String);
        }
        return control;
    }

    public static void fixRdnControl(Certprofile.RdnControl control) throws CertprofileException {
        Range specRange;
        Args.notNull((Object)control, (String)"control");
        ASN1ObjectIdentifier type = control.getType();
        Certprofile.StringType stringType = control.getStringType();
        if (stringType != null) {
            if (STRING_TYPE_SET.containsKey(type) && !STRING_TYPE_SET.get(type).contains((Object)stringType)) {
                throw new CertprofileException(String.format("%s is not allowed %s", stringType.name(), type.getId()));
            }
        } else {
            Certprofile.StringType specStrType = DFLT_STRING_TYPES.get(type);
            if (specStrType != null) {
                control.setStringType(specStrType);
            }
        }
        if (control.getPattern() == null && PATTERNS.containsKey(type)) {
            control.setPattern(PATTERNS.get(type));
        }
        if ((specRange = RANGES.get(type)) == null) {
            control.setStringLengthRange(null);
            return;
        }
        Range isRange = control.getStringLengthRange();
        if (isRange == null) {
            control.setStringLengthRange(specRange);
            return;
        }
        boolean changed = false;
        Integer specMin = specRange.getMin();
        Integer min = isRange.getMin();
        if (min == null) {
            changed = true;
            min = specMin;
        } else if (specMin != null && specMin > min) {
            changed = true;
            min = specMin;
        }
        Integer specMax = specRange.getMax();
        Integer max = isRange.getMax();
        if (max == null) {
            changed = true;
            max = specMax;
        } else if (specMax != null && specMax < max) {
            changed = true;
            max = specMax;
        }
        if (changed) {
            isRange.setRange(min, max);
        }
    }

    public static List<ASN1ObjectIdentifier> getForwardDNs() {
        return FORWARD_DNS;
    }

    public static boolean isValidCountryAreaCode(String code) {
        Args.notBlank((String)code, (String)"code");
        return COUNTRY_AREA_CODES.isEmpty() ? true : COUNTRY_AREA_CODES.contains(code.toUpperCase());
    }

    private static BufferedReader getReader(String propKey, String fallbackResource) {
        String confFile = System.getProperty(propKey);
        if (StringUtil.isNotBlank((String)confFile)) {
            LOG.info("read from file " + confFile);
            try {
                return Files.newBufferedReader(Paths.get(confFile, new String[0]));
            }
            catch (IOException ex) {
                throw new IllegalStateException("could not access non-existing file " + confFile);
            }
        }
        InputStream confStream = SubjectDnSpec.class.getResourceAsStream(fallbackResource);
        if (confStream == null) {
            throw new IllegalStateException("could not access non-existing resource " + fallbackResource);
        }
        LOG.info("read from resource " + fallbackResource);
        return new BufferedReader(new InputStreamReader(confStream));
    }

    static {
        String line;
        LOG = LoggerFactory.getLogger(SubjectDnSpec.class);
        PATTERN_DATE_OF_BIRTH = Pattern.compile("^(19|20)\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])120000Z");
        RANGE_64 = new Range(1, 64);
        RANGE_128 = new Range(1, 128);
        RANGE_POSTAL_CODE = new Range(1, 40);
        RANGE_COUNTRY_NAME = new Range(2, 2);
        RANGE_POSTAL_ADDRESS = new Range(0, 30);
        RANGE_GENDER = new Range(1, 1);
        RANGE_DATE_OF_BIRTH = new Range(15, 15);
        RANGE_NAME = new Range(1, 256);
        PATTERN_GENDER = Pattern.compile("M|m|F|f");
        PATTERN_COUNTRY = Pattern.compile("[A-Za-z]{2}");
        DIRECTORY_STRINGS = new HashSet<Certprofile.StringType>(Arrays.asList(Certprofile.StringType.bmpString, Certprofile.StringType.printableString, Certprofile.StringType.teletexString, Certprofile.StringType.utf8String));
        PRINTABLE_STRING_ONLY = new HashSet<Certprofile.StringType>(Arrays.asList(Certprofile.StringType.printableString));
        IA5_STRING_ONLY = new HashSet<Certprofile.StringType>(Arrays.asList(Certprofile.StringType.ia5String));
        DFLT_STRING_TYPES = new HashMap<ASN1ObjectIdentifier, Certprofile.StringType>();
        RANGES = new HashMap<ASN1ObjectIdentifier, Range>();
        PATTERNS = new HashMap<ASN1ObjectIdentifier, Pattern>();
        CONTROLS = new HashMap<ASN1ObjectIdentifier, Certprofile.RdnControl>();
        STRING_TYPE_SET = new HashMap<ASN1ObjectIdentifier, Set<Certprofile.StringType>>();
        COUNTRY_AREA_CODES = new HashSet<String>();
        BufferedReader reader = SubjectDnSpec.getReader("org.xipki.ca.rdnorder.cfg", "/conf/rdnorder.cfg");
        ArrayList<ASN1ObjectIdentifier> tmpForwardDNs = new ArrayList<ASN1ObjectIdentifier>(25);
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(line);
                tmpForwardDNs.add(oid);
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(new Exception("could not load RDN order: " + ex.getMessage(), ex));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        FORWARD_DNS = Collections.unmodifiableList(tmpForwardDNs);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("forward RDNs: ");
            for (ASN1ObjectIdentifier oid : FORWARD_DNS) {
                String desc = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
                if (desc == null) {
                    sb.append(oid.getId());
                    continue;
                }
                sb.append(desc).append(" (").append(oid.getId()).append("), ");
            }
            if (!FORWARD_DNS.isEmpty()) {
                sb.delete(sb.length() - 2, sb.length());
            }
            LOG.info(sb.toString());
        }
        ArrayList tmpBackwardDNs = new ArrayList(25);
        int size = tmpForwardDNs.size();
        for (int i = size - 1; i >= 0; --i) {
            tmpBackwardDNs.add(tmpForwardDNs.get(i));
        }
        reader = SubjectDnSpec.getReader("org.xipki.ca.areacode.cfg", "/conf/areacode.cfg");
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, ";");
                int n = st.countTokens();
                if (n != 4) {
                    LOG.warn("invalid country/area line {}", (Object)line);
                    continue;
                }
                st.nextToken();
                String areaCode = st.nextToken().trim();
                COUNTRY_AREA_CODES.add(areaCode.toUpperCase());
            }
            if (LOG.isInfoEnabled()) {
                ArrayList<String> list = new ArrayList<String>(COUNTRY_AREA_CODES);
                Collections.sort(list);
                LOG.info("area/country codes: {}", list);
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(new Exception("could not load area code: " + ex.getMessage(), ex));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        HashSet<ASN1ObjectIdentifier> ids = new HashSet<ASN1ObjectIdentifier>();
        ASN1ObjectIdentifier id = ObjectIdentifiers.DN_BUSINESS_CATEGORY;
        ids.add(id);
        RANGES.put(id, RANGE_128);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_C;
        ids.add(id);
        RANGES.put(id, RANGE_COUNTRY_NAME);
        STRING_TYPE_SET.put(id, PRINTABLE_STRING_ONLY);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.printableString);
        id = ObjectIdentifiers.DN_CN;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_COUNTRY_OF_CITIZENSHIP;
        ids.add(id);
        RANGES.put(id, RANGE_COUNTRY_NAME);
        PATTERNS.put(id, PATTERN_COUNTRY);
        STRING_TYPE_SET.put(id, PRINTABLE_STRING_ONLY);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.printableString);
        id = ObjectIdentifiers.DN_COUNTRY_OF_RESIDENCE;
        ids.add(id);
        RANGES.put(id, RANGE_COUNTRY_NAME);
        PATTERNS.put(id, PATTERN_COUNTRY);
        STRING_TYPE_SET.put(id, PRINTABLE_STRING_ONLY);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.printableString);
        id = ObjectIdentifiers.DN_DATE_OF_BIRTH;
        ids.add(id);
        RANGES.put(id, RANGE_DATE_OF_BIRTH);
        PATTERNS.put(id, PATTERN_DATE_OF_BIRTH);
        id = ObjectIdentifiers.DN_DC;
        ids.add(id);
        STRING_TYPE_SET.put(id, IA5_STRING_ONLY);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.ia5String);
        id = ObjectIdentifiers.DN_DMD_NAME;
        ids.add(id);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_GENDER;
        ids.add(id);
        PATTERNS.put(id, PATTERN_GENDER);
        RANGES.put(id, RANGE_GENDER);
        STRING_TYPE_SET.put(id, PRINTABLE_STRING_ONLY);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.printableString);
        id = ObjectIdentifiers.DN_GENERATION_QUALIFIER;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_GIVENNAME;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_INITIALS;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_LDAP_UID;
        ids.add(id);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_LOCALITYNAME;
        ids.add(id);
        RANGES.put(id, RANGE_128);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_NAME;
        ids.add(id);
        RANGES.put(id, RANGE_NAME);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_NAME_AT_BIRTH;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_O;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_organizationIdentifier;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_OU;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_PLACE_OF_BIRTH;
        ids.add(id);
        RANGES.put(id, RANGE_128);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_POSTAL_ADDRESS;
        ids.add(id);
        RANGES.put(id, RANGE_POSTAL_ADDRESS);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_POSTAL_CODE;
        ids.add(id);
        RANGES.put(id, RANGE_POSTAL_CODE);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_PSEUDONYM;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_QUALIFIER;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, PRINTABLE_STRING_ONLY);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.printableString);
        id = ObjectIdentifiers.DN_SERIALNUMBER;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, PRINTABLE_STRING_ONLY);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.printableString);
        id = ObjectIdentifiers.DN_ST;
        ids.add(id);
        RANGES.put(id, RANGE_128);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_STREET;
        ids.add(id);
        RANGES.put(id, RANGE_128);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_SURNAME;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_T;
        ids.add(id);
        RANGES.put(id, RANGE_64);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_TELEPHONE_NUMBER;
        ids.add(id);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_UNIQUE_IDENTIFIER;
        ids.add(id);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_UnstructuredAddress;
        ids.add(id);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        id = ObjectIdentifiers.DN_UnstructuredName;
        ids.add(id);
        STRING_TYPE_SET.put(id, DIRECTORY_STRINGS);
        DFLT_STRING_TYPES.put(id, Certprofile.StringType.utf8String);
        for (ASN1ObjectIdentifier type : ids) {
            Certprofile.StringType stringType = DFLT_STRING_TYPES.get(type);
            if (stringType == null) {
                stringType = Certprofile.StringType.utf8String;
            }
            Certprofile.RdnControl control = new Certprofile.RdnControl(type, 0, 9);
            control.setStringType(stringType);
            control.setStringLengthRange(RANGES.get(type));
            Pattern pattern = PATTERNS.get(type);
            if (pattern != null) {
                control.setPattern(pattern);
            }
            CONTROLS.put(type, control);
        }
    }
}

