/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.StringUtil;

public class ScepControl {
    public static final String KEY_CACERT_INCLUDED = "cacert.included";
    public static final String KEY_SIGNERCERT_INCLUDED = "signercert.included";
    public static final String KEY_SUPPORT_GETCRL = "support.getcrl";
    private boolean includeCaCert = true;
    private boolean includeSignerCert = true;
    private boolean supportGetCrl = false;

    public ScepControl(String conf) throws InvalidConfException {
        ConfPairs props;
        if (StringUtil.isBlank((String)conf)) {
            return;
        }
        try {
            props = new ConfPairs(conf);
        }
        catch (RuntimeException ex) {
            throw new InvalidConfException(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
        this.includeCaCert = ScepControl.getBoolean(props, KEY_CACERT_INCLUDED, true);
        this.includeSignerCert = ScepControl.getBoolean(props, KEY_SIGNERCERT_INCLUDED, true);
        this.supportGetCrl = ScepControl.getBoolean(props, KEY_SUPPORT_GETCRL, false);
    }

    public String getConf() {
        ConfPairs pairs = new ConfPairs();
        pairs.putPair(KEY_CACERT_INCLUDED, Boolean.toString(this.includeCaCert));
        pairs.putPair(KEY_SIGNERCERT_INCLUDED, Boolean.toString(this.includeSignerCert));
        pairs.putPair(KEY_SUPPORT_GETCRL, Boolean.toString(this.supportGetCrl));
        return pairs.getEncoded();
    }

    public boolean isIncludeCaCert() {
        return this.includeCaCert;
    }

    public void setIncludeCaCert(boolean includeCaCert) {
        this.includeCaCert = includeCaCert;
    }

    public boolean isIncludeSignerCert() {
        return this.includeSignerCert;
    }

    public void setIncludeSignerCert(boolean includeSignerCert) {
        this.includeSignerCert = includeSignerCert;
    }

    public boolean isSupportGetCrl() {
        return this.supportGetCrl;
    }

    public void setSupportGetCrl(boolean supportGetCrl) {
        this.supportGetCrl = supportGetCrl;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        return StringUtil.concatObjects((Object)"  include CA cert: ", (Object[])new Object[]{this.includeCaCert, "\n  include signer cert: ", this.includeSignerCert, "\n  operation GetCRL: ", this.supportGetCrl ? "supported" : "not supported", verbose ? "\n  encoded: " : "", verbose ? this.getConf() : ""});
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScepControl)) {
            return false;
        }
        ScepControl obj2 = (ScepControl)obj;
        return this.includeCaCert == obj2.includeCaCert && this.includeSignerCert == obj2.includeSignerCert;
    }

    private static boolean getBoolean(ConfPairs props, String propKey, boolean dfltValue) throws InvalidConfException {
        String str = props.value(propKey);
        if (str != null) {
            if ("true".equalsIgnoreCase(str = str.trim())) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            throw new InvalidConfException(propKey + " does not have boolean value: " + str);
        }
        return dfltValue;
    }
}

