/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.Range;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class KeyParametersOption {
    public static final AllowAllParametersOption ALLOW_ALL = new AllowAllParametersOption();

    private KeyParametersOption() {
    }

    public static class GostParametersOption
    extends KeyParametersOption {
        private Set<ASN1ObjectIdentifier> publicKeyParamSets;
        private Set<ASN1ObjectIdentifier> digestParamSets;
        private Set<ASN1ObjectIdentifier> encryptionParamSets;

        public void setPublicKeyParamSets(Set<ASN1ObjectIdentifier> publicKeyParamSets) {
            this.publicKeyParamSets = CollectionUtil.isEmpty(publicKeyParamSets) ? null : new HashSet<ASN1ObjectIdentifier>(publicKeyParamSets);
        }

        public void setDigestParamSets(Set<ASN1ObjectIdentifier> digestParamSets) {
            this.digestParamSets = CollectionUtil.isEmpty(digestParamSets) ? null : new HashSet<ASN1ObjectIdentifier>(digestParamSets);
        }

        public void setEncryptionParamSets(Set<ASN1ObjectIdentifier> encryptionParamSets) {
            this.encryptionParamSets = CollectionUtil.isEmpty(encryptionParamSets) ? null : new HashSet<ASN1ObjectIdentifier>(encryptionParamSets);
        }

        public boolean allowsPublicKeyParamSet(ASN1ObjectIdentifier oid) {
            return this.publicKeyParamSets == null ? true : this.publicKeyParamSets.contains(Args.notNull((Object)oid, (String)"oid"));
        }

        public boolean allowsDigestParamSet(ASN1ObjectIdentifier oid) {
            return this.digestParamSets == null ? true : this.digestParamSets.contains(Args.notNull((Object)oid, (String)"oid"));
        }

        public boolean allowsEncryptionParamSet(ASN1ObjectIdentifier oid) {
            return this.encryptionParamSets == null ? true : this.encryptionParamSets.contains(Args.notNull((Object)oid, (String)"oid"));
        }
    }

    public static class ECParamatersOption
    extends KeyParametersOption {
        private Set<ASN1ObjectIdentifier> curveOids;
        private Set<Byte> pointEncodings;

        public Set<ASN1ObjectIdentifier> curveOids() {
            return this.curveOids;
        }

        public void setCurveOids(Set<ASN1ObjectIdentifier> curveOids) {
            this.curveOids = curveOids;
        }

        public Set<Byte> pointEncodings() {
            return this.pointEncodings;
        }

        public void setPointEncodings(Set<Byte> pointEncodings) {
            this.pointEncodings = pointEncodings;
        }

        public boolean allowsCurve(ASN1ObjectIdentifier curveOid) {
            Args.notNull((Object)curveOid, (String)"curveOid");
            return this.curveOids == null ? true : this.curveOids.contains(curveOid);
        }

        public boolean allowsPointEncoding(byte encoding) {
            return this.pointEncodings == null ? true : this.pointEncodings.contains(encoding);
        }
    }

    public static class DSAParametersOption
    extends KeyParametersOption {
        private Set<Range> plengths;
        private Set<Range> qlengths;

        public void setPlengths(Set<Range> plengths) {
            this.plengths = CollectionUtil.isEmpty(plengths) ? null : new HashSet<Range>(plengths);
        }

        public void setQlengths(Set<Range> qlengths) {
            this.qlengths = CollectionUtil.isEmpty(qlengths) ? null : new HashSet<Range>(qlengths);
        }

        public boolean allowsPlength(int plength) {
            if (this.plengths == null) {
                return true;
            }
            for (Range range : this.plengths) {
                if (!range.match(plength)) continue;
                return true;
            }
            return false;
        }

        public boolean allowsQlength(int qlength) {
            if (this.qlengths == null) {
                return true;
            }
            for (Range range : this.qlengths) {
                if (!range.match(qlength)) continue;
                return true;
            }
            return false;
        }
    }

    public static class RSAPSSParametersOption
    extends RSAParametersOption {
        private Set<ASN1ObjectIdentifier> hashAlgs;
        private Set<ASN1ObjectIdentifier> maskGenAlgs;
        private Set<Integer> saltLengths;
        private Set<Integer> trailerFields;

        public void setHashAlgs(Set<ASN1ObjectIdentifier> hashAlgs) {
            this.hashAlgs = CollectionUtil.isEmpty(hashAlgs) ? null : new HashSet<ASN1ObjectIdentifier>(hashAlgs);
        }

        public void setMaskGenAlgs(Set<ASN1ObjectIdentifier> maskGenAlgs) {
            this.maskGenAlgs = CollectionUtil.isEmpty(maskGenAlgs) ? null : new HashSet<ASN1ObjectIdentifier>(maskGenAlgs);
        }

        public void setSaltLengths(Set<Integer> saltLengths) {
            this.saltLengths = CollectionUtil.isEmpty(saltLengths) ? null : new HashSet<Integer>(saltLengths);
        }

        public void setTrailerFields(Set<Integer> trailerFields) {
            this.trailerFields = CollectionUtil.isEmpty(trailerFields) ? null : new HashSet<Integer>(trailerFields);
        }

        public boolean allowsHashAlg(ASN1ObjectIdentifier hashAlg) {
            return this.hashAlgs == null ? true : this.hashAlgs.contains(hashAlg);
        }

        public boolean allowsMaskGenAlg(ASN1ObjectIdentifier maskGenAlg) {
            return this.maskGenAlgs == null ? true : this.maskGenAlgs.contains(maskGenAlg);
        }

        public boolean allowsSaltLength(int saltLength) {
            return this.saltLengths == null ? true : this.saltLengths.contains(saltLength);
        }

        public boolean allowsTrailerField(int trailerField) {
            return this.trailerFields == null ? true : this.trailerFields.contains(trailerField);
        }
    }

    public static class RSAParametersOption
    extends KeyParametersOption {
        private Set<Range> modulusLengths;

        public void setModulusLengths(Set<Range> modulusLengths) {
            this.modulusLengths = CollectionUtil.isEmpty(modulusLengths) ? null : new HashSet<Range>(modulusLengths);
        }

        public boolean allowsModulusLength(int modulusLength) {
            if (this.modulusLengths == null) {
                return true;
            }
            for (Range range : this.modulusLengths) {
                if (!range.match(modulusLength)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AllowAllParametersOption
    extends KeyParametersOption {
    }
}

