/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtLogControl;
import org.xipki.ca.api.mgmt.InternUtil;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public abstract class MgmtEntry {

    public static class User
    extends MgmtEntry {
        private NameId ident;
        private boolean active;
        private String hashedPassword;

        private User() {
        }

        public User(NameId ident, boolean active, String hashedPassword) throws CaMgmtException {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            this.active = active;
            this.hashedPassword = Args.notBlank((String)hashedPassword, (String)"hashedPassword");
        }

        public void setIdent(NameId ident) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        public NameId getIdent() {
            return this.ident;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setHashedPassword(String hashedPassword) {
            this.hashedPassword = Args.notBlank((String)hashedPassword, (String)"hashedPassword");
        }

        public String getHashedPassword() {
            return this.hashedPassword;
        }

        public int hashCode() {
            return this.ident.hashCode() + 31 + this.hashedPassword.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof User)) {
                return false;
            }
            return this.equals((User)obj, false);
        }

        public boolean equals(User obj, boolean ignoreId) {
            if (!this.ident.equals(obj.ident, ignoreId)) {
                return false;
            }
            return this.hashedPassword.equals(obj.hashedPassword);
        }

        public String toString() {
            return StringUtil.concatObjectsCap((int)200, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nactive: ", this.active, "\npassword: *****\n"});
        }
    }

    public static class Signer
    extends MgmtEntry {
        private final String name;
        private final String type;
        private String conf;
        private boolean certFaulty;
        private boolean confFaulty;
        private final String base64Cert;
        private X509Certificate certificate;

        public Signer(String name, String type, String conf, String base64Cert) {
            this.name = Args.toNonBlankLower((String)name, (String)"name");
            this.type = Args.toNonBlankLower((String)type, (String)"type");
            this.conf = conf;
            this.base64Cert = base64Cert;
            if (base64Cert == null) {
                return;
            }
            try {
                this.certificate = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)base64Cert));
            }
            catch (Throwable th) {
                this.certFaulty = true;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setConf(String conf) {
            this.conf = conf;
        }

        public String getConf() {
            return this.conf;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public void setCertificate(X509Certificate certificate) {
            if (this.base64Cert != null) {
                throw new IllegalStateException("certificate is already specified by base64Cert");
            }
            this.certificate = certificate;
        }

        public String getBase64Cert() {
            return this.base64Cert;
        }

        public boolean isFaulty() {
            return this.confFaulty || this.certFaulty;
        }

        public void setConfFaulty(boolean confFaulty) {
            this.confFaulty = confFaulty;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean verbose) {
            return this.toString(verbose, true);
        }

        public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("name: ").append(this.name).append('\n');
            sb.append("faulty: ").append(this.isFaulty()).append('\n');
            sb.append("type: ").append(this.type).append('\n');
            sb.append("conf: ");
            if (this.conf == null) {
                sb.append("null");
            } else {
                sb.append(InternUtil.signerConfToString(this.conf, verbose, ignoreSensitiveInfo));
            }
            sb.append('\n');
            sb.append("certificate: ").append("\n");
            if (this.certificate != null || this.base64Cert != null) {
                if (this.certificate != null) {
                    sb.append("\tissuer: ").append(X509Util.getRfc4519Name((X500Principal)this.certificate.getIssuerX500Principal())).append('\n');
                    sb.append("\tserialNumber: ").append(LogUtil.formatCsn((BigInteger)this.certificate.getSerialNumber())).append('\n');
                    sb.append("\tsubject: ").append(X509Util.getRfc4519Name((X500Principal)this.certificate.getSubjectX500Principal()));
                }
                if (verbose) {
                    sb.append("\n\tencoded: ");
                    try {
                        sb.append(Base64.encodeToString((byte[])this.certificate.getEncoded()));
                    }
                    catch (CertificateEncodingException ex) {
                        sb.append("ERROR");
                    }
                }
            } else {
                sb.append("  null");
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Signer)) {
                return false;
            }
            Signer objB = (Signer)obj;
            return this.name.equals(objB.name) && this.type.equals(objB.type) && CompareUtil.equalsObject((Object)this.conf, (Object)objB.conf) && CompareUtil.equalsObject((Object)this.base64Cert, (Object)objB.base64Cert);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class Requestor
    extends MgmtEntry {
        public static final String TYPE_CERT = "cert";
        public static final String TYPE_PBM = "pbm";
        private NameId ident;
        private String type;
        private String conf;
        private boolean faulty;

        private Requestor() {
        }

        public Requestor(NameId ident, String type, String conf) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            String name = ident.getName();
            if ("BY-USER".equalsIgnoreCase(name) || "BY-CA".equalsIgnoreCase(name)) {
                throw new IllegalArgumentException("Requestor name could not be " + name);
            }
            this.type = Args.notBlank((String)type, (String)"type");
            this.conf = Args.notBlank((String)conf, (String)"conf");
        }

        public void setIdent(NameId ident) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            String name = ident.getName();
            if ("BY-USER".equalsIgnoreCase(name) || "BY-CA".equalsIgnoreCase(name)) {
                throw new IllegalArgumentException("Requestor name could not be " + name);
            }
        }

        public void setType(String type) {
            this.type = Args.notBlank((String)type, (String)"type");
        }

        public void setConf(String conf) {
            this.conf = Args.notBlank((String)conf, (String)"conf");
        }

        public NameId getIdent() {
            return this.ident;
        }

        public String getType() {
            return this.type;
        }

        public String getConf() {
            return this.conf;
        }

        public void setFaulty(boolean faulty) {
            this.faulty = faulty;
        }

        public boolean isFaulty() {
            return this.faulty;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean verbose) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("id: ").append(this.ident.getId());
            sb.append("\nname: ").append(this.ident.getName());
            sb.append("\ntype: ").append(this.type);
            sb.append("\nconf: ");
            if (verbose || this.conf.length() < 101) {
                sb.append(this.conf);
            } else {
                sb.append(this.conf.substring(0, 97)).append("...");
            }
            sb.append("\nfaulty: ").append(this.faulty).append('\n');
            if (!this.faulty && TYPE_CERT.equalsIgnoreCase(this.type)) {
                try {
                    X509Certificate cert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)this.conf));
                    sb.append("cert:");
                    sb.append("\n\tissuer: ").append(X509Util.getRfc4519Name((X500Principal)cert.getIssuerX500Principal()));
                    sb.append("\n\tserialNumber: ").append(LogUtil.formatCsn((BigInteger)cert.getSerialNumber()));
                    sb.append("\n\tsubject: ").append(X509Util.getRfc4519Name((X500Principal)cert.getSubjectX500Principal())).append('\n');
                }
                catch (CertificateException ex) {
                    sb.append("cert: ERROR(").append(ex.getMessage()).append(")\n");
                }
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Requestor)) {
                return false;
            }
            return this.equals((Requestor)obj, false);
        }

        public boolean equals(Requestor obj, boolean ignoreId) {
            return obj != null && this.ident.equals(obj.ident, ignoreId) && this.type.equals(obj.type) && this.conf.equals(obj.conf);
        }

        public int hashCode() {
            return this.ident.hashCode();
        }
    }

    public static class Publisher
    extends MgmtEntry {
        private NameId ident;
        private String type;
        private String conf;
        private boolean faulty;

        private Publisher() {
        }

        public Publisher(NameId ident, String type, String conf) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            this.type = Args.toNonBlankLower((String)type, (String)"type");
            this.conf = conf;
        }

        public void setIdent(NameId ident) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        public NameId getIdent() {
            return this.ident;
        }

        public void setType(String type) {
            this.type = Args.toNonBlankLower((String)type, (String)"type");
        }

        public String getType() {
            return this.type;
        }

        public void setConf(String conf) {
            this.conf = conf;
        }

        public String getConf() {
            return this.conf;
        }

        public boolean isFaulty() {
            return this.faulty;
        }

        public void setFaulty(boolean faulty) {
            this.faulty = faulty;
        }

        public String toString() {
            return StringUtil.concatObjectsCap((int)200, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nfaulty: ", this.faulty, "\ntype: ", this.type, "\nconf: ", this.conf});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Publisher)) {
                return false;
            }
            return this.equals((Publisher)obj, false);
        }

        public boolean equals(Publisher obj, boolean ignoreId) {
            return obj != null && this.ident.equals(obj.ident, ignoreId) && this.type.equals(obj.type) && CompareUtil.equalsObject((Object)this.conf, (Object)obj.conf);
        }

        public int hashCode() {
            return this.ident.hashCode();
        }
    }

    public static class ChangeUser
    extends MgmtEntry {
        private NameId ident;
        private Boolean active;
        private String password;

        private ChangeUser() {
        }

        public ChangeUser(NameId ident) throws CaMgmtException {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        public void setIdent(NameId ident) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        public NameId getIdent() {
            return this.ident;
        }

        public Boolean getActive() {
            return this.active;
        }

        public void setActive(Boolean active) {
            this.active = active;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class ChangeCa
    extends MgmtEntry {
        private NameId ident;
        private CaStatus status;
        private Validity maxValidity;
        private String signerType;
        private String signerConf;
        private String cmpControl;
        private String crlControl;
        private String scepControl;
        private String ctLogControl;
        private String cmpResponderName;
        private String scepResponderName;
        private String crlSignerName;
        private Boolean duplicateKeyPermitted;
        private Boolean duplicateSubjectPermitted;
        private Boolean supportCmp;
        private Boolean supportRest;
        private Boolean supportScep;
        private Boolean saveRequest;
        private ValidityMode validityMode;
        private Integer permission;
        private Integer keepExpiredCertInDays;
        private Integer expirationPeriod;
        private ConfPairs extraControl;
        private CaUris caUris;
        private byte[] encodedCert;
        private List<byte[]> encodedCertchain;
        private Integer numCrls;
        private Integer serialNoBitLen;

        private ChangeCa() {
        }

        public ChangeCa(NameId ident) throws CaMgmtException {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        public void setIdent(NameId ident) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        public NameId getIdent() {
            return this.ident;
        }

        public CaStatus getStatus() {
            return this.status;
        }

        public void setStatus(CaStatus status) {
            this.status = status;
        }

        public Validity getMaxValidity() {
            return this.maxValidity;
        }

        public void setMaxValidity(Validity maxValidity) {
            this.maxValidity = maxValidity;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setSignerType(String signerType) {
            this.signerType = signerType == null ? null : signerType.toLowerCase();
        }

        public String getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(String signerConf) {
            this.signerConf = signerConf;
        }

        public String getCmpControl() {
            return this.cmpControl;
        }

        public void setCmpControl(String cmpControl) {
            this.cmpControl = cmpControl;
        }

        public String getCrlControl() {
            return this.crlControl;
        }

        public void setCrlControl(String crlControl) {
            this.crlControl = crlControl;
        }

        public String getScepControl() {
            return this.scepControl;
        }

        public void setScepControl(String scepControl) {
            this.scepControl = scepControl;
        }

        public String getCtLogControl() {
            return this.ctLogControl;
        }

        public void setCtLogControl(String ctLogControl) {
            this.ctLogControl = ctLogControl;
        }

        public String getCmpResponderName() {
            return this.cmpResponderName;
        }

        public void setCmpResponderName(String responderName) {
            this.cmpResponderName = responderName == null ? null : responderName.toLowerCase();
        }

        public String getScepResponderName() {
            return this.scepResponderName;
        }

        public void setScepResponderName(String responderName) {
            this.scepResponderName = responderName == null ? null : responderName.toLowerCase();
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName == null ? null : crlSignerName.toLowerCase();
        }

        public Boolean getDuplicateKeyPermitted() {
            return this.duplicateKeyPermitted;
        }

        public void setDuplicateKeyPermitted(Boolean duplicateKeyPermitted) {
            this.duplicateKeyPermitted = duplicateKeyPermitted;
        }

        public Boolean getDuplicateSubjectPermitted() {
            return this.duplicateSubjectPermitted;
        }

        public void setDuplicateSubjectPermitted(Boolean duplicateSubjectPermitted) {
            this.duplicateSubjectPermitted = duplicateSubjectPermitted;
        }

        public ValidityMode getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(ValidityMode validityMode) {
            this.validityMode = validityMode;
        }

        public Boolean getSupportCmp() {
            return this.supportCmp;
        }

        public void setSupportCmp(Boolean supportCmp) {
            this.supportCmp = supportCmp;
        }

        public Boolean getSupportRest() {
            return this.supportRest;
        }

        public void setSupportRest(Boolean supportRest) {
            this.supportRest = supportRest;
        }

        public Boolean getSupportScep() {
            return this.supportScep;
        }

        public void setSupportScep(Boolean supportScep) {
            this.supportScep = supportScep;
        }

        public Boolean getSaveRequest() {
            return this.saveRequest;
        }

        public void setSaveRequest(Boolean saveRequest) {
            this.saveRequest = saveRequest;
        }

        public Integer getPermission() {
            return this.permission;
        }

        public void setPermission(Integer permission) {
            this.permission = permission;
        }

        public Integer getExpirationPeriod() {
            return this.expirationPeriod;
        }

        public void setExpirationPeriod(Integer expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        public Integer getKeepExpiredCertInDays() {
            return this.keepExpiredCertInDays;
        }

        public void setKeepExpiredCertInDays(Integer days) {
            this.keepExpiredCertInDays = days;
        }

        public ConfPairs getExtraControl() {
            return this.extraControl;
        }

        public void setExtraControl(ConfPairs extraControl) {
            this.extraControl = extraControl;
        }

        public Integer getSerialNoBitLen() {
            return this.serialNoBitLen;
        }

        public void setSerialNoBitLen(Integer serialNoBitLen) {
            if (serialNoBitLen != null) {
                Args.range((int)serialNoBitLen, (String)"serialNoBitLen", (int)71, (int)159);
            }
            this.serialNoBitLen = serialNoBitLen;
        }

        public CaUris getCaUris() {
            return this.caUris;
        }

        public void setCaUris(CaUris caUris) {
            this.caUris = caUris;
        }

        public byte[] getEncodedCert() {
            return this.encodedCert;
        }

        public void setEncodedCert(byte[] encodedCert) {
            this.encodedCert = encodedCert;
        }

        public List<byte[]> getEncodedCertchain() {
            return this.encodedCertchain;
        }

        public void setEncodedCertchain(List<byte[]> encodedCertchain) {
            this.encodedCertchain = encodedCertchain;
        }

        public Integer getNumCrls() {
            return this.numCrls;
        }

        public void setNumCrls(Integer numCrls) {
            this.numCrls = numCrls;
        }
    }

    public static class Certprofile
    extends MgmtEntry {
        private NameId ident;
        private String type;
        private String conf;
        private boolean faulty;

        private Certprofile() {
        }

        public Certprofile(NameId ident, String type, String conf) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            this.type = Args.toNonBlankLower((String)type, (String)"type");
            this.conf = conf;
            if ("all".equalsIgnoreCase(ident.getName()) || "null".equalsIgnoreCase(ident.getName())) {
                throw new IllegalArgumentException("certificate profile name may not be 'all' and 'null'");
            }
        }

        public void setIdent(NameId ident) {
            if ("all".equalsIgnoreCase(ident.getName()) || "null".equalsIgnoreCase(ident.getName())) {
                throw new IllegalArgumentException("certificate profile name may not be 'all' and 'null'");
            }
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        public void setType(String type) {
            this.type = Args.toNonBlankLower((String)type, (String)"type");
        }

        public void setConf(String conf) {
            this.conf = conf;
        }

        public NameId getIdent() {
            return this.ident;
        }

        public String getType() {
            return this.type;
        }

        public String getConf() {
            return this.conf;
        }

        public boolean isFaulty() {
            return this.faulty;
        }

        public void setFaulty(boolean faulty) {
            this.faulty = faulty;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean verbose) {
            boolean bo = verbose || this.conf == null || this.conf.length() < 301;
            return StringUtil.concatObjectsCap((int)200, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nfaulty: ", this.faulty, "\ntype: ", this.type, "\nconf: ", bo ? this.conf : StringUtil.concat((String)this.conf.substring(0, 297), (String[])new String[]{"..."})});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Certprofile)) {
                return false;
            }
            return this.equals((Certprofile)obj, false);
        }

        public boolean equals(Certprofile obj, boolean ignoreId) {
            if (!this.ident.equals(obj.ident, ignoreId)) {
                return false;
            }
            if (!this.type.equals(obj.type)) {
                return false;
            }
            return CompareUtil.equalsObject((Object)this.conf, (Object)obj.conf);
        }

        public int hashCode() {
            return this.ident.hashCode();
        }
    }

    public static class CaHasUser
    extends MgmtEntry {
        private NameId userIdent;
        private int permission;
        private Set<String> profiles;

        private CaHasUser() {
        }

        public CaHasUser(NameId userIdent) {
            this.userIdent = (NameId)Args.notNull((Object)userIdent, (String)"userIdent");
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public void setUserIdent(NameId userIdent) {
            this.userIdent = userIdent;
        }

        public NameId getUserIdent() {
            return this.userIdent;
        }

        public void setProfiles(Set<String> profiles) {
            this.profiles = CollectionUtil.unmodifiableSet((Set)CollectionUtil.toLowerCaseSet(profiles));
        }

        public Set<String> getProfiles() {
            return this.profiles;
        }

        public String toString() {
            return StringUtil.concatObjectsCap((int)200, (Object)"user: ", (Object[])new Object[]{this.userIdent, "\nprofiles: ", this.profiles, "\npermission: ", PermissionConstants.permissionToString(this.permission)});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CaHasUser)) {
                return false;
            }
            return this.equals((CaHasUser)obj, false);
        }

        public boolean equals(CaHasUser obj, boolean ignoreId) {
            return obj != null && this.userIdent.equals(obj.userIdent, ignoreId) && this.permission == obj.permission && CompareUtil.equalsObject(this.profiles, obj.profiles);
        }

        public int hashCode() {
            return this.userIdent.hashCode();
        }
    }

    public static class CaHasRequestor
    extends MgmtEntry {
        private NameId requestorIdent;
        private boolean ra;
        private int permission;
        private Set<String> profiles;

        private CaHasRequestor() {
        }

        public CaHasRequestor(NameId requestorIdent) {
            this.requestorIdent = (NameId)Args.notNull((Object)requestorIdent, (String)"requestorIdent");
        }

        public boolean isRa() {
            return this.ra;
        }

        public void setRa(boolean ra) {
            this.ra = ra;
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public NameId getRequestorIdent() {
            return this.requestorIdent;
        }

        public void setRequestorIdent(NameId requestorIdent) {
            this.requestorIdent = requestorIdent;
        }

        public void setProfiles(Set<String> profiles) {
            this.profiles = CollectionUtil.isEmpty(profiles) ? Collections.emptySet() : CollectionUtil.unmodifiableSet((Set)CollectionUtil.toLowerCaseSet(profiles));
        }

        public Set<String> getProfiles() {
            return this.profiles;
        }

        public boolean isCertprofilePermitted(String certprofile) {
            if (CollectionUtil.isEmpty(this.profiles)) {
                return false;
            }
            return this.profiles.contains("all") || this.profiles.contains(certprofile.toLowerCase());
        }

        public boolean isPermitted(int permission) {
            return PermissionConstants.contains(this.permission, permission);
        }

        public String toString() {
            return StringUtil.concatObjectsCap((int)200, (Object)"requestor: ", (Object[])new Object[]{this.requestorIdent, "\nra: ", this.ra, "\nprofiles: ", this.profiles, "\npermission: ", PermissionConstants.permissionToString(this.permission)});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CaHasRequestor)) {
                return false;
            }
            return this.equals((CaHasRequestor)obj, false);
        }

        public boolean equals(CaHasRequestor obj, boolean ignoreId) {
            return obj != null && this.ra == obj.ra && this.requestorIdent.equals(obj.requestorIdent, ignoreId) && this.permission == obj.permission && CompareUtil.equalsObject(this.profiles, obj.profiles);
        }

        public int hashCode() {
            return this.requestorIdent.hashCode();
        }
    }

    public static class Ca
    extends MgmtEntry {
        private NameId ident;
        private CaStatus status;
        private Validity maxValidity;
        private String signerType;
        private String signerConf;
        private ScepControl scepControl;
        private CrlControl crlControl;
        private String crlSignerName;
        private CmpControl cmpControl;
        private CtLogControl ctLogControl;
        private String cmpResponderName;
        private String scepResponderName;
        private boolean duplicateKeyPermitted;
        private boolean duplicateSubjectPermitted;
        private ProtocolSupport protocolSupport;
        private boolean saveRequest;
        private ValidityMode validityMode = ValidityMode.STRICT;
        private int permission;
        private int expirationPeriod;
        private int keepExpiredCertInDays;
        private ConfPairs extraControl;
        private CaUris caUris;
        private X509Certificate cert;
        private List<X509Certificate> certchain;
        private int serialNoBitLen;
        private long nextCrlNumber;
        private int numCrls;
        private CertRevocationInfo revocationInfo;
        private String subject;
        private String hexSha1OfCert;

        private Ca() {
        }

        public Ca(NameId ident, int serialNoBitLen, long nextCrlNumber, String signerType, String signerConf, CaUris caUris, int numCrls, int expirationPeriod) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            this.signerType = Args.toNonBlankLower((String)signerType, (String)"signerType");
            this.expirationPeriod = Args.notNegative((int)expirationPeriod, (String)"expirationPeriod");
            this.signerConf = Args.notBlank((String)signerConf, (String)"signerConf");
            this.numCrls = Args.positive((int)numCrls, (String)"numCrls");
            this.serialNoBitLen = Args.range((int)serialNoBitLen, (String)"serialNoBitLen", (int)71, (int)159);
            this.nextCrlNumber = Args.positive((long)nextCrlNumber, (String)"nextCrlNumber");
            this.caUris = caUris == null ? CaUris.EMPTY_INSTANCE : caUris;
        }

        public static List<String[]> splitCaSignerConfs(String conf) throws XiSecurityException {
            ConfPairs pairs = new ConfPairs(conf);
            String str = pairs.value("algo");
            if (str == null) {
                throw new XiSecurityException("no algo is defined in CA signerConf");
            }
            List list = StringUtil.split((String)str, (String)":");
            if (CollectionUtil.isEmpty((Collection)list)) {
                throw new XiSecurityException("empty algo is defined in CA signerConf");
            }
            ArrayList<String[]> signerConfs = new ArrayList<String[]>(list.size());
            for (String n : list) {
                String c14nAlgo;
                try {
                    c14nAlgo = AlgorithmUtil.canonicalizeSignatureAlgo((String)n);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
                }
                pairs.putPair("algo", c14nAlgo);
                signerConfs.add(new String[]{c14nAlgo, pairs.getEncoded()});
            }
            return signerConfs;
        }

        public NameId getIdent() {
            return this.ident;
        }

        public Validity getMaxValidity() {
            return this.maxValidity;
        }

        public void setMaxValidity(Validity maxValidity) {
            this.maxValidity = maxValidity;
        }

        public int getKeepExpiredCertInDays() {
            return this.keepExpiredCertInDays;
        }

        public void setKeepExpiredCertInDays(int days) {
            this.keepExpiredCertInDays = days;
        }

        public void setSignerConf(String signerConf) {
            this.signerConf = Args.notBlank((String)signerConf, (String)"signerConf");
        }

        public String getSignerConf() {
            return this.signerConf;
        }

        public CaStatus getStatus() {
            return this.status;
        }

        public void setStatus(CaStatus status) {
            this.status = status;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setCmpControl(CmpControl cmpControl) {
            this.cmpControl = cmpControl;
        }

        public CmpControl getCmpControl() {
            return this.cmpControl;
        }

        public void setCrlControl(CrlControl crlControl) {
            this.crlControl = crlControl;
        }

        public CrlControl getCrlControl() {
            return this.crlControl;
        }

        public void setScepControl(ScepControl scepControl) {
            this.scepControl = scepControl;
        }

        public ScepControl getScepControl() {
            return this.scepControl;
        }

        public CtLogControl getCtLogControl() {
            return this.ctLogControl;
        }

        public void setCtLogControl(CtLogControl ctLogControl) {
            this.ctLogControl = ctLogControl;
        }

        public String getCmpResponderName() {
            return this.cmpResponderName;
        }

        public void setCmpResponderName(String cmpResponderName) {
            this.cmpResponderName = cmpResponderName == null ? null : cmpResponderName.toLowerCase();
        }

        public String getScepResponderName() {
            return this.scepResponderName;
        }

        public void setScepResponderName(String scepResponderName) {
            this.scepResponderName = scepResponderName == null ? null : scepResponderName.toLowerCase();
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName == null ? null : crlSignerName.toLowerCase();
        }

        public boolean isDuplicateKeyPermitted() {
            return this.duplicateKeyPermitted;
        }

        public void setDuplicateKeyPermitted(boolean duplicateKeyPermitted) {
            this.duplicateKeyPermitted = duplicateKeyPermitted;
        }

        public boolean isDuplicateSubjectPermitted() {
            return this.duplicateSubjectPermitted;
        }

        public void setDuplicateSubjectPermitted(boolean duplicateSubjectPermitted) {
            this.duplicateSubjectPermitted = duplicateSubjectPermitted;
        }

        public ProtocolSupport getProtocoSupport() {
            return this.protocolSupport;
        }

        public void setProtocolSupport(ProtocolSupport protocolSupport) {
            this.protocolSupport = protocolSupport;
        }

        public boolean isSaveRequest() {
            return this.saveRequest;
        }

        public void setSaveRequest(boolean saveRequest) {
            this.saveRequest = saveRequest;
        }

        public ValidityMode getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(ValidityMode mode) {
            this.validityMode = (ValidityMode)((Object)Args.notNull((Object)((Object)mode), (String)"mode"));
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public int getExpirationPeriod() {
            return this.expirationPeriod;
        }

        public ConfPairs getExtraControl() {
            return this.extraControl;
        }

        public void setExtraControl(ConfPairs extraControl) {
            this.extraControl = extraControl;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean verbose) {
            return this.toString(verbose, true);
        }

        public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
            String extraCtrlText;
            if (this.extraControl == null) {
                extraCtrlText = "null";
            } else {
                extraCtrlText = this.extraControl.getEncoded();
                if (!verbose && extraCtrlText.length() > 100) {
                    extraCtrlText = StringUtil.concat((String)extraCtrlText.substring(0, 97), (String[])new String[]{"..."});
                }
            }
            String revInfoText = "";
            if (this.revocationInfo != null) {
                revInfoText = StringUtil.concatObjectsCap((int)30, (Object)"\n\treason: ", (Object[])new Object[]{this.revocationInfo.getReason().getDescription(), "\n\trevoked at ", this.revocationInfo.getRevocationTime()});
            }
            int certchainSize = this.certchain == null ? 0 : this.certchain.size();
            StringBuilder certchainStr = new StringBuilder(20 + certchainSize * 200);
            certchainStr.append("\ncertchain: ");
            if (certchainSize > 0) {
                for (int i = 0; i < certchainSize; ++i) {
                    certchainStr.append("\ncert[").append(i).append("]:\n");
                    certchainStr.append(InternUtil.formatCert(this.certchain.get(i), verbose));
                }
            } else {
                certchainStr.append("null");
            }
            return StringUtil.concatObjectsCap((int)1500, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nstatus: ", this.status == null ? "null" : this.status.getStatus(), "\nmax. validity: ", this.maxValidity, "\nexpiration period: ", this.expirationPeriod, " days", "\nsigner type: ", this.signerType, "\nsigner conf: ", this.signerConf == null ? "null" : InternUtil.signerConfToString(this.signerConf, verbose, ignoreSensitiveInfo), "\nCMP control:\n", this.cmpControl == null ? "  null" : this.cmpControl.toString(verbose), "\nCRL control:\n", this.crlControl == null ? "  null" : this.crlControl.toString(verbose), "\nSCEP control: \n", this.scepControl == null ? "  null" : this.scepControl.toString(verbose), "\nCTLog control: ", this.ctLogControl == null ? "  null" : this.ctLogControl.toString(), "\nCMP responder name: ", this.cmpResponderName, "\nSCEP responder name: ", this.scepResponderName, "\nCRL signer name: ", this.crlSignerName, "\nduplicate key: ", this.duplicateKeyPermitted, "\nduplicate subject: ", this.duplicateSubjectPermitted, "\n", this.protocolSupport, "\nsave request: ", this.saveRequest, "\nvalidity mode: ", this.validityMode, "\npermission: ", PermissionConstants.permissionToString(this.permission), "\nkeep expired certs: ", this.keepExpiredCertInDays < 0 ? "forever" : this.keepExpiredCertInDays + " days", "\nextra control: ", extraCtrlText, "\nserial number bit length: ", this.serialNoBitLen, "\nnext CRL number: ", this.nextCrlNumber, "\n", this.caUris, "\nrevocation: ", this.revocationInfo == null ? "not revoked" : "revoked", revInfoText, "\ncert: \n", InternUtil.formatCert(this.cert, verbose), certchainStr.toString()});
        }

        protected static String urisToString(Collection<? extends Object> tokens) {
            if (CollectionUtil.isEmpty(tokens)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int size = tokens.size();
            int idx = 0;
            for (Object object : tokens) {
                sb.append(object);
                if (idx++ >= size - 1) continue;
                sb.append(" ");
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Ca)) {
                return false;
            }
            return this.equals((Ca)obj, false, false);
        }

        public boolean equals(Ca obj, boolean ignoreDynamicFields, boolean ignoreId) {
            if (!ignoreDynamicFields && this.nextCrlNumber != obj.nextCrlNumber) {
                return false;
            }
            return this.ident.equals(obj.ident, ignoreId) && this.signerType.equals(obj.signerType) && CompareUtil.equalsObject((Object)((Object)this.status), (Object)((Object)obj.status)) && CompareUtil.equalsObject((Object)this.protocolSupport, (Object)obj.protocolSupport) && CompareUtil.equalsObject((Object)this.maxValidity, (Object)obj.maxValidity) && CompareUtil.equalsObject((Object)this.cmpControl, (Object)obj.cmpControl) && CompareUtil.equalsObject((Object)this.crlControl, (Object)obj.crlControl) && CompareUtil.equalsObject((Object)this.scepControl, (Object)obj.scepControl) && CompareUtil.equalsObject((Object)this.cmpResponderName, (Object)obj.cmpResponderName) && CompareUtil.equalsObject((Object)this.scepResponderName, (Object)obj.scepResponderName) && CompareUtil.equalsObject((Object)this.crlSignerName, (Object)obj.crlSignerName) && this.duplicateKeyPermitted == obj.duplicateKeyPermitted && this.duplicateSubjectPermitted == obj.duplicateSubjectPermitted && this.saveRequest == obj.saveRequest && CompareUtil.equalsObject((Object)((Object)this.validityMode), (Object)((Object)obj.validityMode)) && this.permission == obj.permission && this.expirationPeriod == obj.expirationPeriod && this.keepExpiredCertInDays == obj.keepExpiredCertInDays && CompareUtil.equalsObject((Object)this.extraControl, (Object)obj.extraControl) && CompareUtil.equalsObject((Object)this.caUris, (Object)obj.caUris) && CompareUtil.equalsObject((Object)this.cert, (Object)obj.cert) && this.serialNoBitLen == obj.serialNoBitLen && this.numCrls == obj.numCrls && CompareUtil.equalsObject((Object)this.revocationInfo, (Object)obj.revocationInfo);
        }

        public int hashCode() {
            return this.ident.hashCode();
        }

        public void setCert(X509Certificate cert) throws CaMgmtException {
            if (cert == null) {
                this.cert = null;
                this.subject = null;
                this.hexSha1OfCert = null;
            } else {
                byte[] encodedCert;
                if (!X509Util.hasKeyusage((X509Certificate)cert, (KeyUsage)KeyUsage.keyCertSign)) {
                    throw new CaMgmtException("CA certificate does not have keyusage keyCertSign");
                }
                this.cert = cert;
                this.subject = X509Util.getRfc4519Name((X500Principal)cert.getSubjectX500Principal());
                try {
                    encodedCert = cert.getEncoded();
                }
                catch (CertificateEncodingException ex) {
                    throw new CaMgmtException("could not encoded certificate", ex);
                }
                this.hexSha1OfCert = HashAlgo.SHA1.hexHash(encodedCert);
            }
        }

        public int getSerialNoBitLen() {
            return this.serialNoBitLen;
        }

        public void setSerialNoBitLen(int serialNoBitLen) {
            this.serialNoBitLen = Args.range((int)serialNoBitLen, (String)"serialNoBitLen", (int)71, (int)159);
        }

        public long getNextCrlNumber() {
            return this.nextCrlNumber;
        }

        public void setNextCrlNumber(long crlNumber) {
            this.nextCrlNumber = crlNumber;
        }

        public CaUris getCaUris() {
            return this.caUris;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public List<X509Certificate> getCertchain() {
            return this.certchain;
        }

        public void setCertchain(List<X509Certificate> certchain) {
            this.certchain = certchain;
        }

        public int getNumCrls() {
            return this.numCrls;
        }

        public CertRevocationInfo getRevocationInfo() {
            return this.revocationInfo;
        }

        public void setRevocationInfo(CertRevocationInfo revocationInfo) {
            this.revocationInfo = revocationInfo;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getHexSha1OfCert() {
            return this.hexSha1OfCert;
        }
    }

    public static class AddUser
    extends MgmtEntry {
        private NameId ident;
        private boolean active;
        private String password;

        private AddUser() {
        }

        public AddUser(NameId ident, boolean active, String password) throws CaMgmtException {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            this.active = active;
            this.password = Args.notBlank((String)password, (String)"password");
        }

        public void setIdent(NameId ident) {
            this.ident = ident;
        }

        public NameId getIdent() {
            return this.ident;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public String toString() {
            return StringUtil.concatObjectsCap((int)200, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nactive: ", this.active, "\npassword: ****\n"});
        }
    }
}

