/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.Set;
import java.util.StringTokenizer;
import org.xipki.util.StringUtil;

public class ProtocolSupport {
    private static final String CMP = "cmp";
    private static final String REST = "rest";
    private static final String SCEP = "scep";
    private boolean cmp;
    private boolean rest;
    private boolean scep;

    private ProtocolSupport() {
    }

    public ProtocolSupport(Set<String> protocols) {
        if (protocols == null) {
            return;
        }
        for (String protocol : protocols) {
            if (CMP.equalsIgnoreCase(protocol)) {
                this.cmp = true;
                continue;
            }
            if (REST.equalsIgnoreCase(protocol)) {
                this.rest = true;
                continue;
            }
            if (!SCEP.equalsIgnoreCase(protocol)) continue;
            this.scep = true;
        }
    }

    public ProtocolSupport(String encoded) {
        if (StringUtil.isBlank((String)encoded)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(encoded, ",");
        while (st.hasMoreTokens()) {
            String protocol = st.nextToken();
            if (CMP.equalsIgnoreCase(protocol)) {
                this.cmp = true;
                continue;
            }
            if (REST.equalsIgnoreCase(protocol)) {
                this.rest = true;
                continue;
            }
            if (!SCEP.equalsIgnoreCase(protocol)) continue;
            this.scep = true;
        }
    }

    public ProtocolSupport(boolean cmp, boolean rest, boolean scep) {
        this.cmp = cmp;
        this.rest = rest;
        this.scep = scep;
    }

    public boolean isCmp() {
        return this.cmp;
    }

    public void setCmp(boolean cmp) {
        this.cmp = cmp;
    }

    public boolean isRest() {
        return this.rest;
    }

    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public boolean isScep() {
        return this.scep;
    }

    public void setScep(boolean scep) {
        this.scep = scep;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtocolSupport)) {
            return false;
        }
        ProtocolSupport other = (ProtocolSupport)obj;
        return this.cmp == other.cmp && this.rest == other.rest && this.scep == other.scep;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Supported protocols:");
        sb.append("\n  CMP:").append(this.cmp);
        sb.append("\n  REST:").append(this.rest);
        sb.append("\n  SCEP:").append(this.scep);
        return sb.toString();
    }

    public String getEncoded() {
        StringBuilder st = new StringBuilder(15);
        if (this.cmp) {
            st.append(CMP).append(",");
        }
        if (this.rest) {
            st.append(REST).append(",");
        }
        if (this.scep) {
            st.append(SCEP).append(",");
        }
        return st.length() == 0 ? "" : st.deleteCharAt(st.length() - 1).toString();
    }
}

