/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.Validity;

public class CaConf {
    private static final Logger LOG = LoggerFactory.getLogger(CaConf.class);
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, MgmtEntry.Signer> signers = new HashMap<String, MgmtEntry.Signer>();
    private final Map<String, MgmtEntry.Requestor> requestors = new HashMap<String, MgmtEntry.Requestor>();
    private final Map<String, Object> users = new HashMap<String, Object>();
    private final Map<String, MgmtEntry.Publisher> publishers = new HashMap<String, MgmtEntry.Publisher>();
    private final Map<String, MgmtEntry.Certprofile> certprofiles = new HashMap<String, MgmtEntry.Certprofile>();
    private final Map<String, SingleCa> cas = new HashMap<String, SingleCa>();

    public CaConf(File confFile, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        confFile = IoUtil.expandFilepath((File)((File)Args.notNull((Object)confFile, (String)"confFile")));
        this.init(Files.newInputStream(confFile.toPath(), new OpenOption[0]), securityFactory);
    }

    public CaConf(InputStream confFileZipStream, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        Args.notNull((Object)confFileZipStream, (String)"confFileZipStream");
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.init(confFileZipStream, securityFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(InputStream zipFileStream, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        ZipInputStream zipStream = new ZipInputStream(zipFileStream);
        try {
            ZipEntry zipEntry;
            HashMap<String, byte[]> zipEntries = new HashMap<String, byte[]>();
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                byte[] zipEntryBytes = CaConf.read(zipStream);
                zipEntries.put(zipEntry.getName(), zipEntryBytes);
            }
            CaConfType.CaSystem root = (CaConfType.CaSystem)((Object)JSON.parseObject((byte[])((byte[])zipEntries.get("caconf.json")), CaConfType.CaSystem.class, (Feature[])new Feature[0]));
            root.validate();
            this.init0(root, zipEntries, securityFactory);
        }
        finally {
            try {
                zipFileStream.close();
            }
            catch (IOException ex) {
                LOG.info("could not clonse zipFileStream", (Object)ex.getMessage());
            }
            try {
                zipStream.close();
            }
            catch (IOException ex) {
                LOG.info("could not clonse zipStream", (Object)ex.getMessage());
            }
        }
    }

    private final void init0(CaConfType.CaSystem root, Map<String, byte[]> zipEntries, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        if (root.getProperties() != null) {
            this.properties.putAll(root.getProperties());
        }
        if (root.getSigners() != null) {
            for (CaConfType.Signer signer : root.getSigners()) {
                MgmtEntry.Signer en = new MgmtEntry.Signer(signer.getName(), this.expandConf(signer.getType()), this.getValue(signer.getConf(), zipEntries), this.getBase64Binary(signer.getCert(), zipEntries));
                this.addSigner(en);
            }
        }
        if (root.getRequestors() != null) {
            for (CaConfType.Requestor requestor : root.getRequestors()) {
                String conf = requestor.getConf() != null ? this.getValue(requestor.getConf(), zipEntries) : this.getBase64Binary(requestor.getBinaryConf(), zipEntries);
                MgmtEntry.Requestor en = new MgmtEntry.Requestor(new NameId(null, requestor.getName()), requestor.getType(), conf);
                this.addRequestor(en);
            }
        }
        if (root.getUsers() != null) {
            for (CaConfType.User user : root.getUsers()) {
                MgmtEntry en;
                boolean active = user.isActive();
                String password = user.getPassword();
                if (password != null) {
                    en = new MgmtEntry.AddUser(new NameId(null, user.getName()), active, password);
                    this.addUser((MgmtEntry.AddUser)en);
                    continue;
                }
                en = new MgmtEntry.User(new NameId(null, user.getName()), active, user.getHashedPassword());
                this.addUser((MgmtEntry.User)en);
            }
        }
        if (root.getPublishers() != null) {
            for (CaConfType.NameTypeConf nameTypeConf : root.getPublishers()) {
                MgmtEntry.Publisher en = new MgmtEntry.Publisher(new NameId(null, nameTypeConf.getName()), this.expandConf(nameTypeConf.getType()), this.getValue(nameTypeConf.getConf(), zipEntries));
                this.addPublisher(en);
            }
        }
        if (root.getProfiles() != null) {
            for (CaConfType.NameTypeConf nameTypeConf : root.getProfiles()) {
                MgmtEntry.Certprofile en = new MgmtEntry.Certprofile(new NameId(null, nameTypeConf.getName()), this.expandConf(nameTypeConf.getType()), this.getValue(nameTypeConf.getConf(), zipEntries));
                this.addProfile(en);
            }
        }
        if (root.getCas() != null) {
            for (CaConfType.Ca ca : root.getCas()) {
                String name = ca.getName();
                GenSelfIssued genSelfIssued = null;
                MgmtEntry.Ca caEntry = null;
                if (ca.getCaInfo() != null) {
                    Object caUris;
                    CaConfType.CaInfo ci = ca.getCaInfo();
                    if (ci.getGenSelfIssued() != null) {
                        if (ci.getCert() != null) {
                            throw new InvalidConfException("cert.file of CA " + name + " may not be set");
                        }
                        byte[] csr = this.getBinary(ci.getGenSelfIssued().getCsr(), zipEntries);
                        BigInteger serialNumber = null;
                        String str = ci.getGenSelfIssued().getSerialNumber();
                        if (str != null) {
                            serialNumber = str.startsWith("0x") || str.startsWith("0X") ? new BigInteger(str.substring(2), 16) : new BigInteger(str);
                        }
                        genSelfIssued = new GenSelfIssued(ci.getGenSelfIssued().getProfile(), csr, serialNumber, ci.getGenSelfIssued().getCertOutform());
                    }
                    if (ci.getCaUris() == null) {
                        caUris = CaUris.EMPTY_INSTANCE;
                    } else {
                        CaConfType.CaUris uris = ci.getCaUris();
                        caUris = new CaUris(uris.getCacertUris(), uris.getOcspUris(), uris.getCrlUris(), uris.getDeltacrlUris());
                    }
                    int exprirationPeriod = ci.getExpirationPeriod() == null ? 365 : ci.getExpirationPeriod();
                    int numCrls = ci.getNumCrls() == null ? 30 : ci.getNumCrls();
                    caEntry = new MgmtEntry.Ca(new NameId(null, name), ci.getSnSize(), ci.getNextCrlNo(), this.expandConf(ci.getSignerType()), this.getValue(ci.getSignerConf(), zipEntries), (CaUris)caUris, numCrls, exprirationPeriod);
                    if (CollectionUtil.isNonEmpty(ci.getCmpControl())) {
                        caEntry.setCmpControl(new CmpControl(new ConfPairs(ci.getCmpControl()).getEncoded()));
                    }
                    if (ci.getCrlControl() != null) {
                        caEntry.setCrlControl(new CrlControl(new ConfPairs(ci.getCrlControl()).getEncoded()));
                    }
                    if (ci.getScepControl() != null) {
                        caEntry.setScepControl(new ScepControl(new ConfPairs(ci.getScepControl()).getEncoded()));
                    }
                    if (ci.getCtlogControl() != null) {
                        caEntry.setCtlogControl(new CtlogControl(new ConfPairs(ci.getCtlogControl()).getEncoded()));
                    }
                    caEntry.setCmpResponderName(ci.getCmpResponderName());
                    caEntry.setScepResponderName(ci.getScepResponderName());
                    caEntry.setCrlSignerName(ci.getCrlSignerName());
                    caEntry.setDuplicateKeyPermitted(ci.isDuplicateKey());
                    caEntry.setDuplicateSubjectPermitted(ci.isDuplicateSubject());
                    if (ci.getExtraControl() != null) {
                        caEntry.setExtraControl(new ConfPairs(ci.getExtraControl()).unmodifiable());
                    }
                    int keepExpiredCertDays = ci.getKeepExpiredCertDays() == null ? -1 : ci.getKeepExpiredCertDays();
                    caEntry.setKeepExpiredCertInDays(keepExpiredCertDays);
                    caEntry.setMaxValidity(Validity.getInstance((String)ci.getMaxValidity()));
                    caEntry.setPermission(CaConf.getIntPermission(ci.getPermissions()));
                    if (ci.getProtocolSupport() != null) {
                        caEntry.setProtocolSupport(new ProtocolSupport(ci.getProtocolSupport()));
                    }
                    if (ci.getDhpocControl() != null) {
                        caEntry.setDhpocControl(this.getValue(ci.getDhpocControl(), zipEntries));
                    }
                    if (ci.getRevokeSuspendedControl() != null) {
                        caEntry.setRevokeSuspendedControl(new RevokeSuspendedControl(new ConfPairs(ci.getRevokeSuspendedControl())));
                    }
                    caEntry.setSaveRequest(ci.isSaveReq());
                    caEntry.setStatus(CaStatus.forName(ci.getStatus()));
                    if (ci.getValidityMode() != null) {
                        caEntry.setValidityMode(ValidityMode.forName(ci.getValidityMode()));
                    }
                    if (ci.getGenSelfIssued() == null) {
                        ConcurrentContentSigner signer;
                        X509Certificate caCert;
                        if (ci.getCert() != null) {
                            byte[] bytes = this.getBinary(ci.getCert(), zipEntries);
                            try {
                                caCert = X509Util.parseCert((byte[])bytes);
                            }
                            catch (CertificateException ex) {
                                throw new InvalidConfException("invalid certificate of CA " + name, (Throwable)ex);
                            }
                        }
                        try {
                            List<String[]> signerConfs = MgmtEntry.Ca.splitCaSignerConfs(this.getValue(ci.getSignerConf(), zipEntries));
                            SignerConf signerConf = new SignerConf(signerConfs.get(0)[1]);
                            signer = securityFactory.createSigner(this.expandConf(ci.getSignerType()), signerConf, (X509Certificate)null);
                        }
                        catch (XiSecurityException | ObjectCreationException ex) {
                            throw new InvalidConfException("could not create CA signer for CA " + name, ex);
                        }
                        caCert = signer.getCertificate();
                        caEntry.setCert(caCert);
                        if (CollectionUtil.isNonEmpty(ci.getCertchain())) {
                            LinkedList<X509Certificate> certchain = new LinkedList<X509Certificate>();
                            for (FileOrBinary cc : ci.getCertchain()) {
                                byte[] bytes = this.getBinary(cc, zipEntries);
                                try {
                                    certchain.add(X509Util.parseCert((byte[])bytes));
                                }
                                catch (CertificateException ex) {
                                    throw new InvalidConfException("invalid certchain for CA " + name, (Throwable)ex);
                                }
                            }
                            caEntry.setCertchain(certchain);
                        }
                    }
                }
                LinkedList<MgmtEntry.CaHasRequestor> caHasRequestors = null;
                if (ca.getRequestors() != null) {
                    caHasRequestors = new LinkedList<MgmtEntry.CaHasRequestor>();
                    for (CaConfType.CaHasRequestor req : ca.getRequestors()) {
                        MgmtEntry.CaHasRequestor en = new MgmtEntry.CaHasRequestor(new NameId(null, req.getRequestorName()));
                        en.setRa(req.isRa());
                        if (req.getProfiles() != null && !req.getProfiles().isEmpty()) {
                            en.setProfiles(new HashSet<String>(req.getProfiles()));
                        }
                        en.setPermission(CaConf.getIntPermission(req.getPermissions()));
                        caHasRequestors.add(en);
                    }
                }
                LinkedList<MgmtEntry.CaHasUser> caHasUsers = null;
                if (ca.getUsers() != null) {
                    caHasUsers = new LinkedList<MgmtEntry.CaHasUser>();
                    for (CaConfType.CaHasUser req : ca.getUsers()) {
                        MgmtEntry.CaHasUser en = new MgmtEntry.CaHasUser(new NameId(null, req.getUserName()));
                        en.setPermission(CaConf.getIntPermission(req.getPermissions()));
                        if (req.getProfiles() != null && !req.getProfiles().isEmpty()) {
                            en.setProfiles(new HashSet<String>(req.getProfiles()));
                        }
                        caHasUsers.add(en);
                    }
                }
                List<String> aliases = null;
                if (ca.getAliases() != null && !ca.getAliases().isEmpty()) {
                    aliases = ca.getAliases();
                }
                List<String> profileNames = null;
                if (ca.getProfiles() != null && !ca.getProfiles().isEmpty()) {
                    profileNames = ca.getProfiles();
                }
                List<String> publisherNames = null;
                if (ca.getPublishers() != null && !ca.getPublishers().isEmpty()) {
                    publisherNames = ca.getPublishers();
                }
                SingleCa singleCa = new SingleCa(name, genSelfIssued, caEntry, aliases, profileNames, caHasRequestors, caHasUsers, publisherNames);
                this.addSingleCa(singleCa);
            }
        }
    }

    public void addSigner(MgmtEntry.Signer signer) {
        Args.notNull((Object)signer, (String)"signer");
        this.signers.put(signer.getName(), signer);
    }

    public Set<String> getSignerNames() {
        return Collections.unmodifiableSet(this.signers.keySet());
    }

    public MgmtEntry.Signer getSigner(String name) {
        return this.signers.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addRequestor(MgmtEntry.Requestor requestor) {
        Args.notNull((Object)requestor, (String)"requestor");
        this.requestors.put(requestor.getIdent().getName(), requestor);
    }

    public void addUser(MgmtEntry.User user) {
        Args.notNull((Object)user, (String)"user");
        this.users.put(user.getIdent().getName(), user);
    }

    public void addUser(MgmtEntry.AddUser user) {
        Args.notNull((Object)user, (String)"user");
        this.users.put(user.getIdent().getName(), user);
    }

    public Set<String> getRequestorNames() {
        return Collections.unmodifiableSet(this.requestors.keySet());
    }

    public MgmtEntry.Requestor getRequestor(String name) {
        return this.requestors.get(Args.notNull((Object)name, (String)"name"));
    }

    public Set<String> getUserNames() {
        return Collections.unmodifiableSet(this.users.keySet());
    }

    public Object getUser(String name) {
        return this.users.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addPublisher(MgmtEntry.Publisher publisher) {
        Args.notNull((Object)publisher, (String)"publisher");
        this.publishers.put(publisher.getIdent().getName(), publisher);
    }

    public Set<String> getPublisherNames() {
        return Collections.unmodifiableSet(this.publishers.keySet());
    }

    public MgmtEntry.Publisher getPublisher(String name) {
        return this.publishers.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addProfile(MgmtEntry.Certprofile profile) {
        Args.notNull((Object)profile, (String)"profile");
        this.certprofiles.put(profile.getIdent().getName(), profile);
    }

    public Set<String> getCertprofileNames() {
        return Collections.unmodifiableSet(this.certprofiles.keySet());
    }

    public MgmtEntry.Certprofile getCertprofile(String name) {
        return this.certprofiles.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addSingleCa(SingleCa singleCa) {
        Args.notNull((Object)singleCa, (String)"singleCa");
        this.cas.put(singleCa.getName(), singleCa);
    }

    public Set<String> getCaNames() {
        return Collections.unmodifiableSet(this.cas.keySet());
    }

    public SingleCa getCa(String name) {
        return this.cas.get(Args.notNull((Object)name, (String)"name"));
    }

    private String getValue(FileOrValue fileOrValue, Map<String, byte[]> zipEntries) throws IOException {
        if (fileOrValue == null) {
            return null;
        }
        if (fileOrValue.getValue() != null) {
            return this.expandConf(fileOrValue.getValue());
        }
        String fileName = fileOrValue.getFile();
        byte[] binary = zipEntries.get(fileName);
        if (binary == null) {
            throw new IOException("could not find ZIP entry " + fileName);
        }
        return this.expandConf(new String(binary, "UTF-8"));
    }

    private String getBase64Binary(FileOrBinary fileOrBinary, Map<String, byte[]> zipEntries) throws IOException {
        byte[] binary = this.getBinary(fileOrBinary, zipEntries);
        return binary == null ? null : Base64.encodeToString((byte[])binary);
    }

    private static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int readed = 0;
        byte[] buffer = new byte[2048];
        while ((readed = in.read(buffer)) != -1) {
            bout.write(buffer, 0, readed);
        }
        return bout.toByteArray();
    }

    private byte[] getBinary(FileOrBinary fileOrBinary, Map<String, byte[]> zipEntries) throws IOException {
        if (fileOrBinary == null) {
            return null;
        }
        if (fileOrBinary.getBinary() != null) {
            return fileOrBinary.getBinary();
        }
        String fileName = fileOrBinary.getFile();
        byte[] binary = zipEntries.get(fileName);
        if (binary == null) {
            throw new IOException("could not find ZIP entry " + fileName);
        }
        return binary;
    }

    private String expandConf(String confStr) {
        if (confStr == null || !confStr.contains("${") || confStr.indexOf(125) == -1) {
            return confStr;
        }
        for (String name : this.properties.keySet()) {
            String placeHolder = "${" + name + "}";
            while (confStr.contains(placeHolder)) {
                confStr = confStr.replace(placeHolder, this.properties.get(name));
            }
        }
        return confStr;
    }

    private static int getIntPermission(List<String> permissions) throws InvalidConfException {
        int ret = 0;
        for (String permission : permissions) {
            Integer ii = PermissionConstants.getPermissionForText(permission);
            if (ii == null) {
                throw new InvalidConfException("invalid permission " + permission);
            }
            ret |= ii.intValue();
        }
        return ret;
    }

    public static class SingleCa {
        private final String name;
        private final GenSelfIssued genSelfIssued;
        private final MgmtEntry.Ca caEntry;
        private final List<String> aliases;
        private final List<String> profileNames;
        private final List<MgmtEntry.CaHasRequestor> requestors;
        private final List<MgmtEntry.CaHasUser> users;
        private final List<String> publisherNames;

        public SingleCa(String name, GenSelfIssued genSelfIssued, MgmtEntry.Ca caEntry, List<String> aliases, List<String> profileNames, List<MgmtEntry.CaHasRequestor> requestors, List<MgmtEntry.CaHasUser> users, List<String> publisherNames) {
            this.name = Args.notBlank((String)name, (String)"name");
            if (genSelfIssued != null) {
                if (caEntry == null) {
                    throw new IllegalArgumentException("caEntry may not be null if genSelfIssued is non-null");
                }
                if (caEntry instanceof MgmtEntry.Ca && caEntry.getCert() != null) {
                    throw new IllegalArgumentException("caEntry.cert may not be null if genSelfIssued is non-null");
                }
            }
            this.genSelfIssued = genSelfIssued;
            this.caEntry = caEntry;
            this.aliases = aliases;
            this.profileNames = profileNames;
            this.requestors = requestors;
            this.users = users;
            this.publisherNames = publisherNames;
        }

        public String getName() {
            return this.name;
        }

        public MgmtEntry.Ca getCaEntry() {
            return this.caEntry;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public GenSelfIssued getGenSelfIssued() {
            return this.genSelfIssued;
        }

        public List<String> getProfileNames() {
            return this.profileNames;
        }

        public List<MgmtEntry.CaHasRequestor> getRequestors() {
            return this.requestors;
        }

        public List<MgmtEntry.CaHasUser> getUsers() {
            return this.users;
        }

        public List<String> getPublisherNames() {
            return this.publisherNames;
        }
    }

    public static class GenSelfIssued {
        private final String profile;
        private final byte[] csr;
        private final BigInteger serialNumber;
        private final String certOutputFormat;

        public GenSelfIssued(String profile, byte[] csr, BigInteger serialNumber, String certOutputFormat) {
            this.profile = Args.notBlank((String)profile, (String)"profile");
            this.csr = (byte[])Args.notNull((Object)csr, (String)"csr");
            this.serialNumber = serialNumber;
            this.certOutputFormat = certOutputFormat;
        }

        public String getProfile() {
            return this.profile;
        }

        public byte[] getCsr() {
            return this.csr;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public String getCertOutputFormat() {
            return this.certOutputFormat;
        }
    }
}

