/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.math.ec.ECCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.api.profile.TextVadidator;
import org.xipki.security.EdECConstants;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;

public abstract class BaseCertprofile
extends Certprofile {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCertprofile.class);
    private static LruCache<ASN1ObjectIdentifier, Integer> ecCurveFieldSizes = new LruCache(100);

    protected BaseCertprofile() {
    }

    @Override
    public abstract Map<ASN1ObjectIdentifier, KeyParametersOption> getKeyAlgorithms();

    @Override
    public Certprofile.CertDomain getCertDomain() {
        return Certprofile.CertDomain.RFC5280;
    }

    @Override
    public Integer getPathLenBasicConstraint() {
        return null;
    }

    @Override
    public Certprofile.AuthorityInfoAccessControl getAiaControl() {
        return null;
    }

    @Override
    public Certprofile.CrlDistributionPointsControl getCrlDpControl() {
        return null;
    }

    @Override
    public Certprofile.CrlDistributionPointsControl getFreshestCrlControl() {
        return null;
    }

    @Override
    public Date getNotBefore(Date requestedNotBefore) {
        Date now = new Date();
        return requestedNotBefore != null && requestedNotBefore.after(now) ? requestedNotBefore : now;
    }

    @Override
    public Certprofile.SubjectInfo getSubject(X500Name requestedSubject) throws CertprofileException, BadCertTemplateException {
        Args.notNull((Object)requestedSubject, (String)"requestedSubject");
        this.verifySubjectDnOccurence(requestedSubject);
        RDN[] requstedRdns = requestedSubject.getRDNs();
        Certprofile.SubjectControl scontrol = this.getSubjectControl();
        AbstractList rdns = new LinkedList();
        for (ASN1ObjectIdentifier type : scontrol.getTypes()) {
            RDN rdn;
            int len;
            Certprofile.RdnControl control = scontrol.getControl(type);
            if (control == null || control.isNotInSubject()) continue;
            String cvalue = control.getValue();
            RDN[] thisRdns = null;
            if (control.isValueOverridable()) {
                thisRdns = BaseCertprofile.getRdns(requstedRdns, type);
            }
            int n = len = thisRdns == null ? 0 : thisRdns.length;
            if (cvalue == null) {
                if (len == 0) {
                    continue;
                }
            } else if (len == 0) {
                len = 1;
            } else if (len == 1) {
                cvalue = null;
            } else {
                throw new BadCertTemplateException(len + " RDNs of type " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)type) + " are requested, but max 1 is allowed.");
            }
            if (len == 1) {
                RDN rdn2;
                if (cvalue != null) {
                    rdn2 = this.createSubjectRdn(cvalue, type, control, 0);
                } else {
                    ASN1Encodable rdnValue = thisRdns[0].getFirst().getValue();
                    if (ObjectIdentifiers.DN.dateOfBirth.equals((Object)type)) {
                        rdn2 = BaseCertprofile.createDateOfBirthRdn(type, rdnValue);
                    } else if (ObjectIdentifiers.DN.postalAddress.equals((Object)type)) {
                        rdn2 = BaseCertprofile.createPostalAddressRdn(type, rdnValue, control, 0);
                    } else {
                        String[] value = X509Util.rdnValueToString((ASN1Encodable)rdnValue);
                        rdn2 = this.createSubjectRdn((String)value, type, control, 0);
                    }
                }
                rdns.add(rdn2);
                continue;
            }
            if (ObjectIdentifiers.DN.dateOfBirth.equals((Object)type)) {
                for (int i = 0; i < len; ++i) {
                    rdn = BaseCertprofile.createDateOfBirthRdn(type, thisRdns[i].getFirst().getValue());
                    rdns.add(rdn);
                }
                continue;
            }
            if (ObjectIdentifiers.DN.postalAddress.equals((Object)type)) {
                for (int i = 0; i < len; ++i) {
                    rdn = BaseCertprofile.createPostalAddressRdn(type, thisRdns[i].getFirst().getValue(), control, i);
                    rdns.add(rdn);
                }
                continue;
            }
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = X509Util.rdnValueToString((ASN1Encodable)thisRdns[i].getFirst().getValue());
            }
            int idx = 0;
            for (String value : values) {
                rdns.add(this.createSubjectRdn(value, type, control, idx++));
            }
        }
        Set<String> subjectDnGroups = scontrol.getGroups();
        if (CollectionUtil.isNonEmpty(subjectDnGroups)) {
            HashSet<String> consideredGroups = new HashSet<String>();
            int n = rdns.size();
            ArrayList<RDN> newRdns = new ArrayList<RDN>(rdns.size());
            for (int i = 0; i < n; ++i) {
                RDN rdn = (RDN)rdns.get(i);
                ASN1ObjectIdentifier type = rdn.getFirst().getType();
                String group = scontrol.getGroup(type);
                if (group == null) {
                    newRdns.add(rdn);
                    continue;
                }
                if (consideredGroups.contains(group)) continue;
                LinkedList<AttributeTypeAndValue> atvs = new LinkedList<AttributeTypeAndValue>();
                atvs.add(rdn.getFirst());
                for (int j = i + 1; j < n; ++j) {
                    RDN rdn2 = (RDN)rdns.get(j);
                    ASN1ObjectIdentifier type2 = rdn2.getFirst().getType();
                    String group2 = scontrol.getGroup(type2);
                    if (!group.equals(group2)) continue;
                    atvs.add(rdn2.getFirst());
                }
                newRdns.add(new RDN(atvs.toArray(new AttributeTypeAndValue[0])));
                consideredGroups.add(group);
            }
            rdns = newRdns;
        }
        X500Name grantedSubject = new X500Name(rdns.toArray(new RDN[0]));
        return new Certprofile.SubjectInfo(grantedSubject, null);
    }

    @Override
    public boolean incSerialNumberIfSubjectExists() {
        return false;
    }

    @Override
    public SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo publicKey) throws CertprofileException, BadCertTemplateException {
        Args.notNull((Object)publicKey, (String)"publicKey");
        Map<ASN1ObjectIdentifier, KeyParametersOption> keyAlgorithms = this.getKeyAlgorithms();
        if (CollectionUtil.isEmpty(keyAlgorithms)) {
            return publicKey;
        }
        ASN1ObjectIdentifier keyType = publicKey.getAlgorithm().getAlgorithm();
        if (!keyAlgorithms.containsKey(keyType)) {
            throw new BadCertTemplateException("key type " + keyType.getId() + " is not permitted");
        }
        String curveName = EdECConstants.getCurveForKeyAlgId((ASN1ObjectIdentifier)keyType);
        if (curveName != null) {
            int keyBitSize;
            int expectedKeyBitSize = EdECConstants.getPublicKeyByteSizeForCurve((String)curveName);
            if (expectedKeyBitSize > 0 && (keyBitSize = publicKey.getPublicKeyData().getOctets().length) != expectedKeyBitSize) {
                throw new BadCertTemplateException("invalid length of key.");
            }
            return publicKey;
        }
        KeyParametersOption keyParamsOption = keyAlgorithms.get(keyType);
        if (keyParamsOption instanceof KeyParametersOption.AllowAllParametersOption) {
            return publicKey;
        }
        if (keyParamsOption instanceof KeyParametersOption.ECParamatersOption) {
            byte[] keyData;
            ASN1ObjectIdentifier curveOid;
            KeyParametersOption.ECParamatersOption ecOption = (KeyParametersOption.ECParamatersOption)keyParamsOption;
            ASN1Encodable algParam = publicKey.getAlgorithm().getParameters();
            if (algParam instanceof ASN1ObjectIdentifier) {
                curveOid = (ASN1ObjectIdentifier)algParam;
                if (!ecOption.allowsCurve(curveOid)) {
                    throw new BadCertTemplateException(String.format("EC curve %s (OID: %s) is not allowed", AlgorithmUtil.getCurveName((ASN1ObjectIdentifier)curveOid), curveOid.getId()));
                }
            } else {
                throw new BadCertTemplateException("only namedCurve EC public key is supported");
            }
            if (ecOption.getPointEncodings() != null) {
                keyData = publicKey.getPublicKeyData().getBytes();
                if (keyData.length < 1) {
                    throw new BadCertTemplateException("invalid publicKeyData");
                }
                byte pointEncoding = keyData[0];
                if (!ecOption.getPointEncodings().contains(pointEncoding)) {
                    throw new BadCertTemplateException(String.format("not accepted EC point encoding '%s'", pointEncoding));
                }
            }
            keyData = publicKey.getPublicKeyData().getBytes();
            try {
                BaseCertprofile.checkEcSubjectPublicKeyInfo(curveOid, keyData);
            }
            catch (BadCertTemplateException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"checkEcSubjectPublicKeyInfo");
                throw new BadCertTemplateException(String.format("invalid public key: %s", ex.getMessage()));
            }
            return publicKey;
        }
        if (keyParamsOption instanceof KeyParametersOption.RSAParametersOption) {
            ASN1Integer modulus;
            KeyParametersOption.RSAParametersOption rsaOption = (KeyParametersOption.RSAParametersOption)keyParamsOption;
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)publicKey.getPublicKeyData().getBytes());
                modulus = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
            }
            catch (IllegalArgumentException ex) {
                throw new BadCertTemplateException("invalid publicKeyData");
            }
            int modulusLength = modulus.getPositiveValue().bitLength();
            if (rsaOption.allowsModulusLength(modulusLength)) {
                return publicKey;
            }
        } else if (keyParamsOption instanceof KeyParametersOption.DSAParametersOption) {
            int qlength;
            int plength;
            KeyParametersOption.DSAParametersOption dsaOption = (KeyParametersOption.DSAParametersOption)keyParamsOption;
            ASN1Encodable params = publicKey.getAlgorithm().getParameters();
            if (params == null) {
                throw new BadCertTemplateException("null Dss-Parms is not permitted");
            }
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)params);
                ASN1Integer rsaP = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
                ASN1Integer rsaQ = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
                plength = rsaP.getPositiveValue().bitLength();
                qlength = rsaQ.getPositiveValue().bitLength();
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                throw new BadCertTemplateException("illegal Dss-Parms");
            }
            boolean match = dsaOption.allowsPlength(plength);
            if (match) {
                match = dsaOption.allowsQlength(qlength);
            }
            if (match) {
                return publicKey;
            }
        } else {
            throw new IllegalStateException(String.format("should not reach here, unknown KeyParametersOption %s", keyParamsOption));
        }
        throw new BadCertTemplateException("the given publicKey is not permitted");
    }

    protected abstract void verifySubjectDnOccurence(X500Name var1) throws BadCertTemplateException;

    protected RDN createSubjectRdn(String text, ASN1ObjectIdentifier type, Certprofile.RdnControl option, int index) throws BadCertTemplateException {
        ASN1Encodable rdnValue;
        if (ObjectIdentifiers.DN.emailAddress.equals((Object)type)) {
            text = text.toLowerCase();
        }
        return (rdnValue = BaseCertprofile.createRdnValue(text, type, option, index)) == null ? null : new RDN(type, rdnValue);
    }

    protected void fixRdnControl(Certprofile.RdnControl rdnControl) throws CertprofileException {
        SubjectDnSpec.fixRdnControl(rdnControl);
    }

    public static GeneralName createGeneralName(GeneralName requestedName, Set<Certprofile.GeneralNameMode> modes) throws BadCertTemplateException {
        Args.notNull((Object)requestedName, (String)"requestedName");
        int tag = requestedName.getTagNo();
        Certprofile.GeneralNameMode mode = null;
        if (modes != null) {
            for (Certprofile.GeneralNameMode m : modes) {
                if (m.getTag().getTag() != tag) continue;
                mode = m;
                break;
            }
            if (mode == null) {
                throw new BadCertTemplateException("generalName tag " + tag + " is not allowed");
            }
        }
        switch (tag) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return new GeneralName(tag, requestedName.getName());
            }
            case 0: {
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)requestedName.getName());
                int size = reqSeq.size();
                if (size != 2) {
                    throw new BadCertTemplateException("invalid otherName sequence: size is not 2: " + size);
                }
                ASN1ObjectIdentifier type = ASN1ObjectIdentifier.getInstance((Object)reqSeq.getObjectAt(0));
                if (mode != null && !mode.getAllowedTypes().contains(type)) {
                    throw new BadCertTemplateException("otherName.type " + type.getId() + " is not allowed");
                }
                ASN1Encodable asn1 = reqSeq.getObjectAt(1);
                if (!(asn1 instanceof ASN1TaggedObject)) {
                    throw new BadCertTemplateException("otherName.value is not tagged Object");
                }
                int tagNo = ASN1TaggedObject.getInstance((Object)asn1).getTagNo();
                if (tagNo != 0) {
                    throw new BadCertTemplateException("otherName.value does not have tag 0: " + tagNo);
                }
                ASN1EncodableVector vector = new ASN1EncodableVector();
                vector.add((ASN1Encodable)type);
                vector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)ASN1TaggedObject.getInstance((Object)asn1).getObject()));
                return new GeneralName(0, (ASN1Encodable)new DERSequence(vector));
            }
            case 5: {
                DirectoryString ds;
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)requestedName.getName());
                int size = reqSeq.size();
                String nameAssigner = null;
                int idx = 0;
                if (size > 1) {
                    ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                    nameAssigner = ds.getString();
                }
                ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                String partyName = ds.getString();
                ASN1EncodableVector vector = new ASN1EncodableVector();
                if (nameAssigner != null) {
                    vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DirectoryString(nameAssigner)));
                }
                vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DirectoryString(partyName)));
                return new GeneralName(5, (ASN1Encodable)new DERSequence(vector));
            }
        }
        throw new IllegalStateException("should not reach here, unknown GeneralName tag " + tag);
    }

    private static RDN createDateOfBirthRdn(ASN1ObjectIdentifier type, ASN1Encodable rdnValue) throws BadCertTemplateException {
        String text;
        Args.notNull((Object)type, (String)"type");
        ASN1Encodable newRdnValue = null;
        if (rdnValue instanceof ASN1GeneralizedTime) {
            text = ((ASN1GeneralizedTime)rdnValue).getTimeString();
            newRdnValue = rdnValue;
        } else if (rdnValue instanceof ASN1String && !(rdnValue instanceof DERUniversalString)) {
            text = ((ASN1String)rdnValue).getString();
        } else {
            throw new BadCertTemplateException("Value of RDN dateOfBirth has incorrect syntax");
        }
        if (!TextVadidator.DATE_OF_BIRTH.isValid(text)) {
            throw new BadCertTemplateException("Value of RDN dateOfBirth does not have format YYYMMDD000000Z");
        }
        if (newRdnValue == null) {
            newRdnValue = new DERGeneralizedTime(text);
        }
        return new RDN(type, newRdnValue);
    }

    private static RDN createPostalAddressRdn(ASN1ObjectIdentifier type, ASN1Encodable rdnValue, Certprofile.RdnControl control, int index) throws BadCertTemplateException {
        Args.notNull((Object)type, (String)"type");
        if (!(rdnValue instanceof ASN1Sequence)) {
            throw new BadCertTemplateException("rdnValue of RDN postalAddress has incorrect syntax");
        }
        ASN1Sequence seq = (ASN1Sequence)rdnValue;
        int size = seq.size();
        if (size < 1 || size > 6) {
            throw new BadCertTemplateException("Sequence size of RDN postalAddress is not within [1, 6]: " + size);
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < size; ++i) {
            ASN1Encodable line = seq.getObjectAt(i);
            if (!(line instanceof ASN1String) || line instanceof DERUniversalString) {
                throw new BadCertTemplateException(String.format("postalAddress[%d] has incorrect syntax", i));
            }
            String text = ((ASN1String)line).getString();
            ASN1Encodable asn1Line = BaseCertprofile.createRdnValue(text, type, control, index);
            vec.add(asn1Line);
        }
        return new RDN(type, (ASN1Encodable)new DERSequence(vec));
    }

    private static RDN[] getRdns(RDN[] rdns, ASN1ObjectIdentifier type) {
        Args.notNull((Object)rdns, (String)"rdns");
        Args.notNull((Object)type, (String)"type");
        ArrayList<RDN> ret = new ArrayList<RDN>(1);
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            if (!rdn.getFirst().getType().equals((Object)type)) continue;
            ret.add(rdn);
        }
        return CollectionUtil.isEmpty(ret) ? null : ret.toArray(new RDN[0]);
    }

    private static ASN1Encodable createRdnValue(String text, ASN1ObjectIdentifier type, Certprofile.RdnControl option, int index) throws BadCertTemplateException {
        String tmpText = text.trim();
        Certprofile.StringType stringType = null;
        if (option != null) {
            Integer maxLen;
            Integer minLen;
            TextVadidator pattern;
            stringType = option.getStringType();
            String prefix = option.getPrefix();
            String suffix = option.getSuffix();
            if (prefix != null || suffix != null) {
                String locTmpText = tmpText.toLowerCase();
                if (prefix != null && locTmpText.startsWith(prefix.toLowerCase())) {
                    tmpText = tmpText.substring(prefix.length());
                    locTmpText = tmpText.toLowerCase();
                }
                if (suffix != null && locTmpText.endsWith(suffix.toLowerCase())) {
                    tmpText = tmpText.substring(0, tmpText.length() - suffix.length());
                }
            }
            if ((pattern = option.getPattern()) != null && !pattern.isValid(tmpText)) {
                throw new BadCertTemplateException(String.format("invalid subject %s '%s' against regex '%s'", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type), tmpText, pattern.pattern()));
            }
            tmpText = StringUtil.concat((String)(prefix != null ? prefix : ""), (String[])new String[]{tmpText, suffix != null ? suffix : ""});
            int len = tmpText.length();
            Range range = option.getStringLengthRange();
            Integer n = minLen = range == null ? null : range.getMin();
            if (minLen != null && len < minLen) {
                throw new BadCertTemplateException(String.format("subject %s '%s' is too short (length (%d) < minLen (%d))", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type), tmpText, len, minLen));
            }
            Integer n2 = maxLen = range == null ? null : range.getMax();
            if (maxLen != null && len > maxLen) {
                throw new BadCertTemplateException(String.format("subject %s '%s' is too long (length (%d) > maxLen (%d))", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type), tmpText, len, maxLen));
            }
        }
        if (stringType == null) {
            stringType = Certprofile.StringType.utf8String;
        }
        return stringType.createString(tmpText.trim());
    }

    private static void checkEcSubjectPublicKeyInfo(ASN1ObjectIdentifier curveOid, byte[] encoded) throws BadCertTemplateException {
        Args.notNull((Object)curveOid, (String)"curveOid");
        Args.notNull((Object)encoded, (String)"encoded");
        Args.positive((int)encoded.length, (String)"encoded.length");
        Integer expectedLength = (Integer)ecCurveFieldSizes.get((Object)curveOid);
        if (expectedLength == null) {
            X9ECParameters ecP = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)curveOid);
            ECCurve curve = ecP.getCurve();
            expectedLength = (curve.getFieldSize() + 7) / 8;
            ecCurveFieldSizes.put((Object)curveOid, (Object)expectedLength);
        }
        switch (encoded[0]) {
            case 2: 
            case 3: {
                if (encoded.length == expectedLength + 1) break;
                throw new BadCertTemplateException("incorrect length for compressed encoding");
            }
            case 4: 
            case 6: 
            case 7: {
                if (encoded.length == 2 * expectedLength + 1) break;
                throw new BadCertTemplateException("incorrect length for uncompressed/hybrid encoding");
            }
            default: {
                throw new BadCertTemplateException(String.format("invalid point encoding 0x%02x", encoded[0]));
            }
        }
    }
}

