/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import org.xipki.util.StringUtil;

public class Range {
    private Integer min;
    private Integer max;

    public Range() {
    }

    public Range(Integer min, Integer max) {
        this.setMin(min);
        this.setMax(max);
        this.validate();
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public void setRange(Integer min, Integer max) {
        Range.validate(min, max);
        this.setMin(min);
        this.setMax(max);
    }

    public boolean match(int val) {
        if (this.min != null && val < this.min) {
            return false;
        }
        return this.max == null || val <= this.max;
    }

    public void validate() {
        Range.validate(this.min, this.max);
    }

    private static void validate(Integer min, Integer max) {
        if (min == null && max == null) {
            throw new IllegalArgumentException("min and max may not be both null");
        }
        if (min != null && max != null && min > max) {
            throw new IllegalArgumentException(String.format("min may not be greater than max: %d > %d", min, max));
        }
    }

    public String toString() {
        return StringUtil.concatObjects((Object)"[", (Object[])new Object[]{this.min == null ? "" : this.min, ",", this.max == null ? "" : this.max, "]"});
    }
}

