/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.Set;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.InsuffientPermissionException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public interface RequestorInfo {
    public static final String NAME_BY_USER = "BY-USER";
    public static final String NAME_BY_CA = "BY-CA";

    public NameId getIdent();

    public boolean isRa();

    public boolean isCertprofilePermitted(String var1);

    public boolean isPermitted(int var1);

    public void assertCertprofilePermitted(String var1) throws InsuffientPermissionException;

    public void assertPermitted(int var1) throws InsuffientPermissionException;

    public static class ByUserRequestorInfo
    implements RequestorInfo {
        private final NameId ident;
        private final MgmtEntry.CaHasUser caHasUser;

        public ByUserRequestorInfo(NameId ident, MgmtEntry.CaHasUser caHasUser) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
            this.caHasUser = (MgmtEntry.CaHasUser)Args.notNull((Object)caHasUser, (String)"caHasUser");
        }

        @Override
        public NameId getIdent() {
            return this.ident;
        }

        @Override
        public boolean isRa() {
            return false;
        }

        public int getUserId() {
            return this.caHasUser.getUserIdent().getId();
        }

        public MgmtEntry.CaHasUser getCaHasUser() {
            return this.caHasUser;
        }

        @Override
        public boolean isCertprofilePermitted(String certprofile) {
            Set<String> profiles = this.caHasUser.getProfiles();
            if (CollectionUtil.isEmpty(profiles)) {
                return false;
            }
            return profiles.contains("all") || profiles.contains(certprofile.toLowerCase());
        }

        @Override
        public boolean isPermitted(int permission) {
            return PermissionConstants.contains(this.caHasUser.getPermission(), permission);
        }

        @Override
        public void assertCertprofilePermitted(String certprofile) throws InsuffientPermissionException {
            if (!this.isCertprofilePermitted(certprofile)) {
                throw new InsuffientPermissionException("Certprofile " + certprofile + " is not permitted");
            }
        }

        @Override
        public void assertPermitted(int permission) throws InsuffientPermissionException {
            if (!this.isPermitted(permission)) {
                throw new InsuffientPermissionException("Permission " + PermissionConstants.getTextForCode(permission) + " is not permitted");
            }
        }
    }

    public static class CmpRequestorInfo
    implements RequestorInfo {
        private final MgmtEntry.CaHasRequestor caHasRequestor;
        private final CertWithDbId cert;
        private final char[] password;
        private final byte[] keyId;

        public CmpRequestorInfo(MgmtEntry.CaHasRequestor caHasRequestor, CertWithDbId cert) {
            this.caHasRequestor = (MgmtEntry.CaHasRequestor)Args.notNull((Object)caHasRequestor, (String)"caHasRequestor");
            this.cert = (CertWithDbId)((Object)Args.notNull((Object)((Object)cert), (String)"cert"));
            this.password = null;
            this.keyId = null;
        }

        public CmpRequestorInfo(MgmtEntry.CaHasRequestor caHasRequestor, char[] password, byte[] keyId) {
            this.caHasRequestor = (MgmtEntry.CaHasRequestor)Args.notNull((Object)caHasRequestor, (String)"caHasRequestor");
            this.cert = null;
            this.password = (char[])Args.notNull((Object)password, (String)"password");
            this.keyId = (byte[])Args.notNull((Object)keyId, (String)"keyId");
        }

        public MgmtEntry.CaHasRequestor getCaHasRequestor() {
            return this.caHasRequestor;
        }

        public CertWithDbId getCert() {
            return this.cert;
        }

        public char[] getPassword() {
            return this.password;
        }

        public byte[] getKeyId() {
            return this.keyId;
        }

        @Override
        public NameId getIdent() {
            return this.caHasRequestor.getRequestorIdent();
        }

        @Override
        public boolean isRa() {
            return this.caHasRequestor.isRa();
        }

        @Override
        public boolean isCertprofilePermitted(String certprofile) {
            return this.caHasRequestor.isCertprofilePermitted(certprofile);
        }

        @Override
        public boolean isPermitted(int permission) {
            return this.caHasRequestor.isPermitted(permission);
        }

        @Override
        public void assertCertprofilePermitted(String certprofile) throws InsuffientPermissionException {
            if (!this.isCertprofilePermitted(certprofile)) {
                throw new InsuffientPermissionException("Certprofile " + certprofile + " is not permitted");
            }
        }

        @Override
        public void assertPermitted(int permission) throws InsuffientPermissionException {
            if (!this.isPermitted(permission)) {
                throw new InsuffientPermissionException("Permission " + PermissionConstants.getTextForCode(permission) + " is not permitted");
            }
        }
    }

    public static class ByCaRequestorInfo
    implements RequestorInfo {
        private final NameId ident;

        public ByCaRequestorInfo(NameId ident) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        @Override
        public NameId getIdent() {
            return this.ident;
        }

        @Override
        public boolean isRa() {
            return false;
        }

        @Override
        public boolean isCertprofilePermitted(String certprofile) {
            return true;
        }

        @Override
        public boolean isPermitted(int requiredPermission) {
            return true;
        }

        @Override
        public void assertCertprofilePermitted(String certprofile) throws InsuffientPermissionException {
        }

        @Override
        public void assertPermitted(int requiredPermission) throws InsuffientPermissionException {
        }
    }
}

