/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;

public class CrlControl {
    public static final String KEY_EYTENSIONS = "extensions";
    public static final String KEY_FULLCRL_INTERVALS = "fullcrl.intervals";
    public static final String KEY_DELTACRL_INTERVALS = "deltacrl.intervals";
    public static final String KEY_OVERLAP_MINUTES = "overlap.minutes";
    public static final String KEY_OVERLAP_DAYS = "overlap.days";
    public static final String KEY_INTERVAL_TIME = "interval.time";
    public static final String KEY_FULLCRL_EXTENDED_NEXTUPDATE = "fullcrl.extended.nextupdate";
    public static final String KEY_EXCLUDE_REASON = "exclude.reason";
    public static final String KEY_INCLUDE_EXPIREDCERTS = "include.expiredcerts";
    public static final String KEY_INVALIDITY_DATE = "invalidity.date";
    private int fullCrlIntervals = 1;
    private int deltaCrlIntervals;
    private int overlapDays = 3;
    private boolean extendedNextUpdate;
    private HourMinute intervalDayTime;
    private boolean excludeReason;
    private boolean includeExpiredCerts;
    private TripleState invalidityDateMode = TripleState.optional;
    private final Set<String> extensionOids;

    public CrlControl(String conf) throws InvalidConfException {
        ConfPairs props;
        try {
            props = new ConfPairs(conf);
        }
        catch (RuntimeException ex) {
            throw new InvalidConfException(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
        String str = props.value(KEY_INVALIDITY_DATE);
        if (str != null) {
            this.invalidityDateMode = TripleState.valueOf((String)str);
        }
        if ((str = props.value(KEY_EYTENSIONS)) == null) {
            this.extensionOids = Collections.emptySet();
        } else {
            Set oids = StringUtil.splitAsSet((String)str, (String)", ");
            for (String oid : oids) {
                try {
                    new ASN1ObjectIdentifier(oid);
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidConfException(oid + " is not a valid OID");
                }
            }
            this.extensionOids = oids;
        }
        this.excludeReason = CrlControl.getBoolean(props, KEY_EXCLUDE_REASON, false);
        this.includeExpiredCerts = CrlControl.getBoolean(props, KEY_INCLUDE_EXPIREDCERTS, false);
        this.fullCrlIntervals = CrlControl.getInteger(props, KEY_FULLCRL_INTERVALS, 7);
        this.deltaCrlIntervals = CrlControl.getInteger(props, KEY_DELTACRL_INTERVALS, 0);
        this.extendedNextUpdate = CrlControl.getBoolean(props, KEY_FULLCRL_EXTENDED_NEXTUPDATE, false);
        if (props.value(KEY_OVERLAP_DAYS) != null) {
            this.overlapDays = CrlControl.getInteger(props, KEY_OVERLAP_DAYS, 1);
        } else if (props.value(KEY_OVERLAP_MINUTES) != null) {
            int minutes = CrlControl.getInteger(props, KEY_OVERLAP_MINUTES, 1);
            this.overlapDays = (minutes + 1440 - 1) / 1440;
        }
        if (this.overlapDays < 1) {
            this.overlapDays = 3;
        }
        if ((str = props.value(KEY_INTERVAL_TIME)) == null) {
            this.intervalDayTime = new HourMinute(1, 0);
        } else {
            List tokens = StringUtil.split((String)str.trim(), (String)":");
            if (tokens.size() != 2) {
                throw new InvalidConfException("invalid interval.time: '" + str + "'");
            }
            try {
                int hour = Integer.parseInt((String)tokens.get(0));
                int minute = Integer.parseInt((String)tokens.get(1));
                this.intervalDayTime = new HourMinute(hour, minute);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidConfException("invalid interval.time: '" + str + "'");
            }
        }
        this.validate();
    }

    public String getConf() {
        ConfPairs pairs = new ConfPairs();
        pairs.putPair(KEY_DELTACRL_INTERVALS, Integer.toString(this.deltaCrlIntervals));
        pairs.putPair(KEY_EXCLUDE_REASON, Boolean.toString(this.excludeReason));
        pairs.putPair(KEY_INCLUDE_EXPIREDCERTS, Boolean.toString(this.includeExpiredCerts));
        pairs.putPair(KEY_FULLCRL_EXTENDED_NEXTUPDATE, Boolean.toString(this.extendedNextUpdate));
        pairs.putPair(KEY_FULLCRL_INTERVALS, Integer.toString(this.fullCrlIntervals));
        pairs.putPair(KEY_INTERVAL_TIME, this.intervalDayTime.toString());
        pairs.putPair(KEY_INVALIDITY_DATE, this.invalidityDateMode.name());
        pairs.putPair(KEY_OVERLAP_DAYS, Integer.toString(this.overlapDays));
        if (CollectionUtil.isNotEmpty(this.extensionOids)) {
            StringBuilder extensionsSb = new StringBuilder(200);
            for (String oid : this.extensionOids) {
                extensionsSb.append(oid).append(",");
            }
            extensionsSb.deleteCharAt(extensionsSb.length() - 1);
            pairs.putPair(KEY_EYTENSIONS, extensionsSb.toString());
        }
        return pairs.getEncoded();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder("generate CRL at ").append(this.intervalDayTime);
        String intervalStr = sb.toString();
        return StringUtil.concatObjects((Object)"  full CRL intervals: ", (Object[])new Object[]{this.fullCrlIntervals, "\n  delta CRL intervals: ", this.deltaCrlIntervals, "\n  overlap: ", this.overlapDays, " days", "\n  use extended nextUpdate: ", this.extendedNextUpdate, "\n  exclude reason: ", this.excludeReason, "\n  include expired certs: ", this.includeExpiredCerts, "\n  invalidity date mode: ", this.invalidityDateMode, "\n  interval: ", intervalStr, verbose ? "\n  encoded: " : "", verbose ? this.getConf() : ""});
    }

    public int getFullCrlIntervals() {
        return this.fullCrlIntervals;
    }

    public int getDeltaCrlIntervals() {
        return this.deltaCrlIntervals;
    }

    public int getOverlapDays() {
        return this.overlapDays;
    }

    public HourMinute getIntervalDayTime() {
        return this.intervalDayTime;
    }

    public Set<String> getExtensionOids() {
        return this.extensionOids;
    }

    public boolean isExtendedNextUpdate() {
        return this.extendedNextUpdate;
    }

    public boolean isExcludeReason() {
        return this.excludeReason;
    }

    public boolean isIncludeExpiredcerts() {
        return this.includeExpiredCerts;
    }

    public TripleState getInvalidityDateMode() {
        return this.invalidityDateMode;
    }

    public final void validate() throws InvalidConfException {
        if (this.fullCrlIntervals < this.deltaCrlIntervals) {
            throw new InvalidConfException("fullCRLIntervals may not be less than deltaCRLIntervals " + this.fullCrlIntervals + " < " + this.deltaCrlIntervals);
        }
        if (this.fullCrlIntervals < 1) {
            throw new InvalidConfException("fullCRLIntervals may not be less than 1: " + this.fullCrlIntervals);
        }
        if (this.deltaCrlIntervals < 0) {
            throw new InvalidConfException("deltaCRLIntervals may not be less than 0: " + this.deltaCrlIntervals);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrlControl)) {
            return false;
        }
        CrlControl obj2 = (CrlControl)obj;
        if (this.deltaCrlIntervals != obj2.deltaCrlIntervals || this.extendedNextUpdate != obj2.extendedNextUpdate || this.fullCrlIntervals != obj2.fullCrlIntervals || this.includeExpiredCerts != obj2.includeExpiredCerts) {
            return false;
        }
        if (this.extensionOids == null ? obj2.extensionOids != null : !this.extensionOids.equals(obj2.extensionOids)) {
            return false;
        }
        return this.intervalDayTime.equals(obj2.intervalDayTime);
    }

    private static int getInteger(ConfPairs props, String propKey, int dfltValue) throws InvalidConfException {
        String str = props.value(propKey);
        if (str != null) {
            try {
                return Integer.parseInt(str.trim());
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfException(propKey + " does not have numeric value: " + str);
            }
        }
        return dfltValue;
    }

    private static boolean getBoolean(ConfPairs props, String propKey, boolean dfltValue) throws InvalidConfException {
        String str = props.value(propKey);
        if (str != null) {
            if ("true".equalsIgnoreCase(str = str.trim())) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            throw new InvalidConfException(propKey + " does not have boolean value: " + str);
        }
        return dfltValue;
    }

    public static class HourMinute {
        private final int hour;
        private final int minute;

        public HourMinute(int hour, int minute) {
            this.hour = Args.range((int)hour, (String)"hour", (int)0, (int)23);
            this.minute = Args.range((int)minute, (String)"minute", (int)0, (int)59);
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public String toString() {
            return StringUtil.concatObjectsCap((int)100, (Object)(this.hour < 10 ? "0" : ""), (Object[])new Object[]{this.hour, ":", this.minute < 10 ? "0" : "", this.minute});
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HourMinute)) {
                return false;
            }
            HourMinute hm = (HourMinute)obj;
            return this.hour == hm.hour && this.minute == hm.minute;
        }
    }
}

