/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api;

import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.OperationException;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;

public class PublicCaInfo {
    private final X500Name subject;
    private final String c14nSubject;
    private final byte[] subjectKeyIdentifier;
    private final GeneralNames subjectAltName;
    private final X500Name issuer;
    private final BigInteger serialNumber;
    private final X509Cert caCert;
    private X509Cert crlSignerCert;
    private final CaUris caUris;
    private final ConfPairs extraControl;

    public PublicCaInfo(X509Cert caCert, CaUris caUris, ConfPairs extraControl) throws OperationException {
        this.caCert = (X509Cert)Args.notNull((Object)caCert, (String)"caCert");
        this.caUris = caUris == null ? CaUris.EMPTY_INSTANCE : caUris;
        this.issuer = caCert.getIssuer();
        this.serialNumber = caCert.getSerialNumber();
        this.subject = caCert.getSubject();
        this.c14nSubject = X509Util.canonicalizName((X500Name)this.subject);
        this.subjectKeyIdentifier = caCert.getSubjectKeyId();
        this.extraControl = extraControl;
        byte[] encodedSubjectAltName = caCert.getExtensionCoreValue(Extension.subjectAlternativeName);
        if (encodedSubjectAltName == null) {
            this.subjectAltName = null;
        } else {
            try {
                this.subjectAltName = GeneralNames.getInstance((Object)encodedSubjectAltName);
            }
            catch (RuntimeException ex) {
                throw new OperationException(OperationException.ErrorCode.INVALID_EXTENSION, "invalid SubjectAltName extension in CA certificate");
            }
        }
    }

    public PublicCaInfo(X500Name subject, X500Name issuer, BigInteger serialNumber, GeneralNames subjectAltName, byte[] subjectKeyIdentifier, CaUris caUris, ConfPairs extraControl) throws OperationException {
        this.subject = (X500Name)Args.notNull((Object)subject, (String)"subject");
        this.issuer = (X500Name)Args.notNull((Object)subject, (String)"issuer");
        this.serialNumber = (BigInteger)Args.notNull((Object)serialNumber, (String)"serialNumber");
        this.caUris = caUris == null ? CaUris.EMPTY_INSTANCE : caUris;
        this.caCert = null;
        this.c14nSubject = X509Util.canonicalizName((X500Name)subject);
        this.subjectKeyIdentifier = subjectKeyIdentifier == null ? null : Arrays.copyOf(subjectKeyIdentifier, subjectKeyIdentifier.length);
        this.subjectAltName = subjectAltName;
        this.extraControl = extraControl;
    }

    public CaUris getCaUris() {
        return this.caUris;
    }

    public X509Cert getCrlSignerCert() {
        return this.crlSignerCert;
    }

    public void setCrlSignerCert(X509Cert crlSignerCert) {
        this.crlSignerCert = this.caCert.equals((Object)crlSignerCert) ? null : crlSignerCert;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public String getC14nSubject() {
        return this.c14nSubject;
    }

    public GeneralNames getSubjectAltName() {
        return this.subjectAltName;
    }

    public byte[] getSubjectKeyIdentifer() {
        return this.subjectKeyIdentifier == null ? null : Arrays.copyOf(this.subjectKeyIdentifier, this.subjectKeyIdentifier.length);
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X509Cert getCaCert() {
        return this.caCert;
    }

    public ConfPairs getExtraControl() {
        return this.extraControl;
    }
}

