/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class CaConfs {
    private static final Logger LOG = LoggerFactory.getLogger(CaConfs.class);
    private static final String APP_DIR = "APP_DIR";

    private CaConfs() {
    }

    public static void marshal(CaConfType.CaSystem root, OutputStream out) throws InvalidConfException, IOException {
        Args.notNull((Object)((Object)root), (String)"root");
        Args.notNull((Object)out, (String)"out");
        root.validate();
        JSON.writeJSONString((OutputStream)out, (Charset)Charset.forName("UTF8"), (Object)((Object)root), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream convertFileConfToZip(String confFilename) throws IOException, InvalidConfException {
        Args.notNull((Object)confFilename, (String)"confFilename");
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream(0x100000);
        ZipOutputStream zipStream = new ZipOutputStream(bytesStream);
        zipStream.setLevel(1);
        File confFile = new File(confFilename);
        confFile = IoUtil.expandFilepath((File)confFile);
        InputStream caConfStream = null;
        String baseDir = null;
        try {
            Object value;
            String zipEntryName;
            String name;
            caConfStream = Files.newInputStream(confFile.toPath(), new OpenOption[0]);
            CaConfType.CaSystem root = (CaConfType.CaSystem)((Object)JSON.parseObject((InputStream)caConfStream, CaConfType.CaSystem.class, (Feature[])new Feature[0]));
            baseDir = root.getBasedir();
            if (StringUtil.isBlank((String)baseDir)) {
                File confFileParent = confFile.getParentFile();
                baseDir = confFileParent == null ? "." : confFileParent.getPath();
            } else if (APP_DIR.equalsIgnoreCase(baseDir)) {
                baseDir = ".";
            }
            root.setBasedir(null);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (root.getProperties() != null) {
                properties.putAll(root.getProperties());
            }
            if (root.getSigners() != null) {
                for (CaConfType.Signer signer : root.getSigners()) {
                    name = signer.getName();
                    if (signer.getConf() != null) {
                        String conf = CaConfs.convertSignerConf(signer.getConf(), properties, baseDir);
                        if (conf.length() > 200) {
                            String zipEntryName2 = "files/signer-" + name + ".conf";
                            CaConfs.createFileOrValue(zipStream, conf, zipEntryName2);
                            signer.getConf().setFile(zipEntryName2);
                            signer.getConf().setValue(null);
                        } else {
                            signer.getConf().setFile(null);
                            signer.getConf().setValue(conf);
                        }
                    }
                    if (signer.getCert() == null || signer.getCert().getFile() == null) continue;
                    zipEntryName = "files/signer-" + name + ".crt";
                    value = CaConfs.getBinary(signer.getConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrBinary(zipStream, value, zipEntryName);
                    signer.getCert().setFile(zipEntryName);
                }
            }
            if (root.getRequestors() != null) {
                for (CaConfType.Requestor requestor : root.getRequestors()) {
                    name = requestor.getName();
                    if (requestor.getConf() != null && requestor.getConf().getFile() != null) {
                        zipEntryName = "files/requestor-" + name + ".conf";
                        value = CaConfs.getValue(requestor.getConf().getFile(), properties, baseDir);
                        CaConfs.createFileOrValue(zipStream, (String)value, zipEntryName);
                        requestor.getConf().setFile(zipEntryName);
                    }
                    if (requestor.getBinaryConf() == null || requestor.getBinaryConf().getFile() == null) continue;
                    zipEntryName = "files/requestor-" + name + ".bin";
                    value = CaConfs.getBinary(requestor.getBinaryConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrBinary(zipStream, value, zipEntryName);
                    requestor.getBinaryConf().setFile(zipEntryName);
                }
            }
            if (root.getPublishers() != null) {
                for (CaConfType.NameTypeConf nameTypeConf : root.getPublishers()) {
                    if (nameTypeConf.getConf() == null || nameTypeConf.getConf().getFile() == null) continue;
                    name = nameTypeConf.getName();
                    zipEntryName = "files/publisher-" + name + ".conf";
                    value = CaConfs.getValue(nameTypeConf.getConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrValue(zipStream, (String)value, zipEntryName);
                    nameTypeConf.getConf().setFile(zipEntryName);
                }
            }
            if (root.getProfiles() != null) {
                for (CaConfType.NameTypeConf nameTypeConf : root.getProfiles()) {
                    if (nameTypeConf.getConf() == null || nameTypeConf.getConf().getFile() == null) continue;
                    name = nameTypeConf.getName();
                    zipEntryName = "files/certprofile-" + name + ".conf";
                    value = CaConfs.getValue(nameTypeConf.getConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrValue(zipStream, (String)value, zipEntryName);
                    nameTypeConf.getConf().setFile(zipEntryName);
                }
            }
            if (root.getCas() != null) {
                for (CaConfType.Ca ca : root.getCas()) {
                    String zipEntryName2;
                    String conf;
                    if (ca.getCaInfo() == null) continue;
                    name = ca.getName();
                    CaConfType.CaInfo ci = ca.getCaInfo();
                    if (ci.getSignerConf() != null) {
                        FileOrValue fv = ci.getSignerConf();
                        conf = CaConfs.convertSignerConf(fv, properties, baseDir);
                        if (conf.length() > 200) {
                            String zipEntryName3 = "files/ca-" + name + "-signer.conf";
                            CaConfs.createFileOrValue(zipStream, conf, zipEntryName3);
                            fv.setFile(zipEntryName3);
                            fv.setValue(null);
                        } else {
                            fv.setFile(null);
                            fv.setValue(conf);
                        }
                    }
                    if (ci.getDhpocControl() != null) {
                        FileOrValue fv = ci.getDhpocControl();
                        conf = CaConfs.convertSignerConf(fv, properties, baseDir);
                        if (conf.length() > 200) {
                            zipEntryName2 = "files/ca-" + name + "-dhpoc.conf";
                            CaConfs.createFileOrValue(zipStream, conf, zipEntryName2);
                            fv.setFile(zipEntryName2);
                            fv.setValue(null);
                        } else {
                            fv.setFile(null);
                            fv.setValue(conf);
                        }
                    }
                    if (ci.getGenSelfIssued() == null) {
                        if (ci.getCert() != null && ci.getCert().getFile() != null) {
                            String zipEntryName4 = "files/ca-" + name + ".crt";
                            byte[] value2 = CaConfs.getBinary(ci.getCert().getFile(), properties, baseDir);
                            CaConfs.createFileOrBinary(zipStream, value2, zipEntryName4);
                            ci.getCert().setFile(zipEntryName4);
                        }
                        if (!CollectionUtil.isNotEmpty(ci.getCertchain())) continue;
                        for (int i = 0; i < ci.getCertchain().size(); ++i) {
                            FileOrBinary fi = ci.getCertchain().get(i);
                            if (fi.getFile() == null) continue;
                            zipEntryName2 = "files/cacertchain-" + name + "-" + i + ".crt";
                            byte[] value3 = CaConfs.getBinary(fi.getFile(), properties, baseDir);
                            CaConfs.createFileOrBinary(zipStream, value3, zipEntryName2);
                            fi.setFile(zipEntryName2);
                        }
                        continue;
                    }
                    if (ci.getCert() != null) {
                        throw new InvalidConfException("cert of CA " + name + " may not be set");
                    }
                    FileOrBinary csrFb = ci.getGenSelfIssued().getCsr();
                    if (csrFb == null || csrFb.getFile() == null) continue;
                    String zipEntryName5 = "files/ca-" + name + "-csr.p10";
                    byte[] value4 = CaConfs.getBinary(csrFb.getFile(), properties, baseDir);
                    CaConfs.createFileOrBinary(zipStream, value4, zipEntryName5);
                    csrFb.setFile(zipEntryName5);
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                CaConfs.marshal(root, bout);
            }
            finally {
                bout.flush();
            }
            zipStream.putNextEntry(new ZipEntry("caconf.json"));
            try {
                zipStream.write(bout.toByteArray());
            }
            finally {
                zipStream.closeEntry();
            }
        }
        finally {
            if (caConfStream != null) {
                try {
                    caConfStream.close();
                }
                catch (IOException ex) {
                    LOG.info("could not clonse caConfStream", (Object)ex.getMessage());
                }
            }
            zipStream.close();
            bytesStream.flush();
        }
        return new ByteArrayInputStream(bytesStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileOrValue(ZipOutputStream zipStream, String content, String fileName) throws IOException {
        ZipEntry certZipEntry = new ZipEntry(fileName);
        zipStream.putNextEntry(certZipEntry);
        try {
            zipStream.write(StringUtil.toUtf8Bytes((String)content));
        }
        finally {
            zipStream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileOrBinary(ZipOutputStream zipStream, byte[] content, String fileName) throws IOException {
        ZipEntry certZipEntry = new ZipEntry(fileName);
        zipStream.putNextEntry(certZipEntry);
        try {
            zipStream.write(content);
        }
        finally {
            zipStream.closeEntry();
        }
    }

    private static String getValue(String fileName, Map<String, String> properties, String baseDir) throws IOException {
        byte[] binary = CaConfs.getBinary(fileName, properties, baseDir);
        return new String(binary, "UTF-8");
    }

    private static byte[] getBinary(String fileName, Map<String, String> properties, String baseDir) throws IOException {
        fileName = CaConfs.expandConf(fileName, properties);
        InputStream is = Files.newInputStream(Paths.get(CaConfs.resolveFilePath(fileName, baseDir), new String[0]), new OpenOption[0]);
        return IoUtil.read((InputStream)is);
    }

    private static String expandConf(String confStr, Map<String, String> properties) {
        if (confStr == null || !confStr.contains("${") || confStr.indexOf(125) == -1) {
            return confStr;
        }
        for (String name : properties.keySet()) {
            String placeHolder = "${" + name + "}";
            while (confStr.contains(placeHolder)) {
                confStr = confStr.replace(placeHolder, properties.get(name));
            }
        }
        return confStr;
    }

    private static String resolveFilePath(String filePath, String baseDir) {
        File file = new File(filePath);
        return file.isAbsolute() ? filePath : new File(baseDir, filePath).getPath();
    }

    private static String convertSignerConf(FileOrValue confFv, Map<String, String> properties, String baseDir) throws IOException {
        String conf = confFv.getValue() != null ? confFv.getValue() : CaConfs.getValue(confFv.getFile(), properties, baseDir);
        if (!(conf = CaConfs.expandConf(conf, properties)).contains("file:")) {
            return conf;
        }
        ConfPairs confPairs = new ConfPairs(conf);
        boolean changed = false;
        for (String name : confPairs.names()) {
            String value = confPairs.value(name);
            if (!value.startsWith("file:")) continue;
            changed = true;
            String fileName = value.substring("file:".length());
            byte[] binValue = CaConfs.getBinary(fileName, properties, baseDir);
            confPairs.putPair(name, "base64:" + Base64.encodeToString((byte[])binValue));
        }
        return changed ? confPairs.getEncoded() : conf;
    }
}

