/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api;

public class OperationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ErrorCode errorCode;
    private final String errorMessage;

    public OperationException(ErrorCode errorCode) {
        super(String.format("error code: %s", new Object[]{errorCode}));
        this.errorCode = errorCode;
        this.errorMessage = null;
    }

    public OperationException(ErrorCode errorCode, String errorMessage) {
        super(String.format("error code: %s, error message: %s", new Object[]{errorCode, errorMessage}));
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public OperationException(ErrorCode errorCode, Throwable throwable) {
        this(errorCode, OperationException.getMessage(throwable));
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private static String getMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(throwable.getClass().getSimpleName());
        String msg = throwable.getMessage();
        if (msg != null) {
            sb.append(": ").append(msg);
        }
        return sb.toString();
    }

    public static enum ErrorCode {
        ALREADY_ISSUED,
        BAD_CERT_TEMPLATE,
        BAD_REQUEST,
        BAD_POP,
        CERT_REVOKED,
        CERT_UNREVOKED,
        CRL_FAILURE,
        DATABASE_FAILURE,
        INVALID_EXTENSION,
        NOT_PERMITTED,
        SYSTEM_FAILURE,
        SYSTEM_UNAVAILABLE,
        UNKNOWN_CERT,
        UNKNOWN_CERT_PROFILE;

    }
}

