/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.CollectionAlgorithmValidator;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.StringUtil;

public class CmpControl {
    public static final String ALGO_DELIMITER = ":";
    public static final String KEY_CONFIRM_CERT = "confirm.cert";
    public static final String KEY_SEND_CA = "send.ca";
    public static final String KEY_SEND_CERTCHAIN = "send.certchain";
    public static final String KEY_SEND_RESPONDER = "send.responder";
    public static final String KEY_MESSAGETIME_REQUIRED = "messagetime.required";
    public static final String KEY_MESSAGETIME_BIAS = "messagetime.bias";
    public static final String KEY_CONFIRM_WAITTIME = "confirm.waittime";
    public static final String KEY_PROTECTION_SIGALGO = "protection.sigalgo";
    public static final String KEY_PROTECTION_PBM_OWF = "protection.pbm.owf";
    public static final String KEY_PROTECTION_PBM_MAC = "protection.pbm.mac";
    public static final String KEY_PROTECTION_PBM_IC = "protection.pbm.ic";
    public static final String KEY_POPO_SIGALGO = "popo.sigalgo";
    public static final String KEY_GROUP_ENROLL = "group.enroll";
    public static final String KEY_RR_AKI_REQUIRED = "rr.aki.required";
    private static final int DFLT_MESSAGE_TIME_BIAS = 300;
    private static final int DFLT_CONFIRM_WAIT_TIME = 300;
    private static final int DFLT_PBM_ITERATIONCOUNT = 10240;
    private static final Logger LOG = LoggerFactory.getLogger(CmpControl.class);
    private final String conf;
    private final boolean confirmCert;
    private final boolean sendCaCert;
    private final boolean sendCertChain;
    private final boolean messageTimeRequired;
    private final boolean sendResponderCert;
    private final int messageTimeBias;
    private final int confirmWaitTime;
    private final long confirmWaitTimeMs;
    private final boolean groupEnroll;
    private final boolean rrAkiRequired;
    private HashAlgo responsePbmOwf;
    private List<HashAlgo> requestPbmOwfs;
    private SignAlgo responsePbmMac;
    private List<SignAlgo> requestPbmMacs;
    private int responsePbmIterationCount = 10240;
    private final CollectionAlgorithmValidator sigAlgoValidator;
    private final CollectionAlgorithmValidator popoAlgoValidator;

    public CmpControl(String conf) throws InvalidConfException {
        ConfPairs pairs = new ConfPairs(conf);
        this.confirmCert = CmpControl.getBoolean(pairs, KEY_CONFIRM_CERT, false);
        this.sendCaCert = CmpControl.getBoolean(pairs, KEY_SEND_CA, false);
        this.sendCertChain = CmpControl.getBoolean(pairs, KEY_SEND_CERTCHAIN, false);
        this.sendResponderCert = CmpControl.getBoolean(pairs, KEY_SEND_RESPONDER, true);
        this.groupEnroll = CmpControl.getBoolean(pairs, KEY_GROUP_ENROLL, false);
        this.messageTimeRequired = CmpControl.getBoolean(pairs, KEY_MESSAGETIME_REQUIRED, true);
        this.messageTimeBias = CmpControl.getInt(pairs, KEY_MESSAGETIME_BIAS, 300);
        this.rrAkiRequired = CmpControl.getBoolean(pairs, KEY_RR_AKI_REQUIRED, false);
        this.confirmWaitTime = CmpControl.getInt(pairs, KEY_CONFIRM_WAITTIME, 300);
        if (this.confirmWaitTime < 0) {
            throw new InvalidConfException("invalid confirm.waittime");
        }
        this.confirmWaitTimeMs = (long)this.confirmWaitTime * 1000L;
        String key = KEY_PROTECTION_SIGALGO;
        String str = pairs.value(key);
        if (str == null) {
            throw new InvalidConfException(key + " is not set");
        }
        Set algos = CmpControl.splitAlgos(str);
        try {
            this.sigAlgoValidator = this.buildAlgorithmValidator(algos);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException("invalid " + key + ": " + str, (Throwable)ex);
        }
        algos = this.sigAlgoValidator.getAlgoNames();
        pairs.putPair(key, CmpControl.algosAsString(algos));
        key = KEY_POPO_SIGALGO;
        str = pairs.value(key);
        if (str == null) {
            throw new InvalidConfException(key + " is not set");
        }
        algos = CmpControl.splitAlgos(str);
        try {
            this.popoAlgoValidator = this.buildAlgorithmValidator(algos);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException("invalid " + key + ": " + str, (Throwable)ex);
        }
        algos = this.popoAlgoValidator.getAlgoNames();
        pairs.putPair(key, CmpControl.algosAsString(algos));
        str = pairs.value(KEY_PROTECTION_PBM_OWF);
        List listOwfAlgos = StringUtil.isBlank((String)str) ? null : StringUtil.split((String)str, (String)ALGO_DELIMITER);
        str = pairs.value(KEY_PROTECTION_PBM_MAC);
        List listMacAlgos = StringUtil.isBlank((String)str) ? null : StringUtil.split((String)str, (String)ALGO_DELIMITER);
        str = pairs.value(KEY_PROTECTION_PBM_IC);
        Integer pbmIterationCount = str == null ? null : Integer.valueOf(Integer.parseInt(str));
        this.initPbm(pairs, listOwfAlgos, listMacAlgos, pbmIterationCount);
        this.conf = pairs.getEncoded();
    }

    public CmpControl(Boolean confirmCert, Boolean sendCaCert, Boolean sendCertChain, Boolean messageTimeRequired, Boolean sendResponderCert, Boolean rrAkiRequired, Integer messageTimeBias, Integer confirmWaitTime, Boolean groupEnroll, List<String> sigAlgos, List<String> popoAlgos, List<String> pbmOwfs, List<String> pbmMacs, Integer pbmIterationCount) throws InvalidConfException {
        if (confirmWaitTime != null) {
            Args.notNegative((int)confirmWaitTime, (String)"confirmWaitTime");
        }
        ConfPairs pairs = new ConfPairs();
        this.confirmCert = confirmCert != null && confirmCert != false;
        pairs.putPair(KEY_CONFIRM_CERT, Boolean.toString(this.confirmCert));
        this.sendCaCert = sendCaCert != null && sendCaCert != false;
        pairs.putPair(KEY_SEND_CA, Boolean.toString(this.sendCaCert));
        this.sendCertChain = sendCertChain != null && sendCertChain != false;
        pairs.putPair(KEY_SEND_CERTCHAIN, Boolean.toString(this.sendCertChain));
        this.messageTimeRequired = messageTimeRequired == null || messageTimeRequired != false;
        pairs.putPair(KEY_MESSAGETIME_REQUIRED, Boolean.toString(this.messageTimeRequired));
        this.sendResponderCert = sendResponderCert == null || sendResponderCert != false;
        pairs.putPair(KEY_SEND_RESPONDER, Boolean.toString(this.sendResponderCert));
        this.rrAkiRequired = rrAkiRequired == null || rrAkiRequired != false;
        pairs.putPair(KEY_RR_AKI_REQUIRED, Boolean.toString(this.rrAkiRequired));
        this.messageTimeBias = messageTimeBias == null ? 300 : messageTimeBias;
        pairs.putPair(KEY_MESSAGETIME_BIAS, Integer.toString(this.messageTimeBias));
        this.confirmWaitTime = confirmWaitTime == null ? 300 : confirmWaitTime;
        pairs.putPair(KEY_CONFIRM_WAITTIME, Integer.toString(this.confirmWaitTime));
        this.confirmWaitTimeMs = (long)this.confirmWaitTime * 1000L;
        this.groupEnroll = groupEnroll != null && groupEnroll != false;
        try {
            this.sigAlgoValidator = this.buildAlgorithmValidator(sigAlgos);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException("invalid sigAlgos", (Throwable)ex);
        }
        if (CollectionUtil.isNotEmpty(sigAlgos)) {
            pairs.putPair(KEY_PROTECTION_SIGALGO, CmpControl.algosAsString(this.sigAlgoValidator.getAlgoNames()));
        }
        try {
            this.popoAlgoValidator = this.buildAlgorithmValidator(popoAlgos);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException("invalid popoAlgos", (Throwable)ex);
        }
        if (CollectionUtil.isNotEmpty(popoAlgos)) {
            pairs.putPair(KEY_POPO_SIGALGO, CmpControl.algosAsString(this.popoAlgoValidator.getAlgoNames()));
        }
        this.initPbm(pairs, pbmOwfs, pbmMacs, pbmIterationCount);
        if (CollectionUtil.isNotEmpty(pbmOwfs)) {
            pairs.putPair(KEY_PROTECTION_PBM_OWF, CmpControl.algosAsString(pbmOwfs));
        }
        if (CollectionUtil.isNotEmpty(pbmMacs)) {
            pairs.putPair(KEY_PROTECTION_PBM_MAC, CmpControl.algosAsString(pbmMacs));
        }
        pairs.putPair(KEY_PROTECTION_PBM_IC, Integer.toString(this.responsePbmIterationCount));
        this.conf = pairs.getEncoded();
    }

    private void initPbm(ConfPairs pairs, List<String> pbmOwfs, List<String> pbmMacs, Integer pbmIterationCount) throws InvalidConfException {
        String algo;
        int i;
        if (pbmIterationCount == null) {
            pbmIterationCount = 10240;
        }
        if (CollectionUtil.isEmpty(pbmOwfs)) {
            pbmOwfs = Collections.singletonList("SHA256");
        }
        if (CollectionUtil.isEmpty(pbmMacs)) {
            pbmMacs = Collections.singletonList("HMACSHA256");
        }
        if (pbmIterationCount <= 0) {
            throw new InvalidConfException("invalid pbmIterationCount " + pbmIterationCount);
        }
        this.responsePbmIterationCount = pbmIterationCount;
        pairs.putPair(KEY_PROTECTION_PBM_IC, Integer.toString(pbmIterationCount));
        this.requestPbmOwfs = new ArrayList<HashAlgo>(pbmOwfs.size());
        ArrayList<String> canonicalizedAlgos = new ArrayList<String>(pbmOwfs.size());
        for (i = 0; i < pbmOwfs.size(); ++i) {
            HashAlgo ha;
            algo = pbmOwfs.get(i);
            try {
                ha = HashAlgo.getInstance((String)algo);
            }
            catch (Exception ex) {
                throw new InvalidConfException("invalid pbmPwf " + algo, (Throwable)ex);
            }
            canonicalizedAlgos.add(ha.getJceName());
            this.requestPbmOwfs.add(ha);
            if (i != 0) continue;
            this.responsePbmOwf = ha;
        }
        pairs.putPair(KEY_PROTECTION_PBM_OWF, CmpControl.algosAsString(canonicalizedAlgos));
        canonicalizedAlgos.clear();
        this.requestPbmMacs = new ArrayList<SignAlgo>(pbmMacs.size());
        for (i = 0; i < pbmMacs.size(); ++i) {
            SignAlgo signAlgo;
            algo = pbmMacs.get(i);
            try {
                signAlgo = SignAlgo.getInstance((String)algo);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidConfException("invalid pbmMac " + algo, (Throwable)ex);
            }
            canonicalizedAlgos.add(signAlgo.getJceName());
            this.requestPbmMacs.add(signAlgo);
            if (i != 0) continue;
            this.responsePbmMac = signAlgo;
        }
        pairs.putPair(KEY_PROTECTION_PBM_MAC, CmpControl.algosAsString(canonicalizedAlgos));
    }

    public boolean isMessageTimeRequired() {
        return this.messageTimeRequired;
    }

    public boolean isConfirmCert() {
        return this.confirmCert;
    }

    public int getMessageTimeBias() {
        return this.messageTimeBias;
    }

    public int getConfirmWaitTime() {
        return this.confirmWaitTime;
    }

    public long getConfirmWaitTimeMs() {
        return this.confirmWaitTimeMs;
    }

    public boolean isSendCaCert() {
        return this.sendCaCert;
    }

    public boolean isSendCertChain() {
        return this.sendCertChain;
    }

    public boolean isRrAkiRequired() {
        return this.rrAkiRequired;
    }

    public boolean isSendResponderCert() {
        return this.sendResponderCert;
    }

    public boolean isGroupEnroll() {
        return this.groupEnroll;
    }

    public AlgorithmValidator getSigAlgoValidator() {
        return this.sigAlgoValidator;
    }

    public AlgorithmValidator getPopoAlgoValidator() {
        return this.popoAlgoValidator;
    }

    public HashAlgo getResponsePbmOwf() {
        return this.responsePbmOwf;
    }

    public SignAlgo getResponsePbmMac() {
        return this.responsePbmMac;
    }

    public int getResponsePbmIterationCount() {
        return this.responsePbmIterationCount;
    }

    public boolean isRequestPbmOwfPermitted(HashAlgo pbmOwf) {
        return this.requestPbmOwfs.contains(pbmOwf);
    }

    public boolean isRequestPbmMacPermitted(SignAlgo pbmMac) {
        return this.requestPbmMacs.contains(pbmMac);
    }

    public String getConf() {
        return this.conf;
    }

    public int hashCode() {
        return this.conf.hashCode();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        return StringUtil.concatObjects((Object)"  confirm cert: ", (Object[])new Object[]{this.confirmCert, "\n  send CA cert: ", this.sendCaCert, "\n  send CA cert chain: ", this.sendCertChain, "\n  message time required: ", this.messageTimeRequired, "\n  send responder cert: ", this.sendResponderCert, "\n  message time bias: ", this.messageTimeBias, "s", "\n  confirm waiting time: ", this.confirmWaitTime, "s", "\n  group enroll: ", this.groupEnroll, "\n  AKI in revocation request required: ", this.rrAkiRequired, "\n  signature algorithms: ", CollectionUtil.sort((Collection)this.sigAlgoValidator.getAlgoNames()), "\n  POPO algorithms: ", CollectionUtil.sort((Collection)this.popoAlgoValidator.getAlgoNames()), verbose ? "\n  encoded: " : "", verbose ? this.conf : ""});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmpControl)) {
            return false;
        }
        return this.conf.equals(((CmpControl)obj).conf);
    }

    private static boolean getBoolean(ConfPairs pairs, String key, boolean defaultValue) {
        String str = pairs.value(key);
        boolean ret = StringUtil.isBlank((String)str) ? defaultValue : Boolean.parseBoolean(str);
        pairs.putPair(key, Boolean.toString(ret));
        return ret;
    }

    private static int getInt(ConfPairs pairs, String key, int defaultValue) {
        String str = pairs.value(key);
        int ret = StringUtil.isBlank((String)str) ? defaultValue : Integer.parseInt(str);
        pairs.putPair(key, Integer.toString(ret));
        return ret;
    }

    private static String algosAsString(Collection<String> algos) {
        return StringUtil.collectionAsString(algos, (String)ALGO_DELIMITER);
    }

    private static Set<String> splitAlgos(String encoded) {
        return StringUtil.splitAsSet((String)encoded, (String)ALGO_DELIMITER);
    }

    private CollectionAlgorithmValidator buildAlgorithmValidator(Collection<String> algoNames) throws NoSuchAlgorithmException {
        HashSet<SignAlgo> algos = new HashSet<SignAlgo>();
        for (String algoName : algoNames) {
            SignAlgo sa;
            try {
                sa = SignAlgo.getInstance((String)algoName);
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.warn("algorithm is not supported {}, ignore it", (Object)algoName);
                continue;
            }
            algos.add(sa);
        }
        if (algos.isEmpty()) {
            throw new NoSuchAlgorithmException("none of the signature algorithms " + algoNames + " are supported");
        }
        return new CollectionAlgorithmValidator(algos);
    }
}

