/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.util.Set;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.StringUtil;

public class CaHasUserEntry
extends MgmtEntry {
    private NameId userIdent;
    private int permission;
    private Set<String> profiles;

    private CaHasUserEntry() {
    }

    public CaHasUserEntry(NameId userIdent) {
        this.userIdent = (NameId)Args.notNull((Object)userIdent, (String)"userIdent");
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public void setUserIdent(NameId userIdent) {
        this.userIdent = userIdent;
    }

    public NameId getUserIdent() {
        return this.userIdent;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = CollectionUtil.unmodifiableSet((Set)CollectionUtil.toLowerCaseSet(profiles));
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public String toString() {
        return StringUtil.concatObjectsCap((int)200, (Object)"user: ", (Object[])new Object[]{this.userIdent, "\nprofiles: ", this.profiles, "\npermission: ", PermissionConstants.permissionToString(this.permission)});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaHasUserEntry)) {
            return false;
        }
        return this.equals((CaHasUserEntry)obj, false);
    }

    public boolean equals(CaHasUserEntry obj, boolean ignoreId) {
        return obj != null && this.userIdent.equals(obj.userIdent, ignoreId) && this.permission == obj.permission && CompareUtil.equalsObject(this.profiles, obj.profiles);
    }

    public int hashCode() {
        return this.userIdent.hashCode();
    }
}

