/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.math.BigInteger;
import java.security.spec.DSAParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.util.Args;

public class KeypairGenControl {

    public static class EDDSAKeypairGenControl
    extends KeypairGenControl {
        private final AlgorithmIdentifier keyAlgorithm;

        public EDDSAKeypairGenControl(ASN1ObjectIdentifier keyAlgorithmOid) {
            this.keyAlgorithm = new AlgorithmIdentifier((ASN1ObjectIdentifier)Args.notNull((Object)keyAlgorithmOid, (String)"keyAlgorithmOid"));
        }

        public AlgorithmIdentifier getKeyAlgorithm() {
            return this.keyAlgorithm;
        }
    }

    public static class DSAKeypairGenControl
    extends KeypairGenControl {
        private final DSAParameterSpec parameterSpec;
        private final AlgorithmIdentifier keyAlgorithm;

        public DSAKeypairGenControl(int pLength) {
            this(pLength, 0, null);
        }

        public DSAKeypairGenControl(int pLength, int qLength, ASN1ObjectIdentifier keyAlgorithmOid) {
            if (pLength < 1024 || pLength % 1024 != 0) {
                throw new IllegalArgumentException("invalid pLength " + pLength);
            }
            if (qLength == 0) {
                qLength = pLength < 2048 ? 160 : (pLength < 3072 ? 224 : 256);
            }
            this.parameterSpec = DSAParameterCache.getDSAParameterSpec((int)pLength, (int)qLength, null);
            this.keyAlgorithm = new AlgorithmIdentifier(keyAlgorithmOid != null ? keyAlgorithmOid : X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(this.parameterSpec.getP(), this.parameterSpec.getQ(), this.parameterSpec.getG()));
        }

        public DSAKeypairGenControl(BigInteger p, BigInteger q, BigInteger g, ASN1ObjectIdentifier keyAlgorithmOid) {
            this.parameterSpec = new DSAParameterSpec(p, q, g);
            this.keyAlgorithm = new AlgorithmIdentifier(keyAlgorithmOid != null ? keyAlgorithmOid : X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(p, q, g));
        }

        public DSAParameterSpec getParameterSpec() {
            return this.parameterSpec;
        }

        public AlgorithmIdentifier getKeyAlgorithm() {
            return this.keyAlgorithm;
        }
    }

    public static class ECKeypairGenControl
    extends KeypairGenControl {
        private final ASN1ObjectIdentifier curveOid;
        private final AlgorithmIdentifier keyAlgorithm;

        public ECKeypairGenControl(ASN1ObjectIdentifier curveOid) {
            this(curveOid, null);
        }

        public ECKeypairGenControl(ASN1ObjectIdentifier curveOid, ASN1ObjectIdentifier keyAlgorithmOid) {
            this.curveOid = (ASN1ObjectIdentifier)Args.notNull((Object)curveOid, (String)"curveOid");
            this.keyAlgorithm = new AlgorithmIdentifier(keyAlgorithmOid != null ? keyAlgorithmOid : X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid);
        }

        public ASN1ObjectIdentifier getCurveOid() {
            return this.curveOid;
        }

        public AlgorithmIdentifier getKeyAlgorithm() {
            return this.keyAlgorithm;
        }
    }

    public static class RSAKeypairGenControl
    extends KeypairGenControl {
        private final int keysize;
        private final BigInteger publicExponent;
        private final AlgorithmIdentifier keyAlgorithm;

        public RSAKeypairGenControl(int keysize) {
            this(keysize, null, null);
        }

        public RSAKeypairGenControl(int keysize, BigInteger publicExponent, ASN1ObjectIdentifier keyAlgorithmOid) {
            if (keysize < 1024 || keysize % 512 != 0) {
                throw new IllegalArgumentException("invalid keysize " + keysize);
            }
            this.keysize = keysize;
            this.publicExponent = publicExponent != null ? publicExponent : BigInteger.valueOf(65537L);
            this.keyAlgorithm = new AlgorithmIdentifier(keyAlgorithmOid != null ? keyAlgorithmOid : PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
        }

        public int getKeysize() {
            return this.keysize;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public AlgorithmIdentifier getKeyAlgorithm() {
            return this.keyAlgorithm;
        }
    }

    public static class InheritCAKeypairGenControl
    extends KeypairGenControl {
        public static final InheritCAKeypairGenControl INSTANCE = new InheritCAKeypairGenControl();

        private InheritCAKeypairGenControl() {
        }
    }

    public static class ForbiddenKeypairGenControl
    extends KeypairGenControl {
        public static final ForbiddenKeypairGenControl INSTANCE = new ForbiddenKeypairGenControl();

        private ForbiddenKeypairGenControl() {
        }
    }
}

