/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionSpec;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignAlgo;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Validity;

public class CertprofileValidator {
    private static final Validity maxCabEeValidity = new Validity(397, Validity.Unit.DAY);

    public static void validate(Certprofile certprofile) throws CertprofileException {
        int len;
        boolean withMontgomeryCurves;
        Map<ASN1ObjectIdentifier, KeyParametersOption> keyAlgorithms;
        Integer pathLen;
        Certprofile.ExtensionControl control;
        StringBuilder msg = new StringBuilder();
        Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> controls = certprofile.getExtensionControls();
        HashSet<ASN1ObjectIdentifier> types = new HashSet<ASN1ObjectIdentifier>(controls.keySet());
        Certprofile.CertLevel certLevel = certprofile.getCertLevel();
        Certprofile.CertDomain certDomain = certprofile.getCertDomain();
        ExtensionSpec spec = ExtensionSpec.getExtensionSpec(certDomain, certLevel);
        HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            control = controls.get(aSN1ObjectIdentifier);
            if (!control.isRequest() || !spec.isNonRequest(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("extensions ").append(CertprofileValidator.toString(set)).append(" must not be contained in request, ");
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            if (!spec.isNotPermitted(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("extensions ").append(CertprofileValidator.toString(set)).append(" must not be contained, ");
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            control = controls.get(aSN1ObjectIdentifier);
            if (!control.isCritical() || !spec.isNonCriticalOnly(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("critical only extensions are marked as non-critical ").append(CertprofileValidator.toString(set)).append(", ");
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            control = controls.get(aSN1ObjectIdentifier);
            if (control.isCritical() || !spec.isCriticalOnly(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("non-critical only extensions are marked as critical ").append(CertprofileValidator.toString(set)).append(", ");
        }
        set.clear();
        Set<ASN1ObjectIdentifier> requiredTypes = spec.getRequiredExtensions();
        for (ASN1ObjectIdentifier type : requiredTypes) {
            KeyUsage[] extCtrl = controls.get(type);
            if (extCtrl != null && extCtrl.isRequired()) continue;
            set.add(type);
        }
        if (!set.isEmpty()) {
            msg.append("required extensions are not configured or not marked as required ").append(CertprofileValidator.toString(set)).append(", ");
        }
        Set<Certprofile.KeyUsageControl> set2 = certprofile.getKeyUsage();
        if (certLevel == Certprofile.CertLevel.SubCA || certLevel == Certprofile.CertLevel.RootCA) {
            KeyUsage[] requiredUsages;
            for (KeyUsage usage : requiredUsages = new KeyUsage[]{KeyUsage.keyCertSign, KeyUsage.cRLSign}) {
                if (CertprofileValidator.containsKeyusage(set2, usage)) continue;
                msg.append("CA profile does not contain keyUsage ").append(usage).append(", ");
            }
        } else {
            KeyUsage[] caOnlyUsages = new KeyUsage[]{KeyUsage.keyCertSign};
            HashSet<KeyUsage> setUsages = new HashSet<KeyUsage>();
            for (KeyUsage caOnlyUsage : caOnlyUsages) {
                if (!CertprofileValidator.containsKeyusage(set2, caOnlyUsage)) continue;
                setUsages.add(caOnlyUsage);
            }
            if (CollectionUtil.isNotEmpty(setUsages)) {
                msg.append("EndEntity profile must not contain CA-only keyUsage ").append(setUsages).append(", ");
            }
        }
        if (certLevel == Certprofile.CertLevel.RootCA && (pathLen = certprofile.getPathLenBasicConstraint()) != null) {
            msg.append("Root CA must not set PathLen, ");
        }
        if (certDomain == Certprofile.CertDomain.CABForumBR) {
            CertprofileValidator.validateCABForumBR(certprofile, msg);
        }
        boolean withEdwardsCurves = (keyAlgorithms = certprofile.getKeyAlgorithms()).containsKey(EdECConstants.id_ED25519) || keyAlgorithms.containsKey(EdECConstants.id_ED448);
        boolean bl = withMontgomeryCurves = keyAlgorithms.containsKey(EdECConstants.id_X25519) || keyAlgorithms.containsKey(EdECConstants.id_X448);
        if (withEdwardsCurves || withMontgomeryCurves) {
            List<KeyUsage> allowedUsages;
            HashSet<KeyUsage> requiredUsages = new HashSet<KeyUsage>();
            HashSet<KeyUsage> optionalUsages = new HashSet<KeyUsage>();
            for (Certprofile.KeyUsageControl m : set2) {
                if (m.isRequired()) {
                    requiredUsages.add(m.getKeyUsage());
                    continue;
                }
                optionalUsages.add(m.getKeyUsage());
            }
            if (withMontgomeryCurves) {
                if (certLevel != Certprofile.CertLevel.EndEntity) {
                    msg.append("montgomery curves are not permitted in CA certificates, ");
                }
                if (!requiredUsages.contains(KeyUsage.keyAgreement)) {
                    msg.append("required KeyUsage KeyAgreement is not marked as 'required', ");
                }
                allowedUsages = Arrays.asList(KeyUsage.keyAgreement, KeyUsage.encipherOnly, KeyUsage.decipherOnly);
            } else if (certLevel == Certprofile.CertLevel.EndEntity) {
                if (!requiredUsages.contains(KeyUsage.digitalSignature) && !requiredUsages.contains(KeyUsage.contentCommitment)) {
                    msg.append("required KeyUsage digitalSignature or contentCommitment is not marked as 'required', ");
                }
                allowedUsages = Arrays.asList(KeyUsage.digitalSignature, KeyUsage.contentCommitment);
            } else {
                allowedUsages = Arrays.asList(KeyUsage.digitalSignature, KeyUsage.contentCommitment, KeyUsage.keyCertSign, KeyUsage.cRLSign);
            }
            requiredUsages.removeAll(allowedUsages);
            optionalUsages.removeAll(allowedUsages);
            if (!requiredUsages.isEmpty()) {
                msg.append("Required KeyUsage items ").append(requiredUsages).append(" are not permitted, ");
            }
            if (!optionalUsages.isEmpty()) {
                msg.append("Optional KeyUsage items ").append(requiredUsages).append(" are not permitted, ");
            }
        }
        if ((len = msg.length()) > 2) {
            msg.delete(len - 2, len);
            throw new CertprofileException(msg.toString());
        }
    }

    private static void validateCABForumBR(Certprofile certprofile, StringBuilder msg) {
        CertificatePolicies certPolicyValue;
        List<SignAlgo> sigAlgos;
        Validity validity;
        Certprofile.SubjectControl subjectCtl = certprofile.getSubjectControl();
        if (CollectionUtil.isNotEmpty(subjectCtl.getGroups())) {
            msg.append("multiple AttributeAndTypes in one RDN is not permitted, ");
        }
        for (ASN1ObjectIdentifier m : subjectCtl.getTypes()) {
            Certprofile.RdnControl ctl = subjectCtl.getControl(m);
            if (ctl.getMaxOccurs() <= 1) continue;
            msg.append("multiple RDNs of the same type are not permitted, ");
        }
        Certprofile.CertLevel certLevel = certprofile.getCertLevel();
        if (certLevel == Certprofile.CertLevel.EndEntity && (validity = certprofile.getValidity()).compareTo(maxCabEeValidity) > 0) {
            msg.append("validity exceeds the maximal validity of subscriber certificate, ");
        }
        if ((sigAlgos = certprofile.getSignatureAlgorithms()) == null) {
            msg.append("signature algorithms not defined, ");
        } else {
            List<HashAlgo> allowedHashAlgos = Arrays.asList(HashAlgo.SHA256, HashAlgo.SHA384, HashAlgo.SHA512);
            for (SignAlgo signAlgo : sigAlgos) {
                HashAlgo hashAlgo = signAlgo.getHashAlgo();
                if (allowedHashAlgos.contains(hashAlgo)) continue;
                msg.append("unpermitted hash algorithm ").append(hashAlgo).append(", ");
            }
        }
        Map<ASN1ObjectIdentifier, KeyParametersOption> keyAlgorithms = certprofile.getKeyAlgorithms();
        if (CollectionUtil.isEmpty(keyAlgorithms)) {
            msg.append("keyAlgorithms is not configured, ");
        } else {
            for (Map.Entry<ASN1ObjectIdentifier, KeyParametersOption> entry : keyAlgorithms.entrySet()) {
                ASN1ObjectIdentifier m = entry.getKey();
                KeyParametersOption opt = entry.getValue();
                if (m.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                    if (opt instanceof KeyParametersOption.RSAParametersOption) {
                        if (!((KeyParametersOption.RSAParametersOption)opt).allowsModulusLength(2047)) continue;
                        msg.append("minimum RSA modulus size 2048 bit not satisfied, ");
                        continue;
                    }
                    msg.append("unpermitted RSA modulus are configured, ");
                    continue;
                }
                if (m.equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey)) {
                    if (opt instanceof KeyParametersOption.ECParamatersOption) {
                        HashSet<ASN1ObjectIdentifier> curveOids = new HashSet<ASN1ObjectIdentifier>(((KeyParametersOption.ECParamatersOption)opt).getCurveOids());
                        curveOids.remove(SECObjectIdentifiers.secp256r1);
                        curveOids.remove(SECObjectIdentifiers.secp384r1);
                        curveOids.remove(SECObjectIdentifiers.secp521r1);
                        if (curveOids.isEmpty()) continue;
                        msg.append("EC curves ").append(curveOids).append(" are not permitted, ");
                        continue;
                    }
                    msg.append("unpermitted EC curves are configured, ");
                    continue;
                }
                if (m.equals((ASN1Primitive)X9ObjectIdentifiers.id_dsa)) {
                    if (opt instanceof KeyParametersOption.DSAParametersOption) {
                        KeyParametersOption.DSAParametersOption dsaOpt = (KeyParametersOption.DSAParametersOption)opt;
                        if (dsaOpt.allowsPlength(2047)) {
                            msg.append("minimum L (2048) not satisfied, ");
                        }
                        if (!dsaOpt.allowsQlength(223)) continue;
                        msg.append("minimum N (224) not satisfied, ");
                        continue;
                    }
                    msg.append("unpermitted DSA (p,q) are configured, ");
                    continue;
                }
                msg.append("keyAlgorithm ").append(m.getId()).append(" is not permitted, ");
            }
        }
        if (certLevel != Certprofile.CertLevel.RootCA) {
            Certprofile.AuthorityInfoAccessControl aiaControl;
            Set<String> protocols;
            Certprofile.CrlDistributionPointsControl freshestCrlControl;
            Set<String> protocols2;
            Certprofile.CrlDistributionPointsControl crlDpControl = certprofile.getCrlDpControl();
            if (!(crlDpControl == null || (protocols2 = crlDpControl.getProtocols()) != null && protocols2.size() == 1 && protocols2.contains("http"))) {
                msg.append("CRLDistributionPoints allows protocol other than http, ");
            }
            if (!((freshestCrlControl = certprofile.getFreshestCrlControl()) == null || (protocols = freshestCrlControl.getProtocols()) != null && protocols.size() == 1 && protocols.contains("http"))) {
                msg.append("FreshestCRL allows protocol other than http, ");
            }
            if ((aiaControl = certprofile.getAiaControl()) != null) {
                Set<String> protocols3;
                if (!aiaControl.isIncludesOcsp()) {
                    msg.append("access method id-ad-ocsp is not configured, ");
                } else {
                    protocols3 = aiaControl.getOcspProtocols();
                    if (protocols3 == null || protocols3.size() != 1 || !protocols3.contains("http")) {
                        msg.append("AIA OCSP allows protocol other than http, ");
                    }
                }
                if (!aiaControl.isIncludesCaIssuers()) {
                    msg.append("access method id-ad-caIssuers is not configured, ");
                } else {
                    protocols3 = aiaControl.getCaIssuersProtocols();
                    if (protocols3 == null || protocols3.size() != 1 || !protocols3.contains("http")) {
                        msg.append("AIA CAIssuers allows protocol other than http, ");
                    }
                }
            }
        }
        if ((certLevel == Certprofile.CertLevel.SubCA || certLevel == Certprofile.CertLevel.EndEntity) && (certPolicyValue = certprofile.getCertificatePolicies()) == null) {
            msg.append("CertificatePolicies is not configured, ");
        }
        Set<Certprofile.KeyUsageControl> usages = certprofile.getKeyUsage();
        if (certLevel == Certprofile.CertLevel.RootCA || certLevel == Certprofile.CertLevel.SubCA) {
            if (!CertprofileValidator.containsKeyusage(usages, KeyUsage.cRLSign)) {
                msg.append("RootCA profile does contain keyUsage ").append(KeyUsage.cRLSign).append(", ");
            }
        } else if (certLevel == Certprofile.CertLevel.EndEntity && CertprofileValidator.containsKeyusage(usages, KeyUsage.cRLSign)) {
            msg.append("EndEntity profile must not contain keyUsage ").append(KeyUsage.cRLSign).append(", ");
        }
        Set<Certprofile.ExtKeyUsageControl> ekuControls = certprofile.getExtendedKeyUsages();
        if (certLevel == Certprofile.CertLevel.EndEntity) {
            boolean xkuTlsServerRequired = false;
            boolean xkuTlsClientRequired = false;
            for (Certprofile.ExtKeyUsageControl m : ekuControls) {
                ASN1ObjectIdentifier oid = m.getExtKeyUsage();
                if (m.isRequired()) {
                    if (ObjectIdentifiers.XKU.id_kp_serverAuth.equals((ASN1Primitive)oid)) {
                        xkuTlsServerRequired = true;
                    } else if (ObjectIdentifiers.XKU.id_kp_clientAuth.equals((ASN1Primitive)oid)) {
                        xkuTlsClientRequired = true;
                    }
                }
                if (ObjectIdentifiers.XKU.id_kp_serverAuth.equals((ASN1Primitive)oid) || ObjectIdentifiers.XKU.id_kp_clientAuth.equals((ASN1Primitive)oid) || ObjectIdentifiers.XKU.id_kp_emailProtection.equals((ASN1Primitive)oid)) continue;
                msg.append("extendedKeyUsage ").append(oid.getId()).append(" is not permitted, ");
            }
            if (!(xkuTlsClientRequired | xkuTlsServerRequired)) {
                msg.append("none of ").append(ObjectIdentifiers.XKU.id_kp_clientAuth).append(" and ").append(ObjectIdentifiers.XKU.id_kp_serverAuth).append(" is not configured, ");
            }
        } else if (ekuControls != null) {
            for (Certprofile.ExtKeyUsageControl m : ekuControls) {
                if (!m.getExtKeyUsage().equals((ASN1Primitive)ObjectIdentifiers.XKU.id_kp_anyExtendedKeyUsage)) continue;
                msg.append(ObjectIdentifiers.XKU.id_kp_clientAuth).append(" is not allowed, ");
            }
        }
    }

    private static boolean containsKeyusage(Set<Certprofile.KeyUsageControl> usageControls, KeyUsage usage) {
        for (Certprofile.KeyUsageControl entry : usageControls) {
            if (usage != entry.getKeyUsage()) continue;
            return true;
        }
        return false;
    }

    private static String toString(Set<ASN1ObjectIdentifier> oids) {
        if (oids == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ASN1ObjectIdentifier oid : oids) {
            String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
            if (name != null) {
                sb.append(name);
                sb.append(" (").append(oid.getId()).append(")");
            } else {
                sb.append(oid.getId());
            }
            sb.append(", ");
        }
        if (CollectionUtil.isNotEmpty(oids)) {
            int len = sb.length();
            sb.delete(len - 2, len);
        }
        sb.append("]");
        return sb.toString();
    }
}

