/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class CaEntry
extends MgmtEntry {
    private NameId ident;
    private CaStatus status;
    private Validity maxValidity;
    private String signerType;
    private String signerConf;
    private String dhpocControl;
    private ScepControl scepControl;
    private CrlControl crlControl;
    private String crlSignerName;
    private CmpControl cmpControl;
    private CtlogControl ctlogControl;
    private RevokeSuspendedControl revokeSuspendedControl;
    private String cmpResponderName;
    private String scepResponderName;
    private ProtocolSupport protocolSupport;
    private boolean saveRequest;
    private ValidityMode validityMode = ValidityMode.STRICT;
    private int permission;
    private int expirationPeriod;
    private int keepExpiredCertInDays;
    private ConfPairs extraControl;
    private CaUris caUris;
    private X509Cert cert;
    private int pathLenConstraint;
    private List<X509Cert> certchain;
    private int serialNoLen;
    private long nextCrlNumber;
    private int numCrls;
    private CertRevocationInfo revocationInfo;
    private String subject;
    private String hexSha1OfCert;

    private CaEntry() {
    }

    public CaEntry(NameId ident, int serialNoLen, long nextCrlNumber, String signerType, String signerConf, CaUris caUris, int numCrls, int expirationPeriod) {
        this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        this.signerType = Args.toNonBlankLower((String)signerType, (String)"signerType");
        this.expirationPeriod = Args.notNegative((int)expirationPeriod, (String)"expirationPeriod");
        this.signerConf = Args.notBlank((String)signerConf, (String)"signerConf");
        this.numCrls = Args.positive((int)numCrls, (String)"numCrls");
        this.serialNoLen = Args.range((int)serialNoLen, (String)"serialNoLen", (int)1, (int)20);
        this.nextCrlNumber = Args.positive((long)nextCrlNumber, (String)"nextCrlNumber");
        this.caUris = caUris == null ? CaUris.EMPTY_INSTANCE : caUris;
    }

    public static List<CaSignerConf> splitCaSignerConfs(String conf) throws XiSecurityException {
        ConfPairs pairs = new ConfPairs(conf);
        String str = pairs.value("algo");
        if (str == null) {
            throw new XiSecurityException("no algo is defined in CA signerConf");
        }
        List list = StringUtil.split((String)str, (String)":");
        if (CollectionUtil.isEmpty((Collection)list)) {
            throw new XiSecurityException("empty algo is defined in CA signerConf");
        }
        ArrayList<CaSignerConf> signerConfs = new ArrayList<CaSignerConf>(list.size());
        for (String n : list) {
            SignAlgo signAlgo;
            try {
                signAlgo = SignAlgo.getInstance((String)n);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
            }
            pairs.putPair("algo", signAlgo.getJceName());
            signerConfs.add(new CaSignerConf(signAlgo, pairs.getEncoded()));
        }
        return signerConfs;
    }

    public NameId getIdent() {
        return this.ident;
    }

    public Validity getMaxValidity() {
        return this.maxValidity;
    }

    public void setMaxValidity(Validity maxValidity) {
        this.maxValidity = maxValidity;
    }

    public int getKeepExpiredCertInDays() {
        return this.keepExpiredCertInDays;
    }

    public void setKeepExpiredCertInDays(int days) {
        this.keepExpiredCertInDays = days;
    }

    public void setSignerConf(String signerConf) {
        this.signerConf = Args.notBlank((String)signerConf, (String)"signerConf");
    }

    public String getSignerConf() {
        return this.signerConf;
    }

    public CaStatus getStatus() {
        return this.status;
    }

    public void setStatus(CaStatus status) {
        this.status = status;
    }

    public String getSignerType() {
        return this.signerType;
    }

    public void setCmpControl(CmpControl cmpControl) {
        this.cmpControl = cmpControl;
    }

    public CmpControl getCmpControl() {
        return this.cmpControl;
    }

    public void setCrlControl(CrlControl crlControl) {
        this.crlControl = crlControl;
    }

    public CrlControl getCrlControl() {
        return this.crlControl;
    }

    public String getDhpocControl() {
        return this.dhpocControl;
    }

    public void setDhpocControl(String dhpocControl) {
        this.dhpocControl = dhpocControl;
    }

    public void setScepControl(ScepControl scepControl) {
        this.scepControl = scepControl;
    }

    public ScepControl getScepControl() {
        return this.scepControl;
    }

    public CtlogControl getCtlogControl() {
        return this.ctlogControl;
    }

    public void setCtlogControl(CtlogControl ctlogControl) {
        this.ctlogControl = ctlogControl;
    }

    public RevokeSuspendedControl getRevokeSuspendedControl() {
        return this.revokeSuspendedControl;
    }

    public void setRevokeSuspendedControl(RevokeSuspendedControl revokeSuspendedControl) {
        this.revokeSuspendedControl = revokeSuspendedControl;
    }

    public String getCmpResponderName() {
        return this.cmpResponderName;
    }

    public void setCmpResponderName(String cmpResponderName) {
        this.cmpResponderName = cmpResponderName == null ? null : cmpResponderName.toLowerCase();
    }

    public String getScepResponderName() {
        return this.scepResponderName;
    }

    public void setScepResponderName(String scepResponderName) {
        this.scepResponderName = scepResponderName == null ? null : scepResponderName.toLowerCase();
    }

    public String getCrlSignerName() {
        return this.crlSignerName;
    }

    public void setCrlSignerName(String crlSignerName) {
        this.crlSignerName = crlSignerName == null ? null : crlSignerName.toLowerCase();
    }

    public ProtocolSupport getProtocoSupport() {
        return this.protocolSupport;
    }

    public void setProtocolSupport(ProtocolSupport protocolSupport) {
        this.protocolSupport = protocolSupport;
    }

    public boolean isSaveRequest() {
        return this.saveRequest;
    }

    public void setSaveRequest(boolean saveRequest) {
        this.saveRequest = saveRequest;
    }

    public ValidityMode getValidityMode() {
        return this.validityMode;
    }

    public void setValidityMode(ValidityMode mode) {
        this.validityMode = (ValidityMode)((Object)Args.notNull((Object)((Object)mode), (String)"mode"));
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public int getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public ConfPairs getExtraControl() {
        return this.extraControl;
    }

    public void setExtraControl(ConfPairs extraControl) {
        this.extraControl = extraControl;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        return this.toString(verbose, true);
    }

    public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
        String extraCtrlText;
        if (this.extraControl == null) {
            extraCtrlText = "null";
        } else {
            extraCtrlText = this.extraControl.getEncoded();
            if (!verbose && extraCtrlText.length() > 100) {
                extraCtrlText = StringUtil.concat((String)extraCtrlText.substring(0, 97), (String[])new String[]{"..."});
            }
        }
        String revInfoText = "";
        if (this.revocationInfo != null) {
            revInfoText = StringUtil.concatObjectsCap((int)30, (Object)"\n\treason: ", (Object[])new Object[]{this.revocationInfo.getReason().getDescription(), "\n\trevoked at ", this.revocationInfo.getRevocationTime()});
        }
        int certchainSize = this.certchain == null ? 0 : this.certchain.size();
        StringBuilder certchainStr = new StringBuilder(20 + certchainSize * 200);
        certchainStr.append("\ncertchain: ");
        if (certchainSize > 0) {
            for (int i = 0; i < certchainSize; ++i) {
                certchainStr.append("\ncert[").append(i).append("]:\n");
                certchainStr.append(X509Util.formatCert((X509Cert)this.certchain.get(i), (boolean)verbose));
            }
        } else {
            certchainStr.append("null");
        }
        List<String> permissionList = PermissionConstants.permissionToStringSet(this.permission);
        StringBuilder buffer = new StringBuilder();
        for (String m : permissionList) {
            buffer.append("\n  ").append(m);
        }
        String permissionText = buffer.toString();
        return StringUtil.concatObjectsCap((int)1500, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nstatus: ", this.status == null ? "null" : this.status.getStatus(), "\nmax. validity: ", this.maxValidity, "\nexpiration period: ", this.expirationPeriod, "d", "\nsigner type: ", this.signerType, "\nsigner conf: ", this.signerConf == null ? "null" : SignerEntry.signerConfToString(this.signerConf, verbose, ignoreSensitiveInfo), "\nDHPoc control: ", this.dhpocControl == null ? "null" : SignerEntry.signerConfToString(this.dhpocControl, verbose, ignoreSensitiveInfo), "\nCMP control:\n", this.cmpControl == null ? "  null" : this.cmpControl.toString(verbose), "\nCRL control:\n", this.crlControl == null ? "  null" : this.crlControl.toString(verbose), "\nSCEP control: \n", this.scepControl == null ? "  null" : this.scepControl.toString(verbose), "\nCTLog control: \n", this.ctlogControl == null ? "  null" : this.ctlogControl.toString(), "\nrevoke suspended certificates control: \n", this.revokeSuspendedControl == null ? "  null" : this.revokeSuspendedControl.toString(), "\nCMP responder name: ", this.cmpResponderName, "\nSCEP responder name: ", this.scepResponderName, "\nCRL signer name: ", this.crlSignerName, "\n", this.protocolSupport, "\nsave request: ", this.saveRequest, "\nvalidity mode: ", this.validityMode, "\npermission:", permissionText, "\nkeep expired certs: ", this.keepExpiredCertInDays < 0 ? "forever" : this.keepExpiredCertInDays + " days", "\nextra control: ", extraCtrlText, "\nserial number length: ", this.serialNoLen, " bytes", "\nnext CRL number: ", this.nextCrlNumber, "\n", this.caUris, "\nrevocation: ", this.revocationInfo == null ? "not revoked" : "revoked", revInfoText, "\ncert: \n", X509Util.formatCert((X509Cert)this.cert, (boolean)verbose), certchainStr.toString()});
    }

    protected static String urisToString(Collection<?> tokens) {
        if (CollectionUtil.isEmpty(tokens)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        int idx = 0;
        for (Object token : tokens) {
            sb.append(token);
            if (idx++ >= size - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaEntry)) {
            return false;
        }
        return this.equals((CaEntry)obj, false, false);
    }

    public boolean equals(CaEntry obj, boolean ignoreDynamicFields, boolean ignoreId) {
        if (!ignoreDynamicFields && this.nextCrlNumber != obj.nextCrlNumber) {
            return false;
        }
        return CompareUtil.equalsObject((Object)this.caUris, (Object)obj.caUris) && CompareUtil.equalsObject((Object)this.cert, (Object)obj.cert) && CompareUtil.equalsObject(this.certchain, obj.certchain) && CompareUtil.equalsObject((Object)this.cmpControl, (Object)obj.cmpControl) && CompareUtil.equalsObject((Object)this.cmpResponderName, (Object)obj.cmpResponderName) && CompareUtil.equalsObject((Object)this.crlControl, (Object)obj.crlControl) && CompareUtil.equalsObject((Object)this.crlSignerName, (Object)obj.crlSignerName) && CompareUtil.equalsObject((Object)this.ctlogControl, (Object)obj.ctlogControl) && CompareUtil.equalsObject((Object)this.dhpocControl, (Object)obj.dhpocControl) && this.expirationPeriod == obj.expirationPeriod && CompareUtil.equalsObject((Object)this.extraControl, (Object)obj.extraControl) && this.ident.equals(obj.ident, ignoreId) && this.keepExpiredCertInDays == obj.keepExpiredCertInDays && CompareUtil.equalsObject((Object)this.maxValidity, (Object)obj.maxValidity) && this.numCrls == obj.numCrls && this.permission == obj.permission && CompareUtil.equalsObject((Object)this.protocolSupport, (Object)obj.protocolSupport) && CompareUtil.equalsObject((Object)this.revocationInfo, (Object)obj.revocationInfo) && CompareUtil.equalsObject((Object)this.revokeSuspendedControl, (Object)obj.revokeSuspendedControl) && this.saveRequest == obj.saveRequest && CompareUtil.equalsObject((Object)this.scepControl, (Object)obj.scepControl) && CompareUtil.equalsObject((Object)this.scepResponderName, (Object)obj.scepResponderName) && this.serialNoLen == obj.serialNoLen && this.signerType.equals(obj.signerType) && CompareUtil.equalsObject((Object)this.signerConf, (Object)obj.signerConf) && CompareUtil.equalsObject((Object)((Object)this.status), (Object)((Object)obj.status)) && CompareUtil.equalsObject((Object)((Object)this.validityMode), (Object)((Object)obj.validityMode));
    }

    public int hashCode() {
        return this.ident.hashCode();
    }

    public void setCert(X509Cert cert) throws CaMgmtException {
        if (cert == null) {
            this.cert = null;
            this.subject = null;
            this.hexSha1OfCert = null;
        } else {
            if (!cert.hasKeyusage(KeyUsage.keyCertSign)) {
                throw new CaMgmtException("CA certificate does not have keyusage keyCertSign");
            }
            this.cert = cert;
            this.pathLenConstraint = cert.getBasicConstraints();
            if (this.pathLenConstraint < 0) {
                throw new CaMgmtException("given certificate is not a CA certificate");
            }
            this.subject = cert.getSubjectRfc4519Text();
            byte[] encodedCert = cert.getEncoded();
            this.hexSha1OfCert = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{encodedCert});
        }
    }

    public int getSerialNoLen() {
        return this.serialNoLen;
    }

    public void setSerialNoLen(int serialNoLen) {
        this.serialNoLen = Args.range((int)serialNoLen, (String)"serialNoLen", (int)1, (int)20);
    }

    public long getNextCrlNumber() {
        return this.nextCrlNumber;
    }

    public void setNextCrlNumber(long crlNumber) {
        this.nextCrlNumber = crlNumber;
    }

    public CaUris getCaUris() {
        return this.caUris;
    }

    public X509Cert getCert() {
        return this.cert;
    }

    public List<X509Cert> getCertchain() {
        return this.certchain;
    }

    public void setCertchain(List<X509Cert> certchain) {
        this.certchain = certchain;
    }

    public int getNumCrls() {
        return this.numCrls;
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public void setRevocationInfo(CertRevocationInfo revocationInfo) {
        this.revocationInfo = revocationInfo;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getPathLenConstraint() {
        return this.pathLenConstraint;
    }

    public String getHexSha1OfCert() {
        return this.hexSha1OfCert;
    }

    public static class CaSignerConf {
        private final SignAlgo algo;
        private final String conf;

        private CaSignerConf(SignAlgo algo, String conf) {
            this.algo = algo;
            this.conf = conf;
        }

        public SignAlgo getAlgo() {
            return this.algo;
        }

        public String getConf() {
            return this.conf;
        }
    }
}

