/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileFactory;
import org.xipki.util.Args;
import org.xipki.util.ObjectCreationException;

public class CertprofileFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(CertprofileFactoryRegister.class);
    private final ConcurrentLinkedDeque<CertprofileFactory> factories = new ConcurrentLinkedDeque();

    public Set<String> getSupportedTypes() {
        HashSet<String> types = new HashSet<String>();
        for (CertprofileFactory service : this.factories) {
            types.addAll(service.getSupportedTypes());
        }
        return Collections.unmodifiableSet(types);
    }

    public boolean canCreateProfile(String type) {
        for (CertprofileFactory service : this.factories) {
            if (!service.canCreateProfile(type)) continue;
            return true;
        }
        return false;
    }

    public Certprofile newCertprofile(String type) throws ObjectCreationException {
        Args.notBlank((String)type, (String)"type");
        for (CertprofileFactory service : this.factories) {
            if (!service.canCreateProfile(type)) continue;
            return service.newCertprofile(type);
        }
        throw new ObjectCreationException("could not find factory to create Certprofile of type '" + type + "'");
    }

    public void registFactory(CertprofileFactory factory) {
        if (factory == null) {
            LOG.info("registFactroy invoked with null.");
            return;
        }
        boolean replaced = this.factories.remove(factory);
        this.factories.add(factory);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} CertprofileFactory binding for {}", (Object)action, (Object)factory);
    }

    public void unregistFactory(CertprofileFactory factory) {
        if (factory == null) {
            LOG.debug("unregistFactory invoked with null.");
            return;
        }
        if (this.factories.remove(factory)) {
            LOG.info("removed CertprofileFactory binding for {}", (Object)factory);
        } else {
            LOG.info("no CertprofileFactory binding found to remove for '{}'", (Object)factory);
        }
    }
}

