/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.Range;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class KeyParametersOption {
    public static final AllowAllParametersOption ALLOW_ALL = new AllowAllParametersOption();

    private KeyParametersOption() {
    }

    public static class ECParamatersOption
    extends KeyParametersOption {
        private Set<ASN1ObjectIdentifier> curveOids;
        private Set<Byte> pointEncodings;

        public Set<ASN1ObjectIdentifier> curveOids() {
            return this.curveOids;
        }

        public void setCurveOids(Set<ASN1ObjectIdentifier> curveOids) {
            this.curveOids = curveOids;
        }

        public Set<ASN1ObjectIdentifier> getCurveOids() {
            return this.curveOids;
        }

        public void setPointEncodings(Set<Byte> pointEncodings) {
            this.pointEncodings = pointEncodings;
        }

        public Set<Byte> getPointEncodings() {
            return this.pointEncodings;
        }

        public boolean allowsCurve(ASN1ObjectIdentifier curveOid) {
            Args.notNull((Object)curveOid, (String)"curveOid");
            return this.curveOids == null || this.curveOids.contains(curveOid);
        }

        public boolean allowsPointEncoding(byte encoding) {
            return this.pointEncodings == null || this.pointEncodings.contains(encoding);
        }
    }

    public static class DSAParametersOption
    extends KeyParametersOption {
        private Set<Range> plengths;
        private Set<Range> qlengths;

        public void setPlengths(Set<Range> plengths) {
            this.plengths = CollectionUtil.isEmpty(plengths) ? null : new HashSet<Range>(plengths);
        }

        public void setQlengths(Set<Range> qlengths) {
            this.qlengths = CollectionUtil.isEmpty(qlengths) ? null : new HashSet<Range>(qlengths);
        }

        public boolean allowsPlength(int plength) {
            if (this.plengths == null) {
                return true;
            }
            for (Range range : this.plengths) {
                if (!range.match(plength)) continue;
                return true;
            }
            return false;
        }

        public boolean allowsQlength(int qlength) {
            if (this.qlengths == null) {
                return true;
            }
            for (Range range : this.qlengths) {
                if (!range.match(qlength)) continue;
                return true;
            }
            return false;
        }
    }

    public static class RSAParametersOption
    extends KeyParametersOption {
        private Set<Range> modulusLengths;

        public void setModulusLengths(Set<Range> modulusLengths) {
            this.modulusLengths = CollectionUtil.isEmpty(modulusLengths) ? null : new HashSet<Range>(modulusLengths);
        }

        public boolean allowsModulusLength(int modulusLength) {
            if (this.modulusLengths == null) {
                return true;
            }
            for (Range range : this.modulusLengths) {
                if (!range.match(modulusLength)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AllowAllParametersOption
    extends KeyParametersOption {
    }
}

