/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.MgmtMessage;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.util.X509Util;

public abstract class MgmtResponse
extends MgmtMessage {

    public static class StringSet
    extends MgmtResponse {
        private Set<String> result;

        public StringSet() {
        }

        public StringSet(Set<String> result) {
            this.result = result;
        }

        public Set<String> getResult() {
            return this.result;
        }

        public void setResult(Set<String> result) {
            this.result = result;
        }
    }

    public static class StringResponse
    extends MgmtResponse {
        private String result;

        public StringResponse() {
        }

        public StringResponse(String result) {
            this.result = result;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }

    public static class LoadConf
    extends MgmtResponse {
        private Map<String, byte[]> result;

        public LoadConf() {
        }

        public LoadConf(Map<String, byte[]> result) {
            this.result = result;
        }

        public Map<String, byte[]> getResult() {
            return this.result;
        }

        public void setResult(Map<String, byte[]> result) {
            this.result = result;
        }
    }

    public static class ListCertificates
    extends MgmtResponse {
        private List<CertListInfo> result;

        public ListCertificates() {
        }

        public ListCertificates(List<CertListInfo> result) {
            this.result = result;
        }

        public List<CertListInfo> getResult() {
            return this.result;
        }

        public void setResult(List<CertListInfo> result) {
            this.result = result;
        }
    }

    public static class GetUser
    extends MgmtResponse {
        private MgmtEntry.User result;

        public GetUser() {
        }

        public GetUser(MgmtEntry.User result) {
            this.result = result;
        }

        public MgmtEntry.User getResult() {
            return this.result;
        }

        public void setResult(MgmtEntry.User result) {
            this.result = result;
        }
    }

    public static class GetSigner
    extends MgmtResponse {
        private MgmtMessage.SignerEntryWrapper result;

        public GetSigner() {
        }

        public GetSigner(MgmtMessage.SignerEntryWrapper result) {
            this.result = result;
        }

        public MgmtMessage.SignerEntryWrapper getResult() {
            return this.result;
        }

        public void setResult(MgmtMessage.SignerEntryWrapper result) {
            this.result = result;
        }
    }

    public static class GetRequestorsForCa
    extends MgmtResponse {
        private Set<MgmtEntry.CaHasRequestor> result;

        public GetRequestorsForCa() {
        }

        public GetRequestorsForCa(Set<MgmtEntry.CaHasRequestor> result) {
            this.result = result;
        }

        public Set<MgmtEntry.CaHasRequestor> getResult() {
            return this.result;
        }

        public void setResult(Set<MgmtEntry.CaHasRequestor> result) {
            this.result = result;
        }
    }

    public static class GetRequestor
    extends MgmtResponse {
        private MgmtEntry.Requestor result;

        public GetRequestor() {
        }

        public GetRequestor(MgmtEntry.Requestor result) {
            this.result = result;
        }

        public MgmtEntry.Requestor getResult() {
            return this.result;
        }

        public void setResult(MgmtEntry.Requestor result) {
            this.result = result;
        }
    }

    public static class GetPublisher
    extends MgmtResponse {
        private MgmtEntry.Publisher result;

        public GetPublisher() {
        }

        public GetPublisher(MgmtEntry.Publisher result) {
            this.result = result;
        }

        public MgmtEntry.Publisher getResult() {
            return this.result;
        }

        public void setResult(MgmtEntry.Publisher result) {
            this.result = result;
        }
    }

    public static class GetPublischersForCa
    extends MgmtResponse {
        private List<MgmtEntry.Publisher> result;

        public GetPublischersForCa() {
        }

        public GetPublischersForCa(List<MgmtEntry.Publisher> result) {
            this.result = result;
        }

        public List<MgmtEntry.Publisher> getResult() {
            return this.result;
        }

        public void setResult(List<MgmtEntry.Publisher> result) {
            this.result = result;
        }
    }

    public static class GetCert
    extends MgmtResponse {
        private CertWithRevocationInfoWrapper result;

        public GetCert() {
        }

        public GetCert(CertWithRevocationInfoWrapper result) {
            this.result = result;
        }

        public CertWithRevocationInfoWrapper getResult() {
            return this.result;
        }

        public void setResult(CertWithRevocationInfoWrapper result) {
            this.result = result;
        }
    }

    public static class GetCertprofile
    extends MgmtResponse {
        private MgmtEntry.Certprofile result;

        public GetCertprofile() {
        }

        public GetCertprofile(MgmtEntry.Certprofile result) {
            this.result = result;
        }

        public MgmtEntry.Certprofile getResult() {
            return this.result;
        }

        public void setResult(MgmtEntry.Certprofile result) {
            this.result = result;
        }
    }

    public static class GetCaSystemStatus
    extends MgmtResponse {
        private CaSystemStatus result;

        public GetCaSystemStatus() {
        }

        public GetCaSystemStatus(CaSystemStatus result) {
            this.result = result;
        }

        public CaSystemStatus getResult() {
            return this.result;
        }

        public void setResult(CaSystemStatus result) {
            this.result = result;
        }
    }

    public static class GetCaHasUsersForUser
    extends MgmtResponse {
        private Map<String, MgmtEntry.CaHasUser> result;

        public GetCaHasUsersForUser() {
        }

        public GetCaHasUsersForUser(Map<String, MgmtEntry.CaHasUser> result) {
            this.result = result;
        }

        public Map<String, MgmtEntry.CaHasUser> getResult() {
            return this.result;
        }

        public void setResult(Map<String, MgmtEntry.CaHasUser> result) {
            this.result = result;
        }
    }

    public static class GetCaHasUserForUser
    extends MgmtResponse {
        private Map<String, MgmtEntry.CaHasUser> result;

        public GetCaHasUserForUser() {
        }

        public GetCaHasUserForUser(Map<String, MgmtEntry.CaHasUser> result) {
            this.result = result;
        }

        public Map<String, MgmtEntry.CaHasUser> getResult() {
            return this.result;
        }

        public void setResult(Map<String, MgmtEntry.CaHasUser> result) {
            this.result = result;
        }
    }

    public static class GetCa
    extends MgmtResponse {
        private MgmtMessage.CaEntryWrapper result;

        public GetCa() {
        }

        public GetCa(MgmtMessage.CaEntryWrapper result) {
            this.result = result;
        }

        public MgmtMessage.CaEntryWrapper getResult() {
            return this.result;
        }

        public void setResult(MgmtMessage.CaEntryWrapper result) {
            this.result = result;
        }
    }

    public static class GetAliasesForCa
    extends MgmtResponse {
        private Set<String> result;

        public GetAliasesForCa() {
        }

        public GetAliasesForCa(Set<String> result) {
            this.result = result;
        }

        public Set<String> getResult() {
            return this.result;
        }

        public void setResult(Set<String> result) {
            this.result = result;
        }
    }

    public static class Error
    extends MgmtResponse {
        private String message;

        public Error() {
        }

        public Error(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static class ByteArray
    extends MgmtResponse {
        private byte[] result;

        public ByteArray() {
        }

        public ByteArray(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }
    }

    public static class CertWithRevocationInfoWrapper {
        private CertWithDbIdWrapper cert;
        private CertRevocationInfo revInfo;
        private String certprofile;

        public CertWithRevocationInfoWrapper() {
        }

        public CertWithRevocationInfoWrapper(CertWithRevocationInfo info) {
            this.cert = new CertWithDbIdWrapper(info.getCert());
            this.revInfo = info.getRevInfo();
            this.certprofile = info.getCertprofile();
        }

        public CertWithDbIdWrapper getCert() {
            return this.cert;
        }

        public void setCert(CertWithDbIdWrapper cert) {
            this.cert = cert;
        }

        public CertRevocationInfo getRevInfo() {
            return this.revInfo;
        }

        public void setRevInfo(CertRevocationInfo revInfo) {
            this.revInfo = revInfo;
        }

        public String getCertprofile() {
            return this.certprofile;
        }

        public void setCertprofile(String certprofile) {
            this.certprofile = certprofile;
        }

        public CertWithRevocationInfo toCertWithRevocationInfo() throws CertificateException {
            CertWithRevocationInfo ret = new CertWithRevocationInfo();
            ret.setCert(this.cert.toCertWithDbId());
            ret.setCertprofile(this.certprofile);
            ret.setRevInfo(this.revInfo);
            return ret;
        }
    }

    public static class CertWithDbIdWrapper {
        private byte[] cert;
        private Long certId;

        public CertWithDbIdWrapper() {
        }

        public CertWithDbIdWrapper(CertWithDbId certWithDbId) {
            this.cert = certWithDbId.getEncodedCert();
            this.certId = certWithDbId.getCertId();
        }

        public byte[] getCert() {
            return this.cert;
        }

        public void setCert(byte[] cert) {
            this.cert = cert;
        }

        public Long getCertId() {
            return this.certId;
        }

        public void setCertId(Long certId) {
            this.certId = certId;
        }

        public CertWithDbId toCertWithDbId() throws CertificateException {
            X509Certificate certObj = X509Util.parseCert((byte[])this.cert);
            CertWithDbId ret = new CertWithDbId(certObj);
            ret.setCertId(this.certId);
            return ret;
        }
    }
}

