/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.util.StringUtil;

public class PermissionConstants {
    private static final Map<Integer, String> codeTextMap = new HashMap<Integer, String>();
    private static final Map<String, Integer> textCodeMap = new HashMap<String, Integer>();
    private static final List<Integer> permissions;
    public static final int ENROLL_CERT = 1;
    public static final int REVOKE_CERT = 2;
    public static final int UNREVOKE_CERT = 4;
    public static final int REMOVE_CERT = 8;
    public static final int KEY_UPDATE = 16;
    public static final int GEN_CRL = 32;
    public static final int GET_CRL = 64;
    public static final int ENROLL_CROSS = 128;
    public static final int GEN_KEYPAIR = 256;
    public static final int ALL = 511;

    private PermissionConstants() {
    }

    public static boolean contains(int permissionA, int permissionB) {
        return (permissionA & permissionB) == permissionB;
    }

    public static Integer getPermissionForText(String text) {
        if (text == null) {
            return null;
        }
        if ("all".equalsIgnoreCase(text)) {
            return 511;
        }
        if (StringUtil.isNumber((String)text)) {
            return Integer.parseInt(text);
        }
        return textCodeMap.get(text.toLowerCase());
    }

    public static String getTextForCode(int code) {
        String text = codeTextMap.get(code);
        return text == null ? Integer.toString(code) : text;
    }

    public static List<Integer> getPermissions() {
        return permissions;
    }

    public static String permissionToString(int permission) {
        StringBuilder sb = new StringBuilder();
        for (Integer code : codeTextMap.keySet()) {
            if ((permission & code) == 0) continue;
            sb.append(codeTextMap.get(code)).append("|");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<String> permissionToStringSet(int permission) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (Integer code : codeTextMap.keySet()) {
            if ((permission & code) == 0) continue;
            list.add(codeTextMap.get(code));
        }
        Collections.sort(list);
        return list;
    }

    static {
        codeTextMap.put(1, "enroll_cert");
        codeTextMap.put(2, "revoke_cert");
        codeTextMap.put(4, "unrevoke_cert");
        codeTextMap.put(8, "remove_cert");
        codeTextMap.put(16, "key_update");
        codeTextMap.put(32, "gen_crl");
        codeTextMap.put(64, "get_crl");
        codeTextMap.put(128, "enroll_cross");
        codeTextMap.put(256, "gen_keypair");
        for (Integer code : codeTextMap.keySet()) {
            textCodeMap.put(codeTextMap.get(code), code);
        }
        ArrayList<Integer> tmpPermissions = new ArrayList<Integer>(codeTextMap.keySet());
        Collections.sort(tmpPermissions);
        permissions = Collections.unmodifiableList(tmpPermissions);
    }
}

