/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;

public class CrlControl {
    public static final String KEY_EYTENSIONS = "extensions";
    public static final String KEY_EXPIRED_CERTS_INCLUDED = "expiredcerts.included";
    public static final String KEY_XIPKI_CERTSET = "xipki.certset";
    public static final String KEY_XIPKI_CERTSET_CERTS = "xipki.certset.certs";
    public static final String KEY_FULLCRL_INTERVALS = "fullcrl.intervals";
    public static final String KEY_DELTACRL_INTERVALS = "deltacrl.intervals";
    public static final String KEY_OVERLAP_MINUTES = "overlap.minutes";
    public static final String KEY_INTERVAL_TIME = "interval.time";
    public static final String KEY_FULLCRL_EXTENDED_NEXTUPDATE = "fullcrl.extended.nextupdate";
    public static final String KEY_ONLY_CONTAINS_USERCERTS = "user.certs.only";
    public static final String KEY_ONLY_CONTAINS_CACERTS = "ca.certs.only";
    public static final String KEY_EXCLUDE_REASON = "exclude.reason";
    public static final String KEY_INVALIDITY_DATE = "invalidity.date";
    private boolean xipkiCertsetIncluded;
    private boolean xipkiCertsetCertIncluded = true;
    private boolean includeExpiredCerts;
    private int fullCrlIntervals = 1;
    private int deltaCrlIntervals;
    private int overlapMinutes = 360;
    private boolean extendedNextUpdate;
    private HourMinute intervalDayTime;
    private boolean onlyContainsUserCerts;
    private boolean onlyContainsCaCerts;
    private boolean excludeReason;
    private TripleState invalidityDateMode = TripleState.optional;
    private final Set<String> extensionOids;

    public CrlControl(String conf) throws InvalidConfException {
        ConfPairs props;
        try {
            props = new ConfPairs(conf);
        }
        catch (RuntimeException ex) {
            throw new InvalidConfException(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
        String str = props.value(KEY_INVALIDITY_DATE);
        if (str != null) {
            this.invalidityDateMode = TripleState.valueOf((String)str);
        }
        this.includeExpiredCerts = CrlControl.getBoolean(props, KEY_EXPIRED_CERTS_INCLUDED, false);
        this.xipkiCertsetIncluded = CrlControl.getBoolean(props, KEY_XIPKI_CERTSET, false);
        this.xipkiCertsetCertIncluded = CrlControl.getBoolean(props, KEY_XIPKI_CERTSET_CERTS, true);
        str = props.value(KEY_EYTENSIONS);
        if (str == null) {
            this.extensionOids = Collections.emptySet();
        } else {
            Set oids = StringUtil.splitAsSet((String)str, (String)", ");
            for (String oid : oids) {
                try {
                    new ASN1ObjectIdentifier(oid);
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidConfException(oid + " is not a valid OID");
                }
            }
            this.extensionOids = oids;
        }
        this.onlyContainsCaCerts = CrlControl.getBoolean(props, KEY_ONLY_CONTAINS_CACERTS, false);
        this.onlyContainsUserCerts = CrlControl.getBoolean(props, KEY_ONLY_CONTAINS_USERCERTS, false);
        this.excludeReason = CrlControl.getBoolean(props, KEY_EXCLUDE_REASON, false);
        this.fullCrlIntervals = CrlControl.getInteger(props, KEY_FULLCRL_INTERVALS, 1);
        this.deltaCrlIntervals = CrlControl.getInteger(props, KEY_DELTACRL_INTERVALS, 0);
        this.extendedNextUpdate = CrlControl.getBoolean(props, KEY_FULLCRL_EXTENDED_NEXTUPDATE, false);
        this.overlapMinutes = CrlControl.getInteger(props, KEY_OVERLAP_MINUTES, 60);
        if (this.overlapMinutes < 60) {
            this.overlapMinutes = 60;
        }
        if ((str = props.value(KEY_INTERVAL_TIME)) == null) {
            this.intervalDayTime = new HourMinute(1, 0);
        } else {
            List tokens = StringUtil.split((String)str.trim(), (String)":");
            if (tokens.size() != 2) {
                throw new InvalidConfException("invalid interval.time: '" + str + "'");
            }
            try {
                int hour = Integer.parseInt((String)tokens.get(0));
                int minute = Integer.parseInt((String)tokens.get(1));
                this.intervalDayTime = new HourMinute(hour, minute);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidConfException("invalid interval.time: '" + str + "'");
            }
        }
        this.validate();
    }

    public String getConf() {
        ConfPairs pairs = new ConfPairs();
        pairs.putPair(KEY_EXPIRED_CERTS_INCLUDED, Boolean.toString(this.includeExpiredCerts));
        pairs.putPair(KEY_XIPKI_CERTSET, Boolean.toString(this.xipkiCertsetIncluded));
        pairs.putPair(KEY_XIPKI_CERTSET_CERTS, Boolean.toString(this.xipkiCertsetCertIncluded));
        pairs.putPair(KEY_XIPKI_CERTSET, Boolean.toString(this.xipkiCertsetIncluded));
        pairs.putPair(KEY_ONLY_CONTAINS_CACERTS, Boolean.toString(this.onlyContainsCaCerts));
        pairs.putPair(KEY_ONLY_CONTAINS_USERCERTS, Boolean.toString(this.onlyContainsUserCerts));
        pairs.putPair(KEY_EXCLUDE_REASON, Boolean.toString(this.excludeReason));
        pairs.putPair(KEY_INVALIDITY_DATE, this.invalidityDateMode.name());
        pairs.putPair(KEY_FULLCRL_INTERVALS, Integer.toString(this.fullCrlIntervals));
        pairs.putPair(KEY_FULLCRL_EXTENDED_NEXTUPDATE, Boolean.toString(this.extendedNextUpdate));
        pairs.putPair(KEY_DELTACRL_INTERVALS, Integer.toString(this.deltaCrlIntervals));
        pairs.putPair(KEY_INTERVAL_TIME, this.intervalDayTime.toString());
        if (CollectionUtil.isNotEmpty(this.extensionOids)) {
            StringBuilder extensionsSb = new StringBuilder(200);
            for (String oid : this.extensionOids) {
                extensionsSb.append(oid).append(",");
            }
            extensionsSb.deleteCharAt(extensionsSb.length() - 1);
            pairs.putPair(KEY_EYTENSIONS, extensionsSb.toString());
        }
        return pairs.getEncoded();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder(this.xipkiCertsetIncluded ? "included" : "not included");
        if (this.xipkiCertsetIncluded) {
            sb.append("\t\tinclude cert: ").append(this.xipkiCertsetCertIncluded);
        }
        String xipkiCertSetStr = sb.toString();
        sb = new StringBuilder("generate CRL at ").append(this.intervalDayTime);
        String intervalStr = sb.toString();
        return StringUtil.concatObjects((Object)"  include expired certificates: ", (Object[])new Object[]{this.includeExpiredCerts, "\n  full CRL intervals: ", this.fullCrlIntervals, "\n  delta CRL intervals: ", this.deltaCrlIntervals, "\n  overlap: ", this.overlapMinutes, " minutes", "\n  use extended nextUpdate: ", this.extendedNextUpdate, "\n  only user certificates: ", this.onlyContainsUserCerts, "\n  only CA certificates: ", this.onlyContainsCaCerts, "\n  exclude reason: ", this.excludeReason, "\n  invalidity date mode: ", this.invalidityDateMode, "\n  interval: ", intervalStr, "\n  XiPKI CertSet: ", xipkiCertSetStr, verbose ? "\n  encoded: " : "", verbose ? this.getConf() : ""});
    }

    public boolean isXipkiCertsetIncluded() {
        return this.xipkiCertsetIncluded;
    }

    public boolean isXipkiCertsetCertIncluded() {
        return this.xipkiCertsetCertIncluded;
    }

    public boolean isIncludeExpiredCerts() {
        return this.includeExpiredCerts;
    }

    public int getFullCrlIntervals() {
        return this.fullCrlIntervals;
    }

    public int getDeltaCrlIntervals() {
        return this.deltaCrlIntervals;
    }

    public int getOverlapMinutes() {
        return this.overlapMinutes;
    }

    public HourMinute getIntervalDayTime() {
        return this.intervalDayTime;
    }

    public Set<String> getExtensionOids() {
        return this.extensionOids;
    }

    public boolean isExtendedNextUpdate() {
        return this.extendedNextUpdate;
    }

    public boolean isOnlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public boolean isOnlyContainsCaCerts() {
        return this.onlyContainsCaCerts;
    }

    public boolean isExcludeReason() {
        return this.excludeReason;
    }

    public TripleState getInvalidityDateMode() {
        return this.invalidityDateMode;
    }

    public final void validate() throws InvalidConfException {
        if (this.onlyContainsCaCerts && this.onlyContainsUserCerts) {
            throw new InvalidConfException("onlyContainsCACerts and onlyContainsUserCerts can not be both true");
        }
        if (this.fullCrlIntervals < this.deltaCrlIntervals) {
            throw new InvalidConfException("fullCRLIntervals may not be less than deltaCRLIntervals " + this.fullCrlIntervals + " < " + this.deltaCrlIntervals);
        }
        if (this.fullCrlIntervals < 1) {
            throw new InvalidConfException("fullCRLIntervals may not be less than 1: " + this.fullCrlIntervals);
        }
        if (this.deltaCrlIntervals < 0) {
            throw new InvalidConfException("deltaCRLIntervals may not be less than 0: " + this.deltaCrlIntervals);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrlControl)) {
            return false;
        }
        CrlControl obj2 = (CrlControl)obj;
        if (this.deltaCrlIntervals != obj2.deltaCrlIntervals || this.xipkiCertsetIncluded != obj2.xipkiCertsetIncluded || this.xipkiCertsetCertIncluded != obj2.xipkiCertsetCertIncluded || this.extendedNextUpdate != obj2.extendedNextUpdate || this.fullCrlIntervals != obj2.fullCrlIntervals || this.includeExpiredCerts != obj2.includeExpiredCerts || this.onlyContainsCaCerts != obj2.onlyContainsCaCerts || this.onlyContainsUserCerts != obj2.onlyContainsUserCerts) {
            return false;
        }
        if (this.extensionOids == null ? obj2.extensionOids != null : !this.extensionOids.equals(obj2.extensionOids)) {
            return false;
        }
        return this.intervalDayTime.equals(obj2.intervalDayTime);
    }

    private static int getInteger(ConfPairs props, String propKey, int dfltValue) throws InvalidConfException {
        String str = props.value(propKey);
        if (str != null) {
            try {
                return Integer.parseInt(str.trim());
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfException(propKey + " does not have numeric value: " + str);
            }
        }
        return dfltValue;
    }

    private static boolean getBoolean(ConfPairs props, String propKey, boolean dfltValue) throws InvalidConfException {
        String str = props.value(propKey);
        if (str != null) {
            if ("true".equalsIgnoreCase(str = str.trim())) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            throw new InvalidConfException(propKey + " does not have boolean value: " + str);
        }
        return dfltValue;
    }

    public static class HourMinute {
        private final int hour;
        private final int minute;

        public HourMinute(int hour, int minute) {
            this.hour = Args.range((int)hour, (String)"hour", (int)0, (int)23);
            this.minute = Args.range((int)minute, (String)"minute", (int)0, (int)59);
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public String toString() {
            return StringUtil.concatObjectsCap((int)100, (Object)(this.hour < 10 ? "0" : ""), (Object[])new Object[]{this.hour, ":", this.minute < 10 ? "0" : "", this.minute});
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HourMinute)) {
                return false;
            }
            HourMinute hm = (HourMinute)obj;
            return this.hour == hm.hour && this.minute == hm.minute;
        }
    }
}

