/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;

public class CaConfType {

    public static class User
    extends ValidatableConf {
        private String name;
        private Boolean active;
        private String password;
        private String hashedPassword;

        public boolean isActive() {
            return this.active == null ? true : this.active;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setActive(Boolean active) {
            this.active = active;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getHashedPassword() {
            return this.hashedPassword;
        }

        public void setHashedPassword(String hashedPassword) {
            this.hashedPassword = hashedPassword;
        }

        public void validate() throws InvalidConfException {
            User.notEmpty((String)this.name, (String)"name");
            this.exactOne(this.password, "password", this.hashedPassword, "hashedPassword");
        }
    }

    public static class Signer
    extends ValidatableConf {
        private String type;
        private FileOrValue conf;
        private FileOrBinary cert;
        private String name;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            Signer.notEmpty((String)this.name, (String)"name");
            Signer.notEmpty((String)this.type, (String)"type");
            Signer.notNull((Object)this.conf, (String)"conf");
            Signer.validate((ValidatableConf)this.conf);
            Signer.validate((ValidatableConf)this.cert);
        }
    }

    public static class Requestor
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;
        private FileOrBinary binaryConf;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public FileOrBinary getBinaryConf() {
            return this.binaryConf;
        }

        public void setBinaryConf(FileOrBinary binaryConf) {
            this.binaryConf = binaryConf;
        }

        public void validate() throws InvalidConfException {
            Requestor.notEmpty((String)this.name, (String)"name");
            Requestor.notEmpty((String)this.type, (String)"type");
            this.exactOne(this.conf, "conf", this.binaryConf, "binaryConf");
            Requestor.validate((ValidatableConf)this.conf);
            Requestor.validate((ValidatableConf)this.binaryConf);
        }
    }

    public static class NameTypeConf
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public void validate() throws InvalidConfException {
            NameTypeConf.notEmpty((String)this.name, (String)"name");
            NameTypeConf.notEmpty((String)this.type, (String)"type");
            NameTypeConf.validate((ValidatableConf)this.conf);
        }
    }

    public static class GenSelfIssued
    extends ValidatableConf {
        private FileOrBinary csr;
        private String profile;
        private String serialNumber;
        private String certOutform;

        public FileOrBinary getCsr() {
            return this.csr;
        }

        public void setCsr(FileOrBinary csr) {
            this.csr = csr;
        }

        public String getProfile() {
            return this.profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getCertOutform() {
            return this.certOutform;
        }

        public void setCertOutform(String certOutform) {
            this.certOutform = certOutform;
        }

        public void validate() throws InvalidConfException {
            GenSelfIssued.notNull((Object)this.csr, (String)"csr");
            GenSelfIssued.validate((ValidatableConf)this.csr);
        }
    }

    public static class CaUris
    extends ValidatableConf {
        private List<String> cacertUris;
        private List<String> crlUris;
        private List<String> deltacrlUris;
        private List<String> ocspUris;

        public List<String> getCacertUris() {
            if (this.cacertUris == null) {
                this.cacertUris = new LinkedList<String>();
            }
            return this.cacertUris;
        }

        public void setCacertUris(List<String> cacertUris) {
            this.cacertUris = cacertUris;
        }

        public List<String> getCrlUris() {
            if (this.crlUris == null) {
                this.crlUris = new LinkedList<String>();
            }
            return this.crlUris;
        }

        public void setCrlUris(List<String> crlUris) {
            this.crlUris = crlUris;
        }

        public List<String> getDeltacrlUris() {
            if (this.deltacrlUris == null) {
                this.deltacrlUris = new LinkedList<String>();
            }
            return this.deltacrlUris;
        }

        public void setDeltacrlUris(List<String> deltacrlUris) {
            this.deltacrlUris = deltacrlUris;
        }

        public List<String> getOcspUris() {
            if (this.ocspUris == null) {
                this.ocspUris = new LinkedList<String>();
            }
            return this.ocspUris;
        }

        public void setOcspUris(List<String> ocspUris) {
            this.ocspUris = ocspUris;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class Ca
    extends ValidatableConf {
        private String name;
        private CaInfo caInfo;
        private List<String> aliases;
        private List<String> profiles;
        private List<CaHasRequestor> requestors;
        private List<CaHasUser> users;
        private List<String> publishers;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CaInfo getCaInfo() {
            return this.caInfo;
        }

        public void setCaInfo(CaInfo caInfo) {
            this.caInfo = caInfo;
        }

        public List<String> getAliases() {
            if (this.aliases == null) {
                this.aliases = new LinkedList<String>();
            }
            return this.aliases;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        public List<String> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<String>();
            }
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = profiles;
        }

        public List<CaHasRequestor> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<CaHasRequestor>();
            }
            return this.requestors;
        }

        public void setRequestors(List<CaHasRequestor> requestors) {
            this.requestors = requestors;
        }

        public List<CaHasUser> getUsers() {
            if (this.users == null) {
                this.users = new LinkedList<CaHasUser>();
            }
            return this.users;
        }

        public void setUsers(List<CaHasUser> users) {
            this.users = users;
        }

        public List<String> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<String>();
            }
            return this.publishers;
        }

        public void setPublishers(List<String> publishers) {
            this.publishers = publishers;
        }

        public void validate() throws InvalidConfException {
            Ca.notEmpty((String)this.name, (String)"name");
            Ca.validate((ValidatableConf)this.caInfo);
            Ca.validate(this.requestors);
            Ca.validate(this.users);
        }
    }

    public static class CaInfo
    extends ValidatableConf {
        private FileOrBinary cert;
        private List<FileOrBinary> certchain;
        private Integer expirationPeriod;
        private Map<String, String> extraControl;
        private GenSelfIssued genSelfIssued;
        private Integer keepExpiredCertDays;
        private List<String> permissions;
        private String maxValidity;
        private Map<String, Object> cmpControl;
        private Map<String, Object> crlControl;
        private Map<String, Object> scepControl;
        private Map<String, Object> ctlogControl;
        private Map<String, Object> revokeSuspendedControl;
        private FileOrValue dhpocControl;
        private String cmpResponderName;
        private String scepResponderName;
        private String crlSignerName;
        private Set<String> protocolSupport;
        private boolean saveReq;
        private String signerType;
        private FileOrValue signerConf;
        private String status;
        private String validityMode;
        private long nextCrlNo;
        private Integer numCrls;
        private int snSize;
        private CaUris caUris;

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public List<FileOrBinary> getCertchain() {
            return this.certchain;
        }

        public void setCertchain(List<FileOrBinary> certchain) {
            this.certchain = certchain;
        }

        public Integer getExpirationPeriod() {
            return this.expirationPeriod;
        }

        public void setExpirationPeriod(Integer expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        public Map<String, String> getExtraControl() {
            return this.extraControl;
        }

        public void setExtraControl(Map<String, String> extraControl) {
            this.extraControl = extraControl;
        }

        public GenSelfIssued getGenSelfIssued() {
            return this.genSelfIssued;
        }

        public void setGenSelfIssued(GenSelfIssued genSelfIssued) {
            this.genSelfIssued = genSelfIssued;
        }

        public Integer getKeepExpiredCertDays() {
            return this.keepExpiredCertDays;
        }

        public void setKeepExpiredCertDays(Integer keepExpiredCertDays) {
            this.keepExpiredCertDays = keepExpiredCertDays;
        }

        public List<String> getPermissions() {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            return this.permissions;
        }

        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        public String getMaxValidity() {
            return this.maxValidity;
        }

        public void setMaxValidity(String maxValidity) {
            this.maxValidity = maxValidity;
        }

        public Map<String, Object> getCmpControl() {
            return this.cmpControl;
        }

        public void setCmpControl(Map<String, Object> cmpControl) {
            this.cmpControl = cmpControl;
        }

        public Map<String, Object> getCrlControl() {
            return this.crlControl;
        }

        public void setCrlControl(Map<String, Object> crlControl) {
            this.crlControl = crlControl;
        }

        public Map<String, Object> getScepControl() {
            return this.scepControl;
        }

        public void setScepControl(Map<String, Object> scepControl) {
            this.scepControl = scepControl;
        }

        public Map<String, Object> getCtlogControl() {
            return this.ctlogControl;
        }

        public void setCtlogControl(Map<String, Object> ctlogControl) {
            this.ctlogControl = ctlogControl;
        }

        public Map<String, Object> getRevokeSuspendedControl() {
            return this.revokeSuspendedControl;
        }

        public void setRevokeSuspendedControl(Map<String, Object> revokeSuspendedControl) {
            this.revokeSuspendedControl = revokeSuspendedControl;
        }

        public FileOrValue getDhpocControl() {
            return this.dhpocControl;
        }

        public void setDhpocControl(FileOrValue dhpocControl) {
            this.dhpocControl = dhpocControl;
        }

        public String getCmpResponderName() {
            return this.cmpResponderName;
        }

        public void setCmpResponderName(String cmpResponderName) {
            this.cmpResponderName = cmpResponderName;
        }

        public String getScepResponderName() {
            return this.scepResponderName;
        }

        public void setScepResponderName(String scepResponderName) {
            this.scepResponderName = scepResponderName;
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName;
        }

        public Set<String> getProtocolSupport() {
            return this.protocolSupport;
        }

        public void setProtocolSupport(Set<String> protocolSupport) {
            this.protocolSupport = protocolSupport;
        }

        public boolean isSaveReq() {
            return this.saveReq;
        }

        public void setSaveReq(boolean saveReq) {
            this.saveReq = saveReq;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setSignerType(String signerType) {
            this.signerType = signerType;
        }

        public FileOrValue getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(FileOrValue signerConf) {
            this.signerConf = signerConf;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(String validityMode) {
            this.validityMode = validityMode;
        }

        public long getNextCrlNo() {
            return this.nextCrlNo;
        }

        public void setNextCrlNo(long nextCrlNo) {
            this.nextCrlNo = nextCrlNo;
        }

        public Integer getNumCrls() {
            return this.numCrls;
        }

        public void setNumCrls(Integer numCrls) {
            this.numCrls = numCrls;
        }

        public int getSnSize() {
            return this.snSize;
        }

        public void setSnSize(int snSize) {
            if (snSize > 20) {
                snSize = 20;
            } else if (snSize < 9) {
                snSize = 9;
            } else {
                this.snSize = snSize;
            }
        }

        public CaUris getCaUris() {
            return this.caUris;
        }

        public void setCaUris(CaUris caUris) {
            this.caUris = caUris;
        }

        public void validate() throws InvalidConfException {
            if (this.genSelfIssued != null && this.cert != null) {
                throw new InvalidConfException("cert and genSelfIssued may not be both non-null");
            }
            CaInfo.validate((ValidatableConf)this.genSelfIssued);
            CaInfo.validate((ValidatableConf)this.cert);
            CaInfo.notEmpty((String)this.maxValidity, (String)"maxValidity");
            CaInfo.notEmpty(this.protocolSupport, (String)"protocolSupport");
            CaInfo.notEmpty((String)this.signerType, (String)"signerType");
            CaInfo.notNull((Object)this.signerConf, (String)"signerConf");
            CaInfo.validate((ValidatableConf)this.signerConf);
            CaInfo.notEmpty((String)this.status, (String)this.status);
            CaInfo.validate((ValidatableConf)this.caUris);
        }
    }

    public static class CaHasUser
    extends ValidatableConf {
        private String userName;
        private List<String> permissions;
        private List<String> profiles;

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public List<String> getPermissions() {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            return this.permissions;
        }

        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        public List<String> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<String>();
            }
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
            CaHasUser.notEmpty((String)this.userName, (String)"userName");
            CaHasUser.notEmpty(this.permissions, (String)"permissions");
        }
    }

    public static class CaHasRequestor
    extends ValidatableConf {
        private String requestorName;
        private boolean ra;
        private List<String> permissions;
        private List<String> profiles;

        public String getRequestorName() {
            return this.requestorName;
        }

        public void setRequestorName(String requestorName) {
            this.requestorName = requestorName;
        }

        public boolean isRa() {
            return this.ra;
        }

        public void setRa(boolean ra) {
            this.ra = ra;
        }

        public List<String> getPermissions() {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            return this.permissions;
        }

        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        public List<String> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<String>();
            }
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
            CaHasRequestor.notEmpty((String)this.requestorName, (String)"requestorName");
            CaHasRequestor.notEmpty(this.permissions, (String)"permissions");
        }
    }

    public static class CaSystem
    extends ValidatableConf {
        private String basedir;
        private Map<String, String> properties;
        private List<Signer> signers;
        private List<Requestor> requestors;
        private List<NameTypeConf> publishers;
        private List<NameTypeConf> profiles;
        private List<Ca> cas;
        private List<User> users;

        public String getBasedir() {
            return this.basedir;
        }

        public void setBasedir(String basedir) {
            this.basedir = basedir;
        }

        public Map<String, String> getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public List<Signer> getSigners() {
            if (this.signers == null) {
                this.signers = new LinkedList<Signer>();
            }
            return this.signers;
        }

        public void setSigners(List<Signer> signers) {
            this.signers = signers;
        }

        public List<Requestor> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<Requestor>();
            }
            return this.requestors;
        }

        public void setRequestors(List<Requestor> requestors) {
            this.requestors = requestors;
        }

        public List<NameTypeConf> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<NameTypeConf>();
            }
            return this.publishers;
        }

        public void setPublishers(List<NameTypeConf> publishers) {
            this.publishers = publishers;
        }

        public List<NameTypeConf> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<NameTypeConf>();
            }
            return this.profiles;
        }

        public void setProfiles(List<NameTypeConf> profiles) {
            this.profiles = profiles;
        }

        public List<Ca> getCas() {
            if (this.cas == null) {
                this.cas = new LinkedList<Ca>();
            }
            return this.cas;
        }

        public void setCas(List<Ca> cas) {
            this.cas = cas;
        }

        public List<User> getUsers() {
            if (this.users == null) {
                this.users = new LinkedList<User>();
            }
            return this.users;
        }

        public void setUsers(List<User> users) {
            this.users = users;
        }

        public void validate() throws InvalidConfException {
            CaSystem.validate(this.signers);
            CaSystem.validate(this.requestors);
            CaSystem.validate(this.publishers);
            CaSystem.validate(this.profiles);
            CaSystem.validate(this.cas);
            CaSystem.validate(this.users);
        }
    }
}

