/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.DomainValidator;
import org.xipki.security.ObjectIdentifiers;

public abstract class ExtensionSpec {
    private static final Set<String> specialUseDomains = new HashSet<String>(Arrays.asList(".in-addr.arpa", ".ip6.arpa", "home.arpa", "example", "example.com", "example.net", "example.org", "invalid", "local", "localhost", "onion", "test"));
    private static final Map<Certprofile.CertLevel, ExtensionSpec> rfc5280Instances = new HashMap<Certprofile.CertLevel, ExtensionSpec>();
    private static final Map<Certprofile.CertLevel, ExtensionSpec> browserForumInstances = new HashMap<Certprofile.CertLevel, ExtensionSpec>();

    public abstract Set<ASN1ObjectIdentifier> getRequiredExtensions();

    public abstract boolean isNotPermitted(ASN1ObjectIdentifier var1);

    public abstract boolean isCriticalOnly(ASN1ObjectIdentifier var1);

    public abstract boolean isNonCriticalOnly(ASN1ObjectIdentifier var1);

    public abstract boolean isNonRequest(ASN1ObjectIdentifier var1);

    public static boolean isValidPublicDomain(String domain) {
        if (!DomainValidator.getInstance().isValid(domain)) {
            return false;
        }
        String loDomain = domain.toLowerCase();
        for (String m : specialUseDomains) {
            if (!loDomain.endsWith(m)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPublicIPv4Address(byte[] ipv4Address) {
        if (ipv4Address == null || ipv4Address.length != 4) {
            return false;
        }
        int byte0 = 0xFF & ipv4Address[0];
        int byte1 = 0xFF & ipv4Address[1];
        if (byte0 == 10) {
            return false;
        }
        if (byte0 == 172) {
            return byte1 < 16 || byte1 > 31;
        }
        if (byte0 == 192) {
            return byte1 != 168;
        }
        return true;
    }

    public static ExtensionSpec getExtensionSpec(Certprofile.CertDomain domain, Certprofile.CertLevel certLevel) {
        return domain == Certprofile.CertDomain.CABForumBR ? browserForumInstances.get((Object)certLevel) : rfc5280Instances.get((Object)certLevel);
    }

    static {
        rfc5280Instances.put(Certprofile.CertLevel.RootCA, new Rfc5280RootCA());
        rfc5280Instances.put(Certprofile.CertLevel.SubCA, new Rfc5280SubCA());
        rfc5280Instances.put(Certprofile.CertLevel.CROSS, new Rfc5280SubCA());
        rfc5280Instances.put(Certprofile.CertLevel.EndEntity, new Rfc5280EndEntity());
        browserForumInstances.put(Certprofile.CertLevel.RootCA, new BrowserForumBRRootCA());
        browserForumInstances.put(Certprofile.CertLevel.SubCA, new BrowserForumBRSubCA());
        browserForumInstances.put(Certprofile.CertLevel.CROSS, new BrowserForumBRSubCA());
        browserForumInstances.put(Certprofile.CertLevel.EndEntity, new BrowserForumBREndEntity());
    }

    private static class BrowserForumBREndEntity
    extends Rfc5280EndEntity {
        private static final Set<ASN1ObjectIdentifier> REQUIRED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.certificatePolicies, Extension.authorityInfoAccess, Extension.extendedKeyUsage, Extension.subjectAlternativeName)));
        private static final Set<ASN1ObjectIdentifier> NON_PERMITTED_EXTENSIONS = Collections.emptySet();
        private static final Set<ASN1ObjectIdentifier> CRITICAL_ONLY_EXTENSIONS = Collections.emptySet();
        private static final Set<ASN1ObjectIdentifier> NON_CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.certificatePolicies, Extension.cRLDistributionPoints, Extension.authorityInfoAccess)));
        private final Set<ASN1ObjectIdentifier> requiredExtensions;

        private BrowserForumBREndEntity() {
            HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
            set.addAll(REQUIRED_EXTENSIONS);
            set.addAll(super.getRequiredExtensions());
            this.requiredExtensions = Collections.unmodifiableSet(set);
        }

        @Override
        public Set<ASN1ObjectIdentifier> getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public boolean isNotPermitted(ASN1ObjectIdentifier type) {
            return NON_PERMITTED_EXTENSIONS.contains(type) || super.isNotPermitted(type);
        }

        @Override
        public boolean isCriticalOnly(ASN1ObjectIdentifier type) {
            return CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isCriticalOnly(type);
        }

        @Override
        public boolean isNonCriticalOnly(ASN1ObjectIdentifier type) {
            return NON_CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isNonCriticalOnly(type);
        }
    }

    private static class BrowserForumBRSubCA
    extends Rfc5280SubCA {
        private static final Set<ASN1ObjectIdentifier> REQUIRED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.certificatePolicies, Extension.cRLDistributionPoints, Extension.authorityInfoAccess, Extension.basicConstraints, Extension.keyUsage)));
        private static final Set<ASN1ObjectIdentifier> NON_PERMITTED_EXTENSIONS = Collections.emptySet();
        private static final Set<ASN1ObjectIdentifier> CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.basicConstraints, Extension.keyUsage, Extension.nameConstraints)));
        private static final Set<ASN1ObjectIdentifier> NON_CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.certificatePolicies, Extension.cRLDistributionPoints, Extension.authorityInfoAccess, Extension.extendedKeyUsage)));
        private final Set<ASN1ObjectIdentifier> requiredExtensions;

        private BrowserForumBRSubCA() {
            HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
            set.addAll(REQUIRED_EXTENSIONS);
            set.addAll(super.getRequiredExtensions());
            this.requiredExtensions = Collections.unmodifiableSet(set);
        }

        @Override
        public Set<ASN1ObjectIdentifier> getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public boolean isNotPermitted(ASN1ObjectIdentifier type) {
            return NON_PERMITTED_EXTENSIONS.contains(type) || super.isNotPermitted(type);
        }

        @Override
        public boolean isCriticalOnly(ASN1ObjectIdentifier type) {
            return CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isCriticalOnly(type);
        }

        @Override
        public boolean isNonCriticalOnly(ASN1ObjectIdentifier type) {
            return NON_CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isNonCriticalOnly(type);
        }
    }

    private static class BrowserForumBRRootCA
    extends Rfc5280RootCA {
        private BrowserForumBRRootCA() {
        }
    }

    private static class Rfc5280EndEntity
    extends Rfc5280 {
        private static final Set<ASN1ObjectIdentifier> REQUIRED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Collections.singletonList(Extension.subjectKeyIdentifier)));
        private static final Set<ASN1ObjectIdentifier> NON_PERMITTED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.policyMappings, Extension.nameConstraints, Extension.policyConstraints, Extension.inhibitAnyPolicy)));
        private static final Set<ASN1ObjectIdentifier> CRITICAL_ONLY_EXTENSIONS = Collections.emptySet();
        private static final Set<ASN1ObjectIdentifier> NON_CRITICAL_ONLY_EXTENSIONS = Collections.emptySet();

        private Rfc5280EndEntity() {
        }

        @Override
        public Set<ASN1ObjectIdentifier> getRequiredExtensions() {
            return REQUIRED_EXTENSIONS;
        }

        @Override
        public boolean isNotPermitted(ASN1ObjectIdentifier type) {
            return NON_PERMITTED_EXTENSIONS.contains(type) || super.isNotPermitted(type);
        }

        @Override
        public boolean isCriticalOnly(ASN1ObjectIdentifier type) {
            return CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isCriticalOnly(type);
        }

        @Override
        public boolean isNonCriticalOnly(ASN1ObjectIdentifier type) {
            return NON_CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isNonCriticalOnly(type);
        }
    }

    private static class Rfc5280SubCA
    extends Rfc5280 {
        private static final Set<ASN1ObjectIdentifier> REQUIRED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.basicConstraints, Extension.subjectKeyIdentifier, Extension.keyUsage)));
        private static final Set<ASN1ObjectIdentifier> NON_PERMITTED_EXTENSIONS = Collections.emptySet();
        private static final Set<ASN1ObjectIdentifier> CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.basicConstraints, Extension.keyUsage, Extension.nameConstraints)));
        private static final Set<ASN1ObjectIdentifier> NON_CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.certificatePolicies, Extension.cRLDistributionPoints, Extension.authorityInfoAccess, Extension.extendedKeyUsage)));
        private final Set<ASN1ObjectIdentifier> requiredExtensions;

        private Rfc5280SubCA() {
            HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
            set.addAll(REQUIRED_EXTENSIONS);
            set.addAll(super.getRequiredExtensions());
            this.requiredExtensions = Collections.unmodifiableSet(set);
        }

        @Override
        public Set<ASN1ObjectIdentifier> getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public boolean isNotPermitted(ASN1ObjectIdentifier type) {
            return NON_PERMITTED_EXTENSIONS.contains(type) || super.isNotPermitted(type);
        }

        @Override
        public boolean isCriticalOnly(ASN1ObjectIdentifier type) {
            return CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isCriticalOnly(type);
        }

        @Override
        public boolean isNonCriticalOnly(ASN1ObjectIdentifier type) {
            return NON_CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isNonCriticalOnly(type);
        }
    }

    private static class Rfc5280RootCA
    extends Rfc5280 {
        private static final Set<ASN1ObjectIdentifier> REQUIRED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.basicConstraints, Extension.subjectKeyIdentifier, Extension.keyUsage)));
        private static final Set<ASN1ObjectIdentifier> NON_PERMITTED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.certificatePolicies, Extension.extendedKeyUsage, Extension.authorityKeyIdentifier)));
        private static final Set<ASN1ObjectIdentifier> CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.basicConstraints, Extension.keyUsage)));
        private static final Set<ASN1ObjectIdentifier> NON_CRITICAL_ONLY_EXTENSIONS = Collections.emptySet();
        private final Set<ASN1ObjectIdentifier> requiredExtensions;

        private Rfc5280RootCA() {
            HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
            set.addAll(REQUIRED_EXTENSIONS);
            set.addAll(super.getRequiredExtensions());
            this.requiredExtensions = Collections.unmodifiableSet(set);
        }

        @Override
        public Set<ASN1ObjectIdentifier> getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public boolean isNotPermitted(ASN1ObjectIdentifier type) {
            return NON_PERMITTED_EXTENSIONS.contains(type) || super.isNotPermitted(type);
        }

        @Override
        public boolean isCriticalOnly(ASN1ObjectIdentifier type) {
            return CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isCriticalOnly(type);
        }

        @Override
        public boolean isNonCriticalOnly(ASN1ObjectIdentifier type) {
            return NON_CRITICAL_ONLY_EXTENSIONS.contains(type) || super.isNonCriticalOnly(type);
        }
    }

    private static class Rfc5280
    extends ExtensionSpec {
        private static final Set<ASN1ObjectIdentifier> REQUIRED_EXTENSIONS = Collections.emptySet();
        private static final Set<ASN1ObjectIdentifier> CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.keyUsage, Extension.policyMappings, Extension.nameConstraints, Extension.policyConstraints, Extension.inhibitAnyPolicy, ObjectIdentifiers.Extn.id_pe_tlsfeature)));
        private static final Set<ASN1ObjectIdentifier> NON_CRITICAL_ONLY_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.authorityKeyIdentifier, Extension.subjectKeyIdentifier, Extension.issuerAlternativeName, Extension.subjectDirectoryAttributes, Extension.freshestCRL, Extension.authorityInfoAccess, Extension.subjectInfoAccess, ObjectIdentifiers.Extn.id_SCTs, ObjectIdentifiers.Extn.id_GMT_0015_ICRegistrationNumber, ObjectIdentifiers.Extn.id_GMT_0015_IdentityCode, ObjectIdentifiers.Extn.id_GMT_0015_InsuranceNumber, ObjectIdentifiers.Extn.id_GMT_0015_OrganizationCode, ObjectIdentifiers.Extn.id_GMT_0015_TaxationNumber)));
        private static final Set<ASN1ObjectIdentifier> NON_REQUEST_EXTENSIONS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(Extension.authorityKeyIdentifier, Extension.issuerAlternativeName, Extension.cRLDistributionPoints, Extension.freshestCRL, ObjectIdentifiers.Extn.id_SCTs, Extension.inhibitAnyPolicy)));

        private Rfc5280() {
        }

        @Override
        public Set<ASN1ObjectIdentifier> getRequiredExtensions() {
            return REQUIRED_EXTENSIONS;
        }

        @Override
        public boolean isCriticalOnly(ASN1ObjectIdentifier type) {
            return CRITICAL_ONLY_EXTENSIONS.contains(type);
        }

        @Override
        public boolean isNonCriticalOnly(ASN1ObjectIdentifier type) {
            return NON_CRITICAL_ONLY_EXTENSIONS.contains(type);
        }

        @Override
        public boolean isNonRequest(ASN1ObjectIdentifier type) {
            return NON_REQUEST_EXTENSIONS.contains(type);
        }

        @Override
        public boolean isNotPermitted(ASN1ObjectIdentifier type) {
            return false;
        }
    }
}

