/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.regex.Pattern;
import org.xipki.ca.api.profile.DomainValidator;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;

public abstract class TextVadidator {
    public static final TextVadidator COUNTRY = new RegexValidator("[A-Za-z]{2}");
    public static final TextVadidator NUMBER = new RegexValidator("[\\d]{1,}");
    public static final TextVadidator DATE_OF_BIRTH = new RegexValidator("^(19|20)\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])120000Z");
    public static final TextVadidator GENDER = new RegexValidator("M|m|F|f");
    public static final TextVadidator FQDN = new FQDNValidator();
    private static final LruCache<String, TextVadidator> cache = new LruCache(200);

    private TextVadidator() {
    }

    public abstract boolean isValid(String var1);

    public abstract String pattern();

    public static TextVadidator compile(String regex) {
        if (StringUtil.orEqualsIgnoreCase((String)regex, (String[])new String[]{":COUNTRY", "COUNTRY"})) {
            return COUNTRY;
        }
        if (StringUtil.orEqualsIgnoreCase((String)regex, (String[])new String[]{":DATE_OF_BIRTH", "DATE_OF_BIRTH"})) {
            return DATE_OF_BIRTH;
        }
        if (StringUtil.orEqualsIgnoreCase((String)regex, (String[])new String[]{":FQDN", "FQDN"})) {
            return FQDN;
        }
        if (StringUtil.orEqualsIgnoreCase((String)regex, (String[])new String[]{":GENDER", "GENDER"})) {
            return GENDER;
        }
        if (StringUtil.orEqualsIgnoreCase((String)regex, (String[])new String[]{":NUMBER", "NUMBER"})) {
            return NUMBER;
        }
        TextVadidator validator = (TextVadidator)cache.get((Object)regex);
        if (validator == null) {
            validator = new RegexValidator(regex);
            cache.put((Object)regex, (Object)validator);
        }
        return validator;
    }

    private static class FQDNValidator
    extends TextVadidator {
        private FQDNValidator() {
        }

        @Override
        public boolean isValid(String value) {
            return DomainValidator.getInstance().isValid(value);
        }

        @Override
        public String pattern() {
            return ":FQDN";
        }
    }

    private static class RegexValidator
    extends TextVadidator {
        private final Pattern pattern;

        RegexValidator(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean isValid(String value) {
            return this.pattern.matcher(value).matches();
        }

        @Override
        public String pattern() {
            return this.pattern.pattern();
        }
    }
}

