/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class KeyParametersOption {
    public static final AllowAllParametersOption ALLOW_ALL = new AllowAllParametersOption();

    private KeyParametersOption() {
    }

    public static class ECParamatersOption
    extends KeyParametersOption {
        private Set<ASN1ObjectIdentifier> curveOids;
        private Set<Byte> pointEncodings;

        public Set<ASN1ObjectIdentifier> curveOids() {
            return this.curveOids;
        }

        public void setCurveOids(Set<ASN1ObjectIdentifier> curveOids) {
            this.curveOids = curveOids;
        }

        public Set<ASN1ObjectIdentifier> getCurveOids() {
            return this.curveOids;
        }

        public void setPointEncodings(Set<Byte> pointEncodings) {
            this.pointEncodings = pointEncodings;
        }

        public Set<Byte> getPointEncodings() {
            return this.pointEncodings;
        }

        public boolean allowsCurve(ASN1ObjectIdentifier curveOid) {
            Args.notNull((Object)curveOid, (String)"curveOid");
            return this.curveOids == null || this.curveOids.contains(curveOid);
        }

        public boolean allowsPointEncoding(byte encoding) {
            return this.pointEncodings == null || this.pointEncodings.contains(encoding);
        }
    }

    public static class DSAParametersOption
    extends KeyParametersOption {
        private Set<Integer> plengths;
        private Set<Integer> qlengths;

        public void setPlengths(Collection<Integer> plengths) {
            this.plengths = CollectionUtil.isEmpty(plengths) ? null : new HashSet<Integer>(plengths);
        }

        public void setQlengths(Collection<Integer> qlengths) {
            this.qlengths = CollectionUtil.isEmpty(qlengths) ? null : new HashSet<Integer>(qlengths);
        }

        public boolean allowsPlength(int plength) {
            return this.plengths == null || this.plengths.contains(plength);
        }

        public boolean allowsQlength(int qlength) {
            return this.qlengths == null || this.qlengths.contains(qlength);
        }
    }

    public static class RSAParametersOption
    extends KeyParametersOption {
        private Set<Integer> modulusLengths;

        public void setModulusLengths(Collection<Integer> modulusLengths) {
            this.modulusLengths = CollectionUtil.isEmpty(modulusLengths) ? null : new HashSet<Integer>(modulusLengths);
        }

        public boolean allowsModulusLength(int modulusLength) {
            return this.modulusLengths == null || this.modulusLengths.contains(modulusLength);
        }
    }

    public static class AllowAllParametersOption
    extends KeyParametersOption {
    }
}

