/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.io.Closeable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.NotAfterMode;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.api.profile.SubjectKeyIdentifierControl;
import org.xipki.ca.api.profile.TextVadidator;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.SignAlgo;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;
import org.xipki.util.Validity;
import org.xipki.util.exception.BadCertTemplateException;

public abstract class Certprofile
implements Closeable {
    public NotAfterMode getNotAfterMode() {
        return NotAfterMode.BY_CA;
    }

    protected Certprofile() {
    }

    @Override
    public void close() {
    }

    public X509CertVersion getVersion() {
        return X509CertVersion.v3;
    }

    public List<SignAlgo> getSignatureAlgorithms() {
        return null;
    }

    public boolean useIssuerAndSerialInAki() {
        return false;
    }

    public abstract SubjectControl getSubjectControl();

    public abstract AuthorityInfoAccessControl getAiaControl();

    public abstract CrlDistributionPointsControl getCrlDpControl();

    public abstract CrlDistributionPointsControl getFreshestCrlControl();

    public abstract CertificatePolicies getCertificatePolicies();

    public abstract Set<GeneralNameMode> getSubjectAltNameModes();

    public Set<ExtKeyUsageControl> getExtendedKeyUsages() {
        return null;
    }

    public Map<ASN1ObjectIdentifier, Set<GeneralNameMode>> getSubjectInfoAccessModes() {
        return null;
    }

    public abstract Map<ASN1ObjectIdentifier, ExtensionControl> getExtensionControls();

    public abstract void initialize(String var1) throws CertprofileException;

    public abstract CertLevel getCertLevel();

    public abstract CertDomain getCertDomain();

    public KeypairGenControl getKeypairGenControl() {
        return KeypairGenControl.ForbiddenKeypairGenControl.INSTANCE;
    }

    public abstract Map<ASN1ObjectIdentifier, KeyParametersOption> getKeyAlgorithms();

    public abstract Set<KeyUsageControl> getKeyUsage();

    public abstract Integer getPathLenBasicConstraint();

    public abstract Instant getNotBefore(Instant var1);

    public abstract Validity getValidity();

    public boolean hasNoWellDefinedExpirationDate() {
        return false;
    }

    public abstract SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo var1) throws CertprofileException, BadCertTemplateException;

    public abstract SubjectInfo getSubject(X500Name var1) throws CertprofileException, BadCertTemplateException;

    public SubjectInfo getSubject(X500Name requestedSubject, SubjectPublicKeyInfo publicKeyInfo) throws CertprofileException, BadCertTemplateException {
        return this.getSubject(requestedSubject);
    }

    public abstract ExtensionValues getExtensions(Map<ASN1ObjectIdentifier, ExtensionControl> var1, X500Name var2, X500Name var3, Map<ASN1ObjectIdentifier, Extension> var4, Instant var5, Instant var6, PublicCaInfo var7) throws CertprofileException, BadCertTemplateException;

    public int getMaxCertSize() {
        return 0;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) throws CertprofileException {
        String truncateMethod;
        HashAlgo hash;
        SubjectKeyIdentifierControl control = this.getSubjectKeyIdentifierControl();
        SubjectKeyIdentifierControl.SubjectKeyIdentifierMethod method = null;
        String hashAlgo = null;
        if (control != null) {
            method = control.getMethod();
            hashAlgo = control.getHashAlgo();
        }
        if (hashAlgo == null) {
            hash = HashAlgo.SHA1;
        } else {
            try {
                hash = HashAlgo.getInstance(hashAlgo);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertprofileException("unknown hash algorithm " + hashAlgo);
            }
        }
        byte[] encodedSpki = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] skiValue = hash.hash((byte[][])new byte[][]{encodedSpki});
        if (method != null && method != SubjectKeyIdentifierControl.SubjectKeyIdentifierMethod.METHOD_1) {
            if (method == SubjectKeyIdentifierControl.SubjectKeyIdentifierMethod.METHOD_2) {
                byte[] bytes = Arrays.copyOfRange(skiValue, skiValue.length - 8, skiValue.length);
                bytes[0] = (byte)(bytes[0] & 0xF);
                bytes[0] = (byte)(bytes[0] | 0x40);
                skiValue = bytes;
            } else {
                throw new CertprofileException("unknown SubjectKeyIdentifierMethod " + (Object)((Object)method));
            }
        }
        String string = truncateMethod = control == null ? null : control.getTruncateMethod();
        if (StringUtil.isNotBlank((String)truncateMethod)) {
            int size;
            boolean leftmost;
            if (StringUtil.startsWithIgnoreCase((String)truncateMethod, (String)"L:")) {
                leftmost = true;
            } else if (StringUtil.startsWithIgnoreCase((String)truncateMethod, (String)"R:")) {
                leftmost = false;
            } else {
                throw new CertprofileException("unknown TruncateMethod " + truncateMethod);
            }
            try {
                size = Integer.parseUnsignedInt(truncateMethod.substring(2));
            }
            catch (NumberFormatException ex) {
                throw new CertprofileException("invalid TruncateMethod " + truncateMethod);
            }
            if (size < skiValue.length) {
                skiValue = leftmost ? Arrays.copyOf(skiValue, size) : Arrays.copyOfRange(skiValue, skiValue.length - size, skiValue.length);
            }
        }
        return new SubjectKeyIdentifier(skiValue);
    }

    protected SubjectKeyIdentifierControl getSubjectKeyIdentifierControl() {
        return null;
    }

    public String getSerialNumberMode() {
        return null;
    }

    public BigInteger generateSerialNumber(X500Name caSubject, SubjectPublicKeyInfo caPublicKeyInfo, X500Name requestSubject, SubjectPublicKeyInfo publicKeyInfo, ConfPairs caExtraControl) throws CertprofileException {
        throw new UnsupportedOperationException("generateSerialNumber unsupported");
    }

    public static enum X509CertVersion {
        v1(0),
        v2(1),
        v3(2);

        private final int versionNumber;

        private X509CertVersion(int versionNumber) {
            this.versionNumber = versionNumber;
        }

        public int getVersionNumber() {
            return this.versionNumber;
        }

        public static X509CertVersion forName(String version) {
            Args.notNull((Object)version, (String)"version");
            for (X509CertVersion m : X509CertVersion.values()) {
                if (!m.name().equalsIgnoreCase(version)) continue;
                return m;
            }
            throw new IllegalArgumentException("invalid X509CertVersion " + version);
        }
    }

    public static class SubjectInfo {
        private final X500Name grantedSubject;
        private final String warning;

        public SubjectInfo(X500Name grantedSubject, String warning) {
            this.grantedSubject = (X500Name)Args.notNull((Object)grantedSubject, (String)"grantedSubject");
            this.warning = warning;
        }

        public X500Name getGrantedSubject() {
            return this.grantedSubject;
        }

        public String getWarning() {
            return this.warning;
        }
    }

    public static class SubjectControl {
        private final Map<ASN1ObjectIdentifier, RdnControl> controls;
        private final Map<ASN1ObjectIdentifier, String> typeGroups;
        private final Map<String, Set<ASN1ObjectIdentifier>> groupTypes;
        private final Set<String> groups;
        private final List<ASN1ObjectIdentifier> types;

        public SubjectControl(List<RdnControl> controls, boolean keepRdnOrder) {
            Args.notEmpty(controls, (String)"controls");
            this.typeGroups = new HashMap<ASN1ObjectIdentifier, String>();
            ArrayList<ASN1ObjectIdentifier> sortedOids = new ArrayList<ASN1ObjectIdentifier>(controls.size());
            if (keepRdnOrder) {
                for (RdnControl rdnControl : controls) {
                    sortedOids.add(rdnControl.getType());
                }
            } else {
                HashSet<ASN1ObjectIdentifier> oidSet = new HashSet<ASN1ObjectIdentifier>();
                for (RdnControl rdnControl : controls) {
                    oidSet.add(rdnControl.getType());
                }
                List<ASN1ObjectIdentifier> list = SubjectDnSpec.getForwardDNs();
                for (ASN1ObjectIdentifier oid : list) {
                    if (!oidSet.contains(oid)) continue;
                    sortedOids.add(oid);
                }
                for (ASN1ObjectIdentifier oid : oidSet) {
                    if (sortedOids.contains(oid)) continue;
                    sortedOids.add(oid);
                }
            }
            this.types = Collections.unmodifiableList(sortedOids);
            HashSet<String> groupSet = new HashSet<String>();
            this.groupTypes = new HashMap<String, Set<ASN1ObjectIdentifier>>();
            this.controls = new HashMap<ASN1ObjectIdentifier, RdnControl>();
            for (RdnControl rdnControl : controls) {
                ASN1ObjectIdentifier type = rdnControl.getType();
                this.controls.put(type, rdnControl);
                String group = rdnControl.getGroup();
                if (StringUtil.isBlank((String)group)) continue;
                groupSet.add(group);
                this.typeGroups.put(type, group);
                Set typeSet = this.groupTypes.computeIfAbsent(group, k -> new HashSet());
                typeSet.add(type);
            }
            this.groups = Collections.unmodifiableSet(groupSet);
        }

        public RdnControl getControl(ASN1ObjectIdentifier type) {
            Args.notNull((Object)type, (String)"type");
            return this.controls.isEmpty() ? SubjectDnSpec.getRdnControl(type) : this.controls.get(type);
        }

        public String getGroup(ASN1ObjectIdentifier type) {
            return this.typeGroups.get(Args.notNull((Object)type, (String)"type"));
        }

        public Set<ASN1ObjectIdentifier> getTypesForGroup(String group) {
            return this.groupTypes.get(Args.notNull((Object)group, (String)"group"));
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public List<ASN1ObjectIdentifier> getTypes() {
            return this.types;
        }
    }

    public static enum StringType {
        teletexString,
        printableString,
        utf8String,
        bmpString,
        ia5String;


        public ASN1Encodable createString(String text) {
            Args.notNull((Object)text, (String)"text");
            if (teletexString == this) {
                return new DERT61String(text);
            }
            if (printableString == this) {
                return new DERPrintableString(text);
            }
            if (utf8String == this) {
                return new DERUTF8String(text);
            }
            if (bmpString == this) {
                return new DERBMPString(text);
            }
            if (ia5String == this) {
                return new DERIA5String(text, true);
            }
            throw new IllegalStateException("should not reach here, unknown StringType " + this.name());
        }
    }

    public static class RdnControl {
        private final int minOccurs;
        private final int maxOccurs;
        private final ASN1ObjectIdentifier type;
        private TextVadidator pattern;
        private StringType stringType;
        private Range stringLengthRange;
        private String prefix;
        private String suffix;
        private String value;
        private final boolean valueOverridable;
        private String group;
        private boolean notInSubject;

        public RdnControl(ASN1ObjectIdentifier type) {
            this(type, 1, 1);
        }

        public RdnControl(ASN1ObjectIdentifier type, String value, boolean valueOverridable) {
            this.type = (ASN1ObjectIdentifier)Args.notNull((Object)type, (String)"type");
            this.minOccurs = 1;
            this.maxOccurs = 1;
            if (StringUtil.isBlank((String)value)) {
                this.value = null;
                this.valueOverridable = true;
            } else {
                this.value = value;
                this.valueOverridable = valueOverridable;
            }
        }

        public RdnControl(ASN1ObjectIdentifier type, int minOccurs, int maxOccurs) {
            if (minOccurs < 0 || maxOccurs < 1 || minOccurs > maxOccurs) {
                throw new IllegalArgumentException(String.format("illegal minOccurs=%s, maxOccurs=%s", minOccurs, maxOccurs));
            }
            this.type = (ASN1ObjectIdentifier)Args.notNull((Object)type, (String)"type");
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
            this.valueOverridable = true;
        }

        public int getMinOccurs() {
            return this.minOccurs;
        }

        public int getMaxOccurs() {
            return this.maxOccurs;
        }

        public ASN1ObjectIdentifier getType() {
            return this.type;
        }

        public StringType getStringType() {
            return this.stringType;
        }

        public TextVadidator getPattern() {
            return this.pattern;
        }

        public Range getStringLengthRange() {
            return this.stringLengthRange;
        }

        public void setStringType(StringType stringType) {
            this.stringType = stringType;
        }

        public void setStringLengthRange(Range stringLengthRange) {
            this.stringLengthRange = stringLengthRange;
        }

        public void setPattern(TextVadidator pattern) {
            this.pattern = pattern;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isValueOverridable() {
            return this.valueOverridable;
        }

        public boolean isNotInSubject() {
            return this.notInSubject;
        }

        public void setNotInSubject(boolean notInSubject) {
            this.notInSubject = notInSubject;
        }
    }

    public static class KeyUsageControl {
        private final KeyUsage keyUsage;
        private final boolean required;

        public KeyUsageControl(String keyUsage, boolean required) {
            Args.notNull((Object)keyUsage, (String)"keyUsage");
            this.keyUsage = KeyUsage.getKeyUsage((String)keyUsage);
            this.required = required;
        }

        public KeyUsage getKeyUsage() {
            return this.keyUsage;
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    public static class GeneralNameMode {
        private final GeneralNameTag tag;
        private final Set<ASN1ObjectIdentifier> allowedTypes;

        public GeneralNameMode(GeneralNameTag tag) {
            this.tag = (GeneralNameTag)((Object)Args.notNull((Object)((Object)tag), (String)"tag"));
            this.allowedTypes = null;
        }

        public GeneralNameMode(GeneralNameTag tag, Set<ASN1ObjectIdentifier> allowedTypes) {
            this.tag = (GeneralNameTag)((Object)Args.notNull((Object)((Object)tag), (String)"tag"));
            this.allowedTypes = CollectionUtil.isEmpty(allowedTypes) ? Collections.emptySet() : CollectionUtil.unmodifiableSet(allowedTypes);
        }

        public GeneralNameTag getTag() {
            return this.tag;
        }

        public Set<ASN1ObjectIdentifier> getAllowedTypes() {
            return this.allowedTypes;
        }
    }

    public static enum GeneralNameTag {
        otherName(0),
        rfc822Name(1),
        DNSName(2),
        x400Adress(3),
        directoryName(4),
        ediPartyName(5),
        uniformResourceIdentifier(6),
        IPAddress(7),
        registeredID(8);

        private final int tag;

        private GeneralNameTag(int tag) {
            this.tag = tag;
        }

        public int getTag() {
            return this.tag;
        }
    }

    public static class ExtKeyUsageControl {
        private final ASN1ObjectIdentifier extKeyUsage;
        private final boolean required;

        public ExtKeyUsageControl(ASN1ObjectIdentifier extKeyUsage, boolean required) {
            this.extKeyUsage = (ASN1ObjectIdentifier)Args.notNull((Object)extKeyUsage, (String)"extKeyUsage");
            this.required = required;
        }

        public ASN1ObjectIdentifier getExtKeyUsage() {
            return this.extKeyUsage;
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    public static class ExtensionControl {
        private final boolean critical;
        private final boolean required;
        private final TripleState inRequest;

        public ExtensionControl(boolean critical, boolean required, TripleState inRequest) {
            this.critical = critical;
            this.required = required;
            this.inRequest = inRequest == null ? TripleState.forbidden : inRequest;
        }

        public boolean isCritical() {
            return this.critical;
        }

        public boolean isRequired() {
            return this.required;
        }

        public TripleState getInRequest() {
            return this.inRequest;
        }

        public boolean isPermittedInRequest() {
            return TripleState.required == this.inRequest || TripleState.optional == this.inRequest;
        }
    }

    public static enum CertLevel {
        RootCA,
        SubCA,
        CROSS,
        EndEntity;

    }

    public static enum CertDomain {
        RFC5280,
        CABForumBR;

    }

    public static class CrlDistributionPointsControl {
        private final Set<String> protocols;

        public CrlDistributionPointsControl(Set<String> protocols) {
            this.protocols = protocols == null ? null : Collections.unmodifiableSet(new HashSet<String>(protocols));
        }

        public Set<String> getProtocols() {
            return this.protocols;
        }
    }

    public static class AuthorityInfoAccessControl {
        private final boolean includesCaIssuers;
        private final boolean includesOcsp;
        private final Set<String> ocspProtocols;
        private final Set<String> caIssuersProtocols;

        public AuthorityInfoAccessControl(boolean includesCaIssuers, boolean includesOcsp, Set<String> caIssuersProtocols, Set<String> ocspProtocols) {
            this.includesCaIssuers = includesCaIssuers;
            this.includesOcsp = includesOcsp;
            this.ocspProtocols = ocspProtocols == null ? null : Collections.unmodifiableSet(new HashSet<String>(ocspProtocols));
            this.caIssuersProtocols = caIssuersProtocols == null ? null : Collections.unmodifiableSet(new HashSet<String>(caIssuersProtocols));
        }

        public boolean isIncludesCaIssuers() {
            return this.includesCaIssuers;
        }

        public boolean isIncludesOcsp() {
            return this.includesOcsp;
        }

        public Set<String> getOcspProtocols() {
            return this.ocspProtocols;
        }

        public Set<String> getCaIssuersProtocols() {
            return this.caIssuersProtocols;
        }
    }
}

