/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DomainValidator {
    private static final String DOMAIN_LABEL_REGEX = "\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*";
    private static final String TOP_LABEL_REGEX = "\\p{Alpha}{2,}";
    private static final String DOMAIN_NAME_REGEX = "^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alpha}{2,})$";
    private static final DomainValidator DOMAIN_VALIDATOR = new DomainValidator();
    private final RegexValidator domainRegex = new RegexValidator("^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alpha}{2,})$", true);

    public static DomainValidator getInstance() {
        return DOMAIN_VALIDATOR;
    }

    private DomainValidator() {
    }

    public boolean isValid(String domain) {
        String[] groups = this.domainRegex.match(domain.startsWith("*.") ? domain.substring(2) : domain);
        return groups != null && groups.length > 0;
    }

    static class RegexValidator {
        private final Pattern pattern;

        public RegexValidator(String regex, boolean caseSensitive) {
            if (regex == null || regex.isEmpty()) {
                throw new IllegalArgumentException("Regular expression is missing");
            }
            int flags = caseSensitive ? 0 : 2;
            this.pattern = Pattern.compile(regex, flags);
        }

        public String[] match(String value) {
            if (value == null) {
                return null;
            }
            Matcher matcher = this.pattern.matcher(value);
            if (matcher.matches()) {
                int count = matcher.groupCount();
                String[] groups = new String[count];
                for (int j = 0; j < count; ++j) {
                    groups[j] = matcher.group(j + 1);
                }
                return groups;
            }
            return null;
        }
    }
}

