/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.publisher;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherFactory;
import org.xipki.util.Args;
import org.xipki.util.exception.ObjectCreationException;

public class CertPublisherFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(CertPublisherFactoryRegister.class);
    private final ConcurrentLinkedDeque<CertPublisherFactory> factories = new ConcurrentLinkedDeque();

    public boolean canCreatePublisher(String type) {
        for (CertPublisherFactory service : this.factories) {
            if (!service.canCreatePublisher(type)) continue;
            return true;
        }
        return false;
    }

    public CertPublisher newPublisher(String type) throws ObjectCreationException {
        Args.notBlank((String)type, (String)"type");
        for (CertPublisherFactory service : this.factories) {
            if (!service.canCreatePublisher(type)) continue;
            return service.newPublisher(type);
        }
        throw new ObjectCreationException("could not find factory to create Publisher of type " + type);
    }

    public Set<String> getSupportedTypes() {
        HashSet<String> types = new HashSet<String>();
        for (CertPublisherFactory service : this.factories) {
            types.addAll(service.getSupportedTypes());
        }
        return Collections.unmodifiableSet(types);
    }

    public void bindService(CertPublisherFactory service) {
        this.registFactory(service);
    }

    public void registFactory(CertPublisherFactory factory) {
        if (factory == null) {
            LOG.info("registFactory invoked with null.");
            return;
        }
        boolean replaced = this.factories.remove(factory);
        this.factories.add(factory);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} CertPublisherFactory binding for {}", (Object)action, (Object)factory);
    }

    public void unbindService(CertPublisherFactory service) {
        this.unregistFactory(service);
    }

    public void unregistFactory(CertPublisherFactory factory) {
        if (factory == null) {
            LOG.info("unregistFactory invoked with null.");
            return;
        }
        if (this.factories.remove(factory)) {
            LOG.info("removed CertPublisherFactory binding for {}", (Object)factory);
        } else {
            LOG.info("no CertPublisherFactory binding found to remove for {}", (Object)factory);
        }
    }
}

