/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api;

import java.util.Collections;
import java.util.List;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;

public class CaUris {
    public static final CaUris EMPTY_INSTANCE = new CaUris(null, null, null, null);
    public static final String NAME_CACERT_URIS = "cacert.uris";
    public static final String NAME_OCSP_URIS = "ocsp.uris";
    public static final String NAME_CRL_URIS = "crl.uris";
    public static final String NAME_DELTACRL_URIS = "deltacrl.uris";
    private List<String> cacertUris;
    private List<String> ocspUris;
    private List<String> crlUris;
    private List<String> deltaCrlUris;

    private CaUris() {
    }

    public CaUris(List<String> cacertUris, List<String> ocspUris, List<String> crlUris, List<String> deltaCrlUris) {
        this.setCacertUris(cacertUris);
        this.setOcspUris(ocspUris);
        this.setCrlUris(crlUris);
        this.setDeltaCrlUris(deltaCrlUris);
    }

    public void setCacertUris(List<String> cacertUris) {
        this.cacertUris = CollectionUtil.isEmpty(cacertUris) ? null : Collections.unmodifiableList(cacertUris);
    }

    public List<String> getCacertUris() {
        return this.cacertUris;
    }

    public void setOcspUris(List<String> ocspUris) {
        this.ocspUris = CollectionUtil.isEmpty(ocspUris) ? null : Collections.unmodifiableList(ocspUris);
    }

    public List<String> getOcspUris() {
        return this.ocspUris;
    }

    public void setCrlUris(List<String> crlUris) {
        this.crlUris = CollectionUtil.isEmpty(crlUris) ? null : Collections.unmodifiableList(crlUris);
    }

    public List<String> getCrlUris() {
        return this.crlUris;
    }

    public void setDeltaCrlUris(List<String> deltaCrlUris) {
        this.deltaCrlUris = CollectionUtil.isEmpty(deltaCrlUris) ? null : Collections.unmodifiableList(deltaCrlUris);
    }

    public List<String> getDeltaCrlUris() {
        return this.deltaCrlUris;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaUris)) {
            return false;
        }
        CaUris other = (CaUris)obj;
        return CompareUtil.equalsObject(this.cacertUris, other.cacertUris) && CompareUtil.equalsObject(this.ocspUris, other.ocspUris) && CompareUtil.equalsObject(this.crlUris, other.crlUris) && CompareUtil.equalsObject(this.deltaCrlUris, other.deltaCrlUris);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "CA URIs:\n  CACert URIs:" + CaUris.formatUris(this.cacertUris) + "\n  OCSP URIs:" + CaUris.formatUris(this.ocspUris) + "\n  CRL URIs:" + CaUris.formatUris(this.crlUris) + "\n  DeltaCRL URIs:" + CaUris.formatUris(this.deltaCrlUris);
    }

    private static String formatUris(List<String> uris) {
        if (CollectionUtil.isEmpty(uris)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String uri : uris) {
            sb.append("\n    ").append(uri);
        }
        return sb.toString();
    }

    public static CaUris decode(String encoded) {
        ConfPairs pairs = new ConfPairs(encoded);
        return new CaUris(StringUtil.split((String)pairs.value(NAME_CACERT_URIS), (String)"|"), StringUtil.split((String)pairs.value(NAME_OCSP_URIS), (String)"|"), StringUtil.split((String)pairs.value(NAME_CRL_URIS), (String)"|"), StringUtil.split((String)pairs.value(NAME_DELTACRL_URIS), (String)"|"));
    }

    public String encode() {
        String str;
        ConfPairs pairs = new ConfPairs();
        if (!CollectionUtil.isEmpty(this.cacertUris)) {
            str = StringUtil.collectionAsString(this.cacertUris, (String)"|");
            pairs.putPair(NAME_CACERT_URIS, str);
        }
        if (!CollectionUtil.isEmpty(this.ocspUris)) {
            str = StringUtil.collectionAsString(this.ocspUris, (String)"|");
            pairs.putPair(NAME_OCSP_URIS, str);
        }
        if (!CollectionUtil.isEmpty(this.crlUris)) {
            str = StringUtil.collectionAsString(this.crlUris, (String)"|");
            pairs.putPair(NAME_CRL_URIS, str);
        }
        if (!CollectionUtil.isEmpty(this.deltaCrlUris)) {
            str = StringUtil.collectionAsString(this.deltaCrlUris, (String)"|");
            pairs.putPair(NAME_DELTACRL_URIS, str);
        }
        return pairs.getEncoded();
    }
}

