/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.api.profile.TextVadidator;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;

public class SubjectDnSpec {
    private static final Logger LOG;
    private static final Range RANGE_64;
    private static final Range RANGE_128;
    private static final Range RANGE_255;
    private static final Range RANGE_POSTAL_CODE;
    private static final Range RANGE_COUNTRY_NAME;
    private static final Range RANGE_POSTAL_ADDRESS;
    private static final Range RANGE_GENDER;
    private static final Range RANGE_DATE_OF_BIRTH;
    private static final Range RANGE_NAME;
    private static final Set<Certprofile.StringType> DIRECTORY_STRINGS;
    private static final Set<Certprofile.StringType> PRINTABLE_STRING_ONLY;
    private static final Set<Certprofile.StringType> IA5_STRING_ONLY;
    private static final Map<ASN1ObjectIdentifier, Certprofile.StringType> DFLT_STRING_TYPES;
    private static final Map<ASN1ObjectIdentifier, Range> RANGES;
    private static final Map<ASN1ObjectIdentifier, TextVadidator> PATTERNS;
    private static final Map<ASN1ObjectIdentifier, Certprofile.RdnControl> CONTROLS;
    private static final Map<ASN1ObjectIdentifier, Set<Certprofile.StringType>> STRING_TYPE_SET;
    private static final List<ASN1ObjectIdentifier> FORWARD_DNS;
    private static final Set<String> COUNTRY_AREA_CODES;

    private SubjectDnSpec() {
    }

    private static void conf(Set<ASN1ObjectIdentifier> types, ASN1ObjectIdentifier type, Range range, Set<Certprofile.StringType> stringTypes) {
        types.add(type);
        if (range != null) {
            RANGES.put(type, range);
        }
        if (stringTypes != null) {
            STRING_TYPE_SET.put(type, stringTypes);
            if (stringTypes.size() == 1) {
                DFLT_STRING_TYPES.put(type, stringTypes.iterator().next());
            }
        }
    }

    public static Range getStringLengthRange(ASN1ObjectIdentifier rdnType) {
        return RANGES.get(Args.notNull((Object)rdnType, (String)"rdnType"));
    }

    public static TextVadidator getPattern(ASN1ObjectIdentifier rdnType) {
        return PATTERNS.get(Args.notNull((Object)rdnType, (String)"rdnType"));
    }

    public static Certprofile.StringType getStringType(ASN1ObjectIdentifier rdnType) {
        return DFLT_STRING_TYPES.get(Args.notNull((Object)rdnType, (String)"rdnType"));
    }

    public static Certprofile.RdnControl getRdnControl(ASN1ObjectIdentifier rdnType) {
        Certprofile.RdnControl control = CONTROLS.get(Args.notNull((Object)rdnType, (String)"rdnType"));
        if (control == null) {
            control = new Certprofile.RdnControl(rdnType, 0, 9);
            control.setStringType(Certprofile.StringType.utf8String);
        }
        return control;
    }

    public static void fixRdnControl(Certprofile.RdnControl control) throws CertprofileException {
        Range specRange;
        ASN1ObjectIdentifier type = ((Certprofile.RdnControl)Args.notNull((Object)control, (String)"control")).getType();
        Certprofile.StringType stringType = control.getStringType();
        if (stringType != null) {
            if (STRING_TYPE_SET.containsKey(type) && !STRING_TYPE_SET.get(type).contains((Object)stringType)) {
                throw new CertprofileException(String.format("%s is not allowed %s", stringType.name(), type.getId()));
            }
        } else {
            Certprofile.StringType specStrType = DFLT_STRING_TYPES.get(type);
            if (specStrType != null) {
                control.setStringType(specStrType);
            }
        }
        if (control.getPattern() == null && PATTERNS.containsKey(type)) {
            control.setPattern(PATTERNS.get(type));
        }
        if ((specRange = RANGES.get(type)) == null) {
            control.setStringLengthRange(null);
            return;
        }
        Range isRange = control.getStringLengthRange();
        if (isRange == null) {
            control.setStringLengthRange(specRange);
            return;
        }
        boolean changed = false;
        Integer specMin = specRange.getMin();
        Integer min = isRange.getMin();
        if (min == null) {
            changed = true;
            min = specMin;
        } else if (specMin != null && specMin > min) {
            changed = true;
            min = specMin;
        }
        Integer specMax = specRange.getMax();
        Integer max = isRange.getMax();
        if (max == null) {
            changed = true;
            max = specMax;
        } else if (specMax != null && specMax < max) {
            changed = true;
            max = specMax;
        }
        if (changed) {
            isRange.setRange(min, max);
        }
    }

    public static List<ASN1ObjectIdentifier> getForwardDNs() {
        return FORWARD_DNS;
    }

    public static boolean isValidCountryAreaCode(String code) {
        Args.notBlank((String)code, (String)"code");
        return COUNTRY_AREA_CODES.isEmpty() || COUNTRY_AREA_CODES.contains(code.toUpperCase());
    }

    private static BufferedReader getReader(String propKey, String fallbackResource) {
        String confFile = System.getProperty(propKey);
        if (StringUtil.isNotBlank((String)confFile)) {
            LOG.info("read from file " + confFile);
            try {
                return Files.newBufferedReader(Paths.get(confFile, new String[0]));
            }
            catch (IOException ex) {
                throw new IllegalStateException("could not access non-existing file " + confFile);
            }
        }
        InputStream confStream = Optional.ofNullable(SubjectDnSpec.class.getResourceAsStream(fallbackResource)).orElseThrow(() -> new IllegalStateException("could not access non-existing resource " + fallbackResource));
        LOG.info("read from resource " + fallbackResource);
        return new BufferedReader(new InputStreamReader(confStream, StandardCharsets.UTF_8));
    }

    static {
        String line;
        LOG = LoggerFactory.getLogger(SubjectDnSpec.class);
        RANGE_64 = new Range(1, 64);
        RANGE_128 = new Range(1, 128);
        RANGE_255 = new Range(1, 255);
        RANGE_POSTAL_CODE = new Range(1, 40);
        RANGE_COUNTRY_NAME = new Range(2, 2);
        RANGE_POSTAL_ADDRESS = new Range(0, 30);
        RANGE_GENDER = new Range(1, 1);
        RANGE_DATE_OF_BIRTH = new Range(15, 15);
        RANGE_NAME = new Range(1, 256);
        DIRECTORY_STRINGS = CollectionUtil.asUnmodifiableSet((Object[])new Certprofile.StringType[]{Certprofile.StringType.bmpString, Certprofile.StringType.printableString, Certprofile.StringType.teletexString, Certprofile.StringType.utf8String});
        PRINTABLE_STRING_ONLY = CollectionUtil.asUnmodifiableSet((Object[])new Certprofile.StringType[]{Certprofile.StringType.printableString});
        IA5_STRING_ONLY = CollectionUtil.asUnmodifiableSet((Object[])new Certprofile.StringType[]{Certprofile.StringType.ia5String});
        DFLT_STRING_TYPES = new HashMap<ASN1ObjectIdentifier, Certprofile.StringType>();
        RANGES = new HashMap<ASN1ObjectIdentifier, Range>();
        PATTERNS = new HashMap<ASN1ObjectIdentifier, TextVadidator>();
        CONTROLS = new HashMap<ASN1ObjectIdentifier, Certprofile.RdnControl>();
        STRING_TYPE_SET = new HashMap<ASN1ObjectIdentifier, Set<Certprofile.StringType>>();
        COUNTRY_AREA_CODES = new HashSet<String>();
        BufferedReader reader = SubjectDnSpec.getReader("org.xipki.ca.rdnorder.cfg", "/conf/rdnorder.cfg");
        ArrayList<ASN1ObjectIdentifier> tmpForwardDNs = new ArrayList<ASN1ObjectIdentifier>(25);
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(line);
                tmpForwardDNs.add(oid);
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(new Exception("could not load RDN order: " + ex.getMessage(), ex));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        FORWARD_DNS = Collections.unmodifiableList(tmpForwardDNs);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("forward RDNs: ");
            for (ASN1ObjectIdentifier oid : FORWARD_DNS) {
                String desc = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
                if (desc == null) {
                    sb.append(oid.getId());
                    continue;
                }
                sb.append(desc).append(" (").append(oid.getId()).append("), ");
            }
            if (!FORWARD_DNS.isEmpty()) {
                sb.delete(sb.length() - 2, sb.length());
            }
            LOG.info(sb.toString());
        }
        reader = SubjectDnSpec.getReader("org.xipki.ca.areacode.cfg", "/conf/areacode.cfg");
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, ";");
                int n = st.countTokens();
                if (n != 4) {
                    LOG.warn("invalid country/area line {}", (Object)line);
                    continue;
                }
                st.nextToken();
                String areaCode = st.nextToken().trim();
                COUNTRY_AREA_CODES.add(areaCode.toUpperCase());
            }
            if (LOG.isInfoEnabled()) {
                ArrayList<String> list = new ArrayList<String>(COUNTRY_AREA_CODES);
                Collections.sort(list);
                LOG.info("area/country codes: {}", list);
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(new Exception("could not load area code: " + ex.getMessage(), ex));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        HashSet<ASN1ObjectIdentifier> ids = new HashSet<ASN1ObjectIdentifier>();
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.businessCategory, RANGE_128, DIRECTORY_STRINGS);
        ASN1ObjectIdentifier[] idList = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C, ObjectIdentifiers.DN.countryOfCitizenship, ObjectIdentifiers.DN.countryOfResidence, ObjectIdentifiers.DN.jurisdictionOfIncorporationCountryName};
        for (ASN1ObjectIdentifier m : idList) {
            SubjectDnSpec.conf(ids, m, RANGE_COUNTRY_NAME, PRINTABLE_STRING_ONLY);
        }
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.CN, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.emailAddress, RANGE_255, IA5_STRING_ONLY);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.dateOfBirth, RANGE_DATE_OF_BIRTH, null);
        PATTERNS.put(ObjectIdentifiers.DN.dateOfBirth, TextVadidator.DATE_OF_BIRTH);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.DC, null, IA5_STRING_ONLY);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.dmdName, null, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.gender, RANGE_GENDER, PRINTABLE_STRING_ONLY);
        PATTERNS.put(ObjectIdentifiers.DN.gender, TextVadidator.GENDER);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.generationQualifier, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.givenName, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.initials, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.userid, null, DIRECTORY_STRINGS);
        idList = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.localityName, ObjectIdentifiers.DN.jurisdictionOfIncorporationLocalityName};
        for (ASN1ObjectIdentifier m : idList) {
            SubjectDnSpec.conf(ids, m, RANGE_128, DIRECTORY_STRINGS);
        }
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.name, RANGE_NAME, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.nameAtBirth, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.O, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.organizationIdentifier, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.NIF, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.CIF, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.OU, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.placeOfBirth, RANGE_128, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.postalAddress, RANGE_POSTAL_ADDRESS, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.postalCode, RANGE_POSTAL_CODE, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.pseudonym, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.dnQualifier, RANGE_64, PRINTABLE_STRING_ONLY);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.serialNumber, RANGE_64, PRINTABLE_STRING_ONLY);
        idList = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.ST, ObjectIdentifiers.DN.jurisdictionOfIncorporationStateOrProvinceName};
        for (ASN1ObjectIdentifier m : idList) {
            SubjectDnSpec.conf(ids, m, RANGE_128, DIRECTORY_STRINGS);
        }
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.street, RANGE_128, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.surname, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.T, RANGE_64, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.telephoneNumber, null, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.uniqueIdentifier, null, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.unstructuredAddress, null, DIRECTORY_STRINGS);
        SubjectDnSpec.conf(ids, ObjectIdentifiers.DN.unstructuredName, null, DIRECTORY_STRINGS);
        for (ASN1ObjectIdentifier type : ids) {
            Certprofile.RdnControl control = new Certprofile.RdnControl(type, 0, 9);
            control.setStringType(DFLT_STRING_TYPES.get(type));
            control.setStringLengthRange(RANGES.get(type));
            TextVadidator pattern = PATTERNS.get(type);
            if (pattern != null) {
                control.setPattern(pattern);
            }
            CONTROLS.put(type, control);
        }
    }
}

