/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.api;

import java.security.cert.Certificate;
import java.util.Map;
import java.util.Set;
import org.xipki.ca.client.api.CertifiedKeyPairOrError;
import org.xipki.util.ParamUtil;

public class EnrollCertResult {
    private final Certificate caCert;
    private final Map<String, CertifiedKeyPairOrError> certsOrErrors;

    public EnrollCertResult(Certificate caCert, Map<String, CertifiedKeyPairOrError> certsOrErrors) {
        this.certsOrErrors = ParamUtil.requireNonEmpty((String)"certsOrErrors", certsOrErrors);
        this.caCert = caCert;
    }

    public Certificate getCaCert() {
        return this.caCert;
    }

    public CertifiedKeyPairOrError getCertOrError(String id) {
        ParamUtil.requireNonBlank((String)"id", (String)id);
        return this.certsOrErrors.get(id);
    }

    public Set<String> getAllIds() {
        return this.certsOrErrors.keySet();
    }
}

