/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.api.dto;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Integer;
import org.xipki.ca.client.api.dto.EnrollCertRequestEntry;
import org.xipki.util.ParamUtil;

public class EnrollCertRequest {
    private final Type type;
    private final List<EnrollCertRequestEntry> requestEntries = new LinkedList<EnrollCertRequestEntry>();

    public EnrollCertRequest(Type type) {
        this.type = (Type)((Object)ParamUtil.requireNonNull((String)"type", (Object)((Object)type)));
    }

    public Type getType() {
        return this.type;
    }

    public boolean addRequestEntry(EnrollCertRequestEntry requestEntry) {
        ParamUtil.requireNonNull((String)"requestEntry", (Object)requestEntry);
        String id = requestEntry.getId();
        ASN1Integer certReqId = requestEntry.getCertReq().getCertReqId();
        for (EnrollCertRequestEntry re : this.requestEntries) {
            if (re.getId().equals(id)) {
                return false;
            }
            if (!re.getCertReq().getCertReqId().equals((Object)certReqId)) continue;
            return false;
        }
        this.requestEntries.add(requestEntry);
        return true;
    }

    public List<EnrollCertRequestEntry> getRequestEntries() {
        return Collections.unmodifiableList(this.requestEntries);
    }

    public static enum Type {
        CERT_REQ,
        INIT_REQ,
        KEY_UPDATE,
        CROSS_CERT_REQ;

    }
}

