/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.api.dto;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.client.api.dto.ResultEntry;
import org.xipki.util.ParamUtil;

public class IssuerSerialEntry
extends ResultEntry {
    private final X500Name issuer;
    private final BigInteger serialNumber;

    public IssuerSerialEntry(String id, X509Certificate cert) {
        this(id, X500Name.getInstance((Object)cert.getIssuerX500Principal().getEncoded()), cert.getSerialNumber());
    }

    public IssuerSerialEntry(String id, X500Name issuer, BigInteger serialNumber) {
        super(id);
        this.serialNumber = (BigInteger)ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        this.issuer = (X500Name)ParamUtil.requireNonNull((String)"issuer", (Object)issuer);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }
}

