/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.api.dto;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.client.api.dto.IssuerSerialEntry;

public class RevokeCertRequestEntry
extends IssuerSerialEntry {
    private int reason;
    private Date invalidityDate;
    private byte[] authorityKeyIdentifier;

    public RevokeCertRequestEntry(String id, X509Certificate cert, int reason, Date invalidityDate) {
        this(id, X500Name.getInstance((Object)cert.getIssuerX500Principal().getEncoded()), cert.getSerialNumber(), reason, invalidityDate);
    }

    public RevokeCertRequestEntry(String id, X500Name issuer, BigInteger serialNumber, int reason, Date invalidityDate) {
        super(id, issuer, serialNumber);
        if (reason < 0 || reason > 10 || reason == 7) {
            throw new IllegalArgumentException("invalid reason: " + reason);
        }
        this.reason = reason;
        this.invalidityDate = invalidityDate;
    }

    public int getReason() {
        return this.reason;
    }

    public Date getInvalidityDate() {
        return this.invalidityDate;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public void setAuthorityKeyIdentifier(byte[] authorityKeyIdentifier) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
    }
}

