/*
 *
 * Copyright (c) 2013 - 2018 Lijun Liao
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.xipki.ca.dbtool.xmlio.ca;

import javax.xml.stream.XMLStreamException;

import org.xipki.ca.dbtool.xmlio.DbiXmlWriter;
import org.xipki.ca.dbtool.xmlio.IdentifidDbObjectType;
import org.xipki.ca.dbtool.xmlio.InvalidDataObjectException;
import org.xipki.util.ParamUtil;

/**
 * TODO.
 * @author Lijun Liao
 * @since 2.0.0
 */

public class CertType extends IdentifidDbObjectType {

  public static final String TAG_PARENT = "certs";

  public static final String TAG_ROOT = "cert";

  public static final String TAG_CAID = "caId";

  /**
   * certificate serial number.
   */
  public static final String TAG_SN = "sn";

  /**
   * certificate profile id.
   */
  public static final String TAG_PID = "pid";

  /**
   * requestor id.
   */
  public static final String TAG_RID = "rid";

  /**
   * first 8 bytes of the SHA1 sum of the requested subject.
   */
  public static final String TAG_FP_RS = "fpRs";

  /**
   * requested subject, if differs from the one in certificate.
   */
  public static final String TAG_RS = "rs";

  public static final String TAG_UPDATE = "update";

  /**
   * whether revoked.
   */
  public static final String TAG_REV = "rev";

  /**
   * revocation reason.
   */
  public static final String TAG_RR = "rr";

  /**
   * revocation time.
   */
  public static final String TAG_RT = "rt";

  /**
   * revocation invalidity time.
   */
  public static final String TAG_RIT = "rit";

  public static final String TAG_EE = "ee";

  public static final String TAG_UID = "uid";

  /**
   * base64 encoded transaction id.
   */
  public static final String TAG_TID = "tid";

  public static final String TAG_REQ_TYPE = "reqType";

  private String file;

  private Integer caId;

  private String sn;

  private Integer pid;

  private Integer rid;

  private Boolean ee;

  private Long update;

  private Boolean rev;

  private Integer rr;

  private Long rt;

  private Long rit;

  private Integer uid;

  private String tid;

  private Integer reqType;

  private Long fpRs;

  private String rs;

  public Integer getCaId() {
    return caId;
  }

  public void setCaId(Integer caId) {
    this.caId = caId;
  }

  public String getSn() {
    return sn;
  }

  public void setSn(String sn) {
    this.sn = sn;
  }

  public Boolean isEe() {
    return ee;
  }

  public void setEe(Boolean ee) {
    this.ee = ee;
  }

  public Integer getPid() {
    return pid;
  }

  public void setPid(Integer pid) {
    this.pid = pid;
  }

  public Integer getRid() {
    return rid;
  }

  public void setRid(Integer rid) {
    this.rid = rid;
  }

  public Long getUpdate() {
    return update;
  }

  public void setUpdate(Long update) {
    this.update = update;
  }

  public Boolean getRev() {
    return rev;
  }

  public void setRev(Boolean rev) {
    this.rev = rev;
  }

  public Integer getRr() {
    return rr;
  }

  public void setRr(Integer rr) {
    this.rr = rr;
  }

  public Long getRt() {
    return rt;
  }

  public void setRt(Long rt) {
    this.rt = rt;
  }

  public Long getRit() {
    return rit;
  }

  public void setRit(Long rit) {
    this.rit = rit;
  }

  public String getTid() {
    return tid;
  }

  public void setTid(String tid) {
    this.tid = tid;
  }

  public Integer getReqType() {
    return reqType;
  }

  public void setReqType(Integer reqType) {
    this.reqType = reqType;
  }

  public Long getFpRs() {
    return fpRs;
  }

  public void setFpRs(Long fpRs) {
    this.fpRs = fpRs;
  }

  public String getRs() {
    return rs;
  }

  public void setRs(String rs) {
    this.rs = rs;
  }

  public String getFile() {
    return file;
  }

  public void setFile(String file) {
    this.file = file;
  }

  public Integer getUid() {
    return uid;
  }

  public void setUid(Integer uid) {
    this.uid = uid;
  }

  @Override
  public void validate() throws InvalidDataObjectException {
    super.validate();

    assertNotNull(TAG_CAID, caId);
    assertNotNull(TAG_EE, ee);
    assertNotBlank(TAG_FILE, file);
    assertNotNull(TAG_PID, pid);
    assertNotNull(TAG_REQ_TYPE, reqType);
    assertNotNull(TAG_REV, rev);
    assertNotNull(TAG_RID, rid);
    assertNotBlank(TAG_SN, sn);
    assertNotNull(TAG_UPDATE, update);
    if (rev) {
      assertNotNull(TAG_RR, rr);
      assertNotNull(TAG_RT, rt);
    }
  }

  @Override
  public void writeTo(DbiXmlWriter writer) throws InvalidDataObjectException, XMLStreamException {
    ParamUtil.requireNonNull("writer", writer);

    validate();

    writer.writeStartElement(TAG_ROOT);
    writeIfNotNull(writer, TAG_ID, getId());
    writeIfNotNull(writer, TAG_CAID, caId);
    writeIfNotNull(writer, TAG_SN, sn);
    writeIfNotNull(writer, TAG_PID, pid);
    writeIfNotNull(writer, TAG_RID, rid);
    writeIfNotNull(writer, TAG_EE, ee);
    writeIfNotNull(writer, TAG_UPDATE, update);
    writeIfNotNull(writer, TAG_REV, rev);
    writeIfNotNull(writer, TAG_RR, rr);
    writeIfNotNull(writer, TAG_RT, rt);
    writeIfNotNull(writer, TAG_RIT, rit);
    writeIfNotNull(writer, TAG_UID, uid);
    writeIfNotNull(writer, TAG_TID, tid);
    writeIfNotNull(writer, TAG_REQ_TYPE, reqType);
    writeIfNotNull(writer, TAG_FP_RS, fpRs);
    writeIfNotNull(writer, TAG_RS, rs);
    writeIfNotNull(writer, TAG_FILE, file);
    writer.writeEndElement();
    writer.writeNewline();
  }

}
