/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.ParamUtil;

public class DbSchemaInfo {
    private final Map<String, String> variables = new HashMap<String, String>();

    public DbSchemaInfo(DataSourceWrapper datasource) throws DataAccessException {
        ParamUtil.requireNonNull((String)"datasource", (Object)datasource);
        String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
        Connection connection = datasource.getConnection();
        if (connection == null) {
            throw new DataAccessException("could not get connection");
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = datasource.createStatement(connection);
            if (stmt == null) {
                throw new DataAccessException("could not create statement");
            }
            rs = stmt.executeQuery("SELECT NAME,VALUE2 FROM DBSCHEMA");
            while (rs.next()) {
                this.variables.put(rs.getString("NAME"), rs.getString("VALUE2"));
            }
        }
        catch (SQLException ex) {
            try {
                throw datasource.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
            }
            catch (Throwable throwable) {
                datasource.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        datasource.releaseResources(stmt, rs);
    }

    public Set<String> getVariableNames() {
        return Collections.unmodifiableSet(this.variables.keySet());
    }

    public String getVariableValue(String variableName) {
        ParamUtil.requireNonNull((String)"variableName", (Object)variableName);
        return this.variables.get(variableName);
    }

    public void setVariable(String name, String value) {
        this.variables.put(name, value);
    }
}

