/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.diffdb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.diffdb.DigestEntry;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

class DigestDiffReporter {
    private static final Logger LOG = LoggerFactory.getLogger(DigestDiffReporter.class);
    private final String reportDirname;
    private final BufferedWriter goodWriter;
    private final BufferedWriter diffWriter;
    private final BufferedWriter missingWriter;
    private final BufferedWriter unexpectedWriter;
    private final BufferedWriter errorWriter;
    private Date startTime;
    private AtomicInteger numGood = new AtomicInteger(0);
    private AtomicInteger numDiff = new AtomicInteger(0);
    private AtomicInteger numMissing = new AtomicInteger(0);
    private AtomicInteger numUnexpected = new AtomicInteger(0);
    private AtomicInteger numError = new AtomicInteger(0);

    public DigestDiffReporter(String reportDirname, byte[] caCertBytes) throws IOException {
        this.reportDirname = ParamUtil.requireNonBlank((String)"reportDirname", (String)reportDirname);
        File dir = new File(reportDirname);
        dir.mkdirs();
        IoUtil.save((File)new File(dir, "ca.der"), (byte[])caCertBytes);
        this.missingWriter = new BufferedWriter(new FileWriter(new File(dir, "missing")));
        this.unexpectedWriter = new BufferedWriter(new FileWriter(new File(dir, "unexpected")));
        this.diffWriter = new BufferedWriter(new FileWriter(new File(dir, "diff")));
        this.goodWriter = new BufferedWriter(new FileWriter(new File(dir, "good")));
        this.errorWriter = new BufferedWriter(new FileWriter(new File(dir, "error")));
        this.start();
    }

    public void start() {
        this.startTime = new Date();
    }

    public String getReportDirname() {
        return this.reportDirname;
    }

    public void addMissing(BigInteger serialNumber) throws IOException {
        this.numMissing.incrementAndGet();
        DigestDiffReporter.writeSerialNumberLine(this.missingWriter, serialNumber);
    }

    public void addGood(BigInteger serialNumber) throws IOException {
        this.numGood.incrementAndGet();
        DigestDiffReporter.writeSerialNumberLine(this.goodWriter, serialNumber);
    }

    public void addUnexpected(BigInteger serialNumber) throws IOException {
        this.numUnexpected.incrementAndGet();
        DigestDiffReporter.writeSerialNumberLine(this.unexpectedWriter, serialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiff(DigestEntry refCert, DigestEntry targetCert) throws IOException {
        ParamUtil.requireNonNull((String)"refCert", (Object)refCert);
        ParamUtil.requireNonNull((String)"targetCert", (Object)targetCert);
        if (refCert.getSerialNumber().equals(targetCert.getSerialNumber())) {
            throw new IllegalArgumentException("refCert and targetCert are not of the same serialNumber");
        }
        this.numDiff.incrementAndGet();
        String msg = StringUtil.concat((String)refCert.getSerialNumber().toString(16), (String[])new String[]{"\t", refCert.encodedOmitSeriaNumber(), "\t", targetCert.encodedOmitSeriaNumber(), "\n"});
        BufferedWriter bufferedWriter = this.diffWriter;
        synchronized (bufferedWriter) {
            this.diffWriter.write(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(String errorMessage) throws IOException {
        ParamUtil.requireNonNull((String)"errorMessage", (Object)errorMessage);
        this.numError.incrementAndGet();
        String msg = StringUtil.concat((String)errorMessage, (String[])new String[]{"\n"});
        BufferedWriter bufferedWriter = this.errorWriter;
        synchronized (bufferedWriter) {
            this.errorWriter.write(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNoCaMatch() throws IOException {
        BufferedWriter bufferedWriter = this.errorWriter;
        synchronized (bufferedWriter) {
            this.errorWriter.write("could not find corresponding CA in target to diff\n");
        }
    }

    public void close() {
        DigestDiffReporter.closeWriter(this.missingWriter);
        DigestDiffReporter.closeWriter(this.unexpectedWriter);
        DigestDiffReporter.closeWriter(this.diffWriter);
        DigestDiffReporter.closeWriter(this.goodWriter);
        DigestDiffReporter.closeWriter(this.errorWriter);
        int sum = this.numGood.get() + this.numDiff.get() + this.numMissing.get() + this.numUnexpected.get() + this.numError.get();
        Date now = new Date();
        int durationSec = (int)((now.getTime() - this.startTime.getTime()) / 1000L);
        String speedStr = durationSec > 0 ? StringUtil.formatAccount((long)(sum / durationSec), (boolean)false) + " /s" : "--";
        String str = StringUtil.concatObjectsCap((int)200, (Object)"      sum : ", (Object[])new Object[]{StringUtil.formatAccount((long)sum, (boolean)false), "\n      good: ", StringUtil.formatAccount((long)this.numGood.get(), (boolean)false), "\n      diff: ", StringUtil.formatAccount((long)this.numDiff.get(), (boolean)false), "\n   missing: ", StringUtil.formatAccount((long)this.numMissing.get(), (boolean)false), "\nunexpected: ", StringUtil.formatAccount((long)this.numUnexpected.get(), (boolean)false), "\n     error: ", StringUtil.formatAccount((long)this.numError.get(), (boolean)false), "\n  duration: ", StringUtil.formatTime((long)durationSec, (boolean)false), "\nstart time: ", this.startTime, "\n  end time: ", now, "\n     speed: ", speedStr, "\n"});
        try {
            IoUtil.save((String)(this.reportDirname + File.separator + "overview.txt"), (byte[])str.getBytes());
        }
        catch (IOException ex) {
            System.out.println("Could not write overview.txt with following content\n" + str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSerialNumberLine(BufferedWriter writer, BigInteger serialNumber) throws IOException {
        String msg = StringUtil.concat((String)serialNumber.toString(16), (String[])new String[]{"\n"});
        BufferedWriter bufferedWriter = writer;
        synchronized (bufferedWriter) {
            writer.write(msg);
        }
    }

    private static void closeWriter(Writer writer) {
        try {
            writer.close();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not close writer");
        }
    }
}

