/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.diffdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.diffdb.DigestDiff;
import org.xipki.ca.dbtool.port.DbPortWorker;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class DigestDiffWorker
extends DbPortWorker {
    private static final Logger LOG = LoggerFactory.getLogger(DigestDiffWorker.class);
    private final boolean revokedOnly;
    private final DataSourceWrapper refDatasource;
    private final Set<byte[]> includeCaCerts;
    private final DataSourceWrapper targetDatasource;
    private final String reportDir;
    private final int numCertsPerSelect;
    private final int numThreads;

    public DigestDiffWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, boolean revokedOnly, String refDbConfFile, String targetDbConfFile, String reportDirName, int numCertsPerSelect, int numThreads, Set<byte[]> includeCaCerts) throws PasswordResolverException, IOException {
        this.reportDir = reportDirName;
        this.numThreads = ParamUtil.requireMin((String)"numThreads", (int)numThreads, (int)1);
        this.numCertsPerSelect = numCertsPerSelect;
        this.includeCaCerts = includeCaCerts;
        this.revokedOnly = revokedOnly;
        File file = new File(reportDirName);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            if (!file.isDirectory()) {
                throw new IOException(reportDirName + " is not a folder");
            }
            if (!file.canWrite()) {
                throw new IOException(reportDirName + " is not writable");
            }
        }
        String[] children = file.list();
        if (children != null && children.length > 0) {
            throw new IOException(reportDirName + " is not empty");
        }
        Properties props = DbPorter.getDbConfProperties(new FileInputStream(IoUtil.expandFilepath((String)targetDbConfFile)));
        this.targetDatasource = datasourceFactory.createDataSource("ds-" + targetDbConfFile, props, passwordResolver);
        Properties refProps = DbPorter.getDbConfProperties(new FileInputStream(IoUtil.expandFilepath((String)refDbConfFile)));
        this.refDatasource = datasourceFactory.createDataSource("ds-" + refDbConfFile, refProps, passwordResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run0() throws Exception {
        long start = System.currentTimeMillis();
        try {
            DigestDiff diff = new DigestDiff(this.refDatasource, this.targetDatasource, this.reportDir, this.revokedOnly, this.stopMe, this.numCertsPerSelect, this.numThreads);
            diff.setIncludeCaCerts(this.includeCaCerts);
            diff.diff();
        }
        finally {
            try {
                this.refDatasource.close();
            }
            catch (Throwable th) {
                LOG.error("refDatasource.close()", th);
            }
            try {
                this.targetDatasource.close();
            }
            catch (Throwable th) {
                LOG.error("datasource.close()", th);
            }
            long end = System.currentTimeMillis();
            System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
        }
    }
}

