/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.diffdb;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

class DigestEntry {
    private final BigInteger serialNumber;
    private final boolean revoked;
    private final Integer revReason;
    private final Long revTime;
    private final Long revInvTime;
    private final String base64HashValue;

    public DigestEntry(BigInteger serialNumber, boolean revoked, Integer revReason, Long revTime, Long revInvTime, String base64HashValue) {
        ParamUtil.requireNonNull((String)"base64HashValue", (Object)base64HashValue);
        if (revoked) {
            ParamUtil.requireNonNull((String)"revReason", (Object)revReason);
            ParamUtil.requireNonNull((String)"revTime", (Object)revTime);
        }
        this.base64HashValue = base64HashValue;
        this.serialNumber = serialNumber;
        this.revoked = revoked;
        this.revReason = revReason;
        this.revTime = revTime;
        this.revInvTime = revInvTime;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public int getRevReason() {
        return this.revReason;
    }

    public Long getRevTime() {
        return this.revTime;
    }

    public Long getRevInvTime() {
        return this.revInvTime;
    }

    public String getBase64HashValue() {
        return this.base64HashValue;
    }

    public String toString() {
        return this.encoded();
    }

    public String encodedOmitSeriaNumber() {
        return this.encoded(false);
    }

    public String encoded() {
        return this.encoded(true);
    }

    private String encoded(boolean withSerialNumber) {
        return StringUtil.concatObjects((Object)(withSerialNumber ? this.serialNumber.toString(16) + ";" : ""), (Object[])new Object[]{this.base64HashValue, ";", this.revoked ? "1" : "0", ";", this.revReason != null ? this.revReason : "", ";", this.revTime != null ? this.revTime : "", ";", this.revInvTime != null ? this.revInvTime : ""});
    }

    public boolean contentEquals(DigestEntry obj) {
        if (obj == null) {
            return false;
        }
        if (this.serialNumber != obj.serialNumber) {
            return false;
        }
        if (this.revoked != obj.revoked) {
            return false;
        }
        if (!DigestEntry.equals(this.revReason, obj.revReason)) {
            return false;
        }
        if (!DigestEntry.equals(this.revTime, obj.revTime)) {
            return false;
        }
        if (!DigestEntry.equals(this.revInvTime, obj.revInvTime)) {
            return false;
        }
        return DigestEntry.equals(this.base64HashValue, obj.base64HashValue);
    }

    public static DigestEntry decode(String encoded) {
        ParamUtil.requireNonNull((String)"encoded", (Object)encoded);
        List<Integer> indexes = DigestEntry.getIndexes(encoded);
        if (indexes.size() != 5) {
            throw new IllegalArgumentException("invalid DbDigestEntry: " + encoded);
        }
        String str = encoded.substring(0, indexes.get(0));
        BigInteger serialNumber = new BigInteger(str, 16);
        String sha1Fp = encoded.substring(indexes.get(0) + 1, indexes.get(1));
        int idx = 1;
        str = encoded.substring(indexes.get(idx) + 1, indexes.get(idx + 1));
        boolean revoked = !"0".equals(str);
        Integer revReason = null;
        Long revTime = null;
        Long revInvTime = null;
        if (revoked) {
            str = encoded.substring(indexes.get(++idx) + 1, indexes.get(idx + 1));
            revReason = Integer.parseInt(str);
            str = encoded.substring(indexes.get(++idx) + 1, indexes.get(idx + 1));
            revTime = Long.parseLong(str);
            if ((str = encoded.substring(indexes.get(++idx) + 1)).length() != 0) {
                revInvTime = Long.parseLong(str);
            }
        }
        return new DigestEntry(serialNumber, revoked, revReason, revTime, revInvTime, sha1Fp);
    }

    private static List<Integer> getIndexes(String encoded) {
        ArrayList<Integer> ret = new ArrayList<Integer>(6);
        for (int i = 0; i < encoded.length(); ++i) {
            if (encoded.charAt(i) != ';') continue;
            ret.add(i);
        }
        return ret;
    }

    private static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }
}

