/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.diffdb;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.DbToolBase;
import org.xipki.ca.dbtool.diffdb.CertsBundle;
import org.xipki.ca.dbtool.diffdb.DbControl;
import org.xipki.ca.dbtool.diffdb.DigestEntry;
import org.xipki.ca.dbtool.diffdb.IdentifiedDigestEntry;
import org.xipki.ca.dbtool.diffdb.QueueEntry;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

class RefDigestReader {
    private static final Logger LOG = LoggerFactory.getLogger(RefDigestReader.class);
    private final BlockingQueue<QueueEntry> outQueue;
    private final DataSourceWrapper datasource;
    private final X509Certificate caCert;
    private final AtomicBoolean stopMe;
    private final int totalAccount;
    private final String caSubjectName;
    private final AtomicBoolean endReached = new AtomicBoolean(false);
    private long lastProcessedId;
    private int caId;
    private ExecutorService executor;
    private Retriever retriever;
    private Connection conn;
    private String selectCertSql;
    private DbControl dbControl;
    private HashAlgo certhashAlgo;

    private RefDigestReader(DataSourceWrapper datasource, X509Certificate caCert, int totalAccount, long minId, int numBlocksToRead, AtomicBoolean stopMe) throws Exception {
        this.datasource = (DataSourceWrapper)ParamUtil.requireNonNull((String)"datasource", (Object)datasource);
        this.caCert = (X509Certificate)ParamUtil.requireNonNull((String)"caCert", (Object)caCert);
        this.stopMe = (AtomicBoolean)ParamUtil.requireNonNull((String)"stopMe", (Object)stopMe);
        this.totalAccount = totalAccount;
        this.caSubjectName = X509Util.getRfc4519Name((X500Principal)caCert.getSubjectX500Principal());
        this.lastProcessedId = minId - 1L;
        this.outQueue = new ArrayBlockingQueue<QueueEntry>(numBlocksToRead);
    }

    private void init(DbControl dbControl, HashAlgo certhashAlgo, int caId, int numPerSelect) throws Exception {
        String coreSql;
        this.caId = caId;
        this.conn = this.datasource.getConnection();
        this.dbControl = dbControl;
        this.certhashAlgo = certhashAlgo;
        if (dbControl == DbControl.XIPKI_OCSP_v4) {
            String certHashAlgoInDb = (String)this.datasource.getFirstValue(null, "DBSCHEMA", "VALUE2", "NAME='CERTHASH_ALGO'", String.class);
            if (certhashAlgo != HashAlgo.getInstance((String)certHashAlgoInDb)) {
                throw new IllegalArgumentException("certHashAlgo in parameter (" + certhashAlgo + ") != in DB (" + certHashAlgoInDb + ")");
            }
            coreSql = StringUtil.concat((String)"ID,SN,REV,RR,RT,RIT,HASH FROM CERT WHERE IID=", (String[])new String[]{Integer.toString(caId), " AND ID>=?"});
        } else if (dbControl == DbControl.XIPKI_CA_v4) {
            coreSql = StringUtil.concat((String)"ID,SN,REV,RR,RT,RIT,", (String[])new String[]{certhashAlgo == HashAlgo.SHA1 ? "SHA1" : "CERT", " FROM CERT WHERE CA_ID=", Integer.toString(caId), " AND ID>=?"});
        } else {
            throw new IllegalArgumentException("unknown dbControl " + (Object)((Object)dbControl));
        }
        this.selectCertSql = this.datasource.buildSelectFirstSql(numPerSelect, "ID ASC", coreSql);
        try {
            this.retriever = new Retriever();
            this.executor = Executors.newFixedThreadPool(1);
            this.executor.execute(this.retriever);
        }
        catch (Exception ex) {
            LOG.error("could not initialize DigestReader", (Throwable)ex);
            this.close();
            throw new Exception("could not initialize me");
        }
    }

    public int getCaId() {
        return this.caId;
    }

    public static RefDigestReader getInstance(DataSourceWrapper datasource, DbControl dbControl, HashAlgo certhashAlgo, int caId, int numBlocksToRead, int numPerSelect, AtomicBoolean stopMe) throws Exception {
        RefDigestReader refDigestReader;
        ParamUtil.requireNonNull((String)"datasource", (Object)datasource);
        Connection conn = datasource.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            String colCaId;
            String tblCa;
            stmt = datasource.createStatement(conn);
            if (dbControl == DbControl.XIPKI_OCSP_v4) {
                tblCa = "ISSUER";
                colCaId = "IID";
            } else if (dbControl == DbControl.XIPKI_CA_v4) {
                tblCa = "CA";
                colCaId = "CA_ID";
            } else {
                throw new IllegalArgumentException("unknown dbControl " + (Object)((Object)dbControl));
            }
            sql = "SELECT CERT FROM " + tblCa + " WHERE ID=" + caId;
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new IllegalArgumentException("no CA with id '" + caId + "' is available");
            }
            X509Certificate caCert = X509Util.parseCert((byte[])rs.getString("CERT").getBytes());
            rs.close();
            sql = "SELECT COUNT(*) FROM CERT WHERE " + colCaId + "=" + caId;
            rs = stmt.executeQuery(sql);
            int totalAccount = rs.next() ? rs.getInt(1) : 0;
            rs.close();
            sql = "SELECT MIN(ID) FROM CERT WHERE " + colCaId + "=" + caId;
            rs = stmt.executeQuery(sql);
            long minId = rs.next() ? rs.getLong(1) : 1L;
            RefDigestReader reader = new RefDigestReader(datasource, caCert, totalAccount, minId, numBlocksToRead, stopMe);
            reader.init(dbControl, certhashAlgo, caId, numPerSelect);
            refDigestReader = reader;
        }
        catch (SQLException ex) {
            try {
                throw datasource.translate(sql, ex);
            }
            catch (Throwable throwable) {
                DbToolBase.releaseResources(datasource, stmt, rs);
                throw throwable;
            }
        }
        DbToolBase.releaseResources(datasource, stmt, rs);
        return refDigestReader;
    }

    public X509Certificate getCaCert() {
        return this.caCert;
    }

    public String getCaSubjectName() {
        return this.caSubjectName;
    }

    public int getTotalAccount() {
        return this.totalAccount;
    }

    public synchronized CertsBundle nextCerts() throws Exception {
        if (this.endReached.get() && this.outQueue.isEmpty()) {
            return null;
        }
        QueueEntry next = null;
        while (next == null) {
            if (this.stopMe.get()) {
                return null;
            }
            next = this.outQueue.poll(1L, TimeUnit.SECONDS);
        }
        if (next instanceof QueueEntry.EndOfQueue) {
            this.endReached.set(true);
            return null;
        }
        if (!(next instanceof QueueEntry.DigestEntrySet)) {
            throw new RuntimeException("unknown QueueEntry type: " + next.getClass().getName());
        }
        QueueEntry.DigestEntrySet certSet = (QueueEntry.DigestEntrySet)next;
        if (certSet.getException() != null) {
            throw certSet.getException();
        }
        LinkedList<BigInteger> serialNumbers = new LinkedList<BigInteger>();
        HashMap<BigInteger, DigestEntry> certsMap = new HashMap<BigInteger, DigestEntry>();
        for (IdentifiedDigestEntry m : certSet.getEntries()) {
            BigInteger sn = m.getContent().getSerialNumber();
            serialNumbers.add(sn);
            certsMap.put(sn, m.getContent());
        }
        return new CertsBundle(certsMap, serialNumbers);
    }

    public void close() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    protected void releaseResources(Statement ps, ResultSet rs) {
        DbToolBase.releaseResources(this.datasource, ps, rs);
    }

    private class Retriever
    implements Runnable {
        private PreparedStatement selectCertStmt;
        private boolean endReached;

        Retriever() throws DataAccessException {
            try {
                this.selectCertStmt = RefDigestReader.this.datasource.prepareStatement(RefDigestReader.this.conn, RefDigestReader.this.selectCertSql);
            }
            catch (DataAccessException ex) {
                RefDigestReader.this.datasource.returnConnection(RefDigestReader.this.conn);
                throw ex;
            }
        }

        @Override
        public void run() {
            while (!this.endReached && !RefDigestReader.this.stopMe.get()) {
                try {
                    this.query();
                }
                catch (InterruptedException ex) {
                    LOG.error("InterruptedException: {}", (Object)ex.getMessage());
                }
            }
            RefDigestReader.this.releaseResources(this.selectCertStmt, null);
            RefDigestReader.this.datasource.returnConnection(RefDigestReader.this.conn);
            this.selectCertStmt = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void query() throws InterruptedException {
            long startId = RefDigestReader.this.lastProcessedId + 1L;
            QueueEntry.DigestEntrySet result = new QueueEntry.DigestEntrySet(startId);
            ResultSet rs = null;
            try {
                this.selectCertStmt.setLong(1, startId);
                rs = this.selectCertStmt.executeQuery();
                while (rs.next()) {
                    long id = rs.getLong("ID");
                    if (RefDigestReader.this.lastProcessedId < id) {
                        RefDigestReader.this.lastProcessedId = id;
                    }
                    String hash = RefDigestReader.this.dbControl == DbControl.XIPKI_OCSP_v4 ? rs.getString("HASH") : (RefDigestReader.this.certhashAlgo == HashAlgo.SHA1 ? rs.getString("SHA1") : RefDigestReader.this.certhashAlgo.base64Hash(Base64.decodeFast((String)rs.getString("CERT"))));
                    BigInteger serial = new BigInteger(rs.getString("SN"), 16);
                    boolean revoked = rs.getBoolean("REV");
                    Integer revReason = null;
                    Long revTime = null;
                    Long revInvTime = null;
                    if (revoked) {
                        revReason = rs.getInt("RR");
                        revTime = rs.getLong("RT");
                        revInvTime = rs.getLong("RIT");
                        if (revInvTime == 0L) {
                            revInvTime = null;
                        }
                    }
                    DigestEntry cert = new DigestEntry(serial, revoked, revReason, revTime, revInvTime, hash);
                    result.addEntry(new IdentifiedDigestEntry(cert, id));
                }
                RefDigestReader.this.releaseResources(null, rs);
            }
            catch (Exception ex2) {
                try {
                    DataAccessException ex2;
                    if (ex2 instanceof SQLException) {
                        ex2 = RefDigestReader.this.datasource.translate(RefDigestReader.this.selectCertSql, (SQLException)ex2);
                    }
                    result.setException((Exception)((Object)ex2));
                    RefDigestReader.this.releaseResources(null, rs);
                }
                catch (Throwable throwable) {
                    RefDigestReader.this.releaseResources(null, rs);
                    throw throwable;
                }
            }
            if (result.getEntries().isEmpty()) {
                this.endReached = true;
                RefDigestReader.this.outQueue.put(QueueEntry.END_OF_QUEUE);
            } else {
                RefDigestReader.this.outQueue.put(result);
            }
        }
    }
}

