/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class DbPortFileNameIterator
implements Iterator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(DbPortFileNameIterator.class);
    private BufferedReader reader;
    private String nextFilename;

    public DbPortFileNameIterator(String filename) throws IOException {
        ParamUtil.requireNonNull((String)"filename", (Object)filename);
        this.reader = new BufferedReader(new FileReader(filename));
        this.nextFilename = this.readNextFilenameLine();
    }

    @Override
    public boolean hasNext() {
        return this.nextFilename != null;
    }

    @Override
    public String next() {
        String str = this.nextFilename;
        this.nextFilename = null;
        try {
            this.nextFilename = this.readNextFilenameLine();
        }
        catch (IOException ex) {
            throw new RuntimeException("could not read next file name");
        }
        return str;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not close reader");
        }
    }

    private String readNextFilenameLine() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            if (StringUtil.isBlank((String)(line = line.trim())) || line.startsWith("#") || !line.endsWith(".zip")) continue;
            return line;
        }
        return null;
    }
}

