/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xipki.ca.dbtool.DbSchemaInfo;
import org.xipki.ca.dbtool.DbToolBase;
import org.xipki.ca.dbtool.jaxb.ca.FileOrBinaryType;
import org.xipki.ca.dbtool.jaxb.ca.FileOrValueType;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xml.sax.SAXException;

public class DbPorter
extends DbToolBase {
    public static final String FILENAME_CA_CONFIGURATION = "ca-configuration.xml";
    public static final String FILENAME_CA_CERTSTORE = "ca-certstore.xml";
    public static final String FILENAME_OCSP_CERTSTORE = "ocsp-certstore.xml";
    public static final String DIRNAME_CRL = "crl";
    public static final String DIRNAME_CERT = "cert";
    public static final String PREFIX_FILENAME_CERTS = "certs-";
    public static final String EXPORT_PROCESS_LOG_FILENAME = "export.process";
    public static final String IMPORT_PROCESS_LOG_FILENAME = "import.process";
    public static final String IMPORT_TO_OCSP_PROCESS_LOG_FILENAME = "import-to-ocsp.process";
    public static final int VERSION = 1;
    protected final int dbSchemaVersion;
    protected final int maxX500nameLen;
    protected final DbSchemaInfo dbSchemaInfo;

    public DbPorter(DataSourceWrapper datasource, String baseDir, AtomicBoolean stopMe) throws DataAccessException {
        super(datasource, baseDir, stopMe);
        this.dbSchemaInfo = new DbSchemaInfo(datasource);
        this.dbSchemaVersion = Integer.parseInt(this.dbSchemaInfo.getVariableValue("VERSION"));
        this.maxX500nameLen = Integer.parseInt(this.dbSchemaInfo.getVariableValue("X500NAME_MAXLEN"));
    }

    protected FileOrValueType buildFileOrValue(String content, String fileName) throws IOException {
        if (content == null) {
            return null;
        }
        ParamUtil.requireNonNull((String)"fileName", (Object)fileName);
        FileOrValueType ret = new FileOrValueType();
        if (content.length() < 256) {
            ret.setValue(content);
            return ret;
        }
        File file = new File(this.baseDir, fileName);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        IoUtil.save((File)file, (byte[])content.getBytes("UTF-8"));
        ret.setFile(fileName);
        return ret;
    }

    protected String value(FileOrValueType fileOrValue) throws IOException {
        if (fileOrValue == null) {
            return null;
        }
        if (fileOrValue.getValue() != null) {
            return fileOrValue.getValue();
        }
        File file = new File(this.baseDir, fileOrValue.getFile());
        return new String(IoUtil.read((File)file), "UTF-8");
    }

    protected FileOrBinaryType buildFileOrBase64Binary(String base64Content, String fileName) throws IOException {
        if (base64Content == null) {
            return null;
        }
        return this.buildFileOrBinary(Base64.decode((String)base64Content), fileName);
    }

    protected FileOrBinaryType buildFileOrBinary(byte[] content, String fileName) throws IOException {
        if (content == null) {
            return null;
        }
        ParamUtil.requireNonNull((String)"fileName", (Object)fileName);
        FileOrBinaryType ret = new FileOrBinaryType();
        if (content.length < 256) {
            ret.setBinary(content);
            return ret;
        }
        File file = new File(this.baseDir, fileName);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        IoUtil.save((File)file, (byte[])content);
        ret.setFile(fileName);
        return ret;
    }

    protected byte[] binary(FileOrBinaryType fileOrValue) throws IOException {
        if (fileOrValue == null) {
            return null;
        }
        if (fileOrValue.getBinary() != null) {
            return fileOrValue.getBinary();
        }
        File file = new File(this.baseDir, fileOrValue.getFile());
        return IoUtil.read((File)file);
    }

    public static final Schema retrieveSchema(String schemaPath) throws JAXBException {
        ParamUtil.requireNonNull((String)"schemaPath", (Object)schemaPath);
        URL schemaUrl = DbPorter.class.getResource(schemaPath);
        SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return schemaFact.newSchema(schemaUrl);
        }
        catch (SAXException ex) {
            throw new JAXBException("could not load schemas for the specified classes\nDetails:\n" + ex.getMessage());
        }
    }

    public static void echoToFile(String content, File file) throws IOException {
        ParamUtil.requireNonNull((String)"content", (Object)content);
        ParamUtil.requireNonNull((String)"file", (Object)file);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(content.getBytes());
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static enum CaDbEntryType {
        CERT("certs", "CERT", 1.0f),
        CRL("crls", "CRL", 0.1f),
        REQUEST("requests", "REQUEST", 0.1f),
        REQCERT("reqcerts", "REQCERT", 50.0f);

        private final String dirName;
        private final String tableName;
        private final float sqlBatchFactor;

        private CaDbEntryType(String dirName, String tableName, float sqlBatchFactor) {
            this.dirName = dirName;
            this.tableName = tableName;
            this.sqlBatchFactor = sqlBatchFactor;
        }

        public String getDirName() {
            return this.dirName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public float getSqlBatchFactor() {
            return this.sqlBatchFactor;
        }
    }

    public static enum OcspDbEntryType {
        CERT("certs", "CERT", 1.0f);

        private final String dirName;
        private final String tableName;
        private final float sqlBatchFactor;

        private OcspDbEntryType(String dirName, String tableName, float sqlBatchFactor) {
            this.dirName = dirName;
            this.tableName = tableName;
            this.sqlBatchFactor = sqlBatchFactor;
        }

        public String getDirName() {
            return this.dirName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public float getSqlBatchFactor() {
            return this.sqlBatchFactor;
        }
    }
}

