/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ca;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.validation.Schema;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.jaxb.ca.CertstoreType;
import org.xipki.ca.dbtool.jaxb.ca.DeltaCrlCacheEntryType;
import org.xipki.ca.dbtool.jaxb.ca.ObjectFactory;
import org.xipki.ca.dbtool.jaxb.ca.ToPublishType;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.xmlio.DbiXmlWriter;
import org.xipki.ca.dbtool.xmlio.ca.CertType;
import org.xipki.ca.dbtool.xmlio.ca.CertsWriter;
import org.xipki.ca.dbtool.xmlio.ca.CrlType;
import org.xipki.ca.dbtool.xmlio.ca.CrlsWriter;
import org.xipki.ca.dbtool.xmlio.ca.RequestCertType;
import org.xipki.ca.dbtool.xmlio.ca.RequestCertsWriter;
import org.xipki.ca.dbtool.xmlio.ca.RequestType;
import org.xipki.ca.dbtool.xmlio.ca.RequestsWriter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;
import org.xipki.util.XmlUtil;

class CaCertstoreDbExporter
extends DbPorter {
    private static final Logger LOG = LoggerFactory.getLogger(CaCertstoreDbExporter.class);
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;
    private final int numCertsInBundle;
    private final int numCertsPerSelect;
    private final boolean resume;

    CaCertstoreDbExporter(DataSourceWrapper datasource, String baseDir, int numCertsInBundle, int numCertsPerSelect, boolean resume, AtomicBoolean stopMe) throws DataAccessException, JAXBException {
        super(datasource, baseDir, stopMe);
        this.numCertsInBundle = ParamUtil.requireMin((String)"numCertsInBundle", (int)numCertsInBundle, (int)1);
        this.numCertsPerSelect = ParamUtil.requireMin((String)"numCertsPerSelect", (int)numCertsPerSelect, (int)1);
        this.resume = resume;
        Schema schema = DbPorter.retrieveSchema("/xsd/dbi-ca.xsd");
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        this.marshaller = jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        this.marshaller.setSchema(schema);
        this.unmarshaller = jaxbContext.createUnmarshaller();
        this.unmarshaller.setSchema(schema);
    }

    public void export() throws Exception {
        CertstoreType certstore;
        if (this.resume) {
            JAXBElement root;
            try {
                root = (JAXBElement)this.unmarshaller.unmarshal(new File(this.baseDir, "ca-certstore.xml"));
            }
            catch (JAXBException ex) {
                throw XmlUtil.convert((JAXBException)ex);
            }
            certstore = (CertstoreType)root.getValue();
            if (certstore.getVersion() > 1) {
                throw new Exception("could not continue with CertStore greater than 1: " + certstore.getVersion());
            }
        } else {
            certstore = new CertstoreType();
            certstore.setVersion(1);
        }
        Exception exception = null;
        System.out.println("exporting CA certstore from database");
        try {
            DbPorter.CaDbEntryType[] types;
            byte[] content;
            if (!this.resume) {
                this.exportPublishQueue(certstore);
                this.exportDeltaCrlCache(certstore);
            }
            File processLogFile = new File(this.baseDir, "export.process");
            Long idProcessedInLastProcess = null;
            DbPorter.CaDbEntryType typeProcessedInLastProcess = null;
            if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)) != null && content.length > 0) {
                DbPorter.CaDbEntryType[] str = new String(content);
                int idx = str.indexOf(58);
                String typeName = str.substring(0, idx).trim();
                typeProcessedInLastProcess = DbPorter.CaDbEntryType.valueOf(typeName);
                idProcessedInLastProcess = Long.parseLong(str.substring(idx + 1).trim());
            }
            if (DbPorter.CaDbEntryType.CRL == typeProcessedInLastProcess || typeProcessedInLastProcess == null) {
                exception = this.exportEntries(DbPorter.CaDbEntryType.CRL, certstore, processLogFile, idProcessedInLastProcess);
                typeProcessedInLastProcess = null;
                idProcessedInLastProcess = null;
            }
            for (DbPorter.CaDbEntryType type : types = new DbPorter.CaDbEntryType[]{DbPorter.CaDbEntryType.CERT, DbPorter.CaDbEntryType.REQUEST, DbPorter.CaDbEntryType.REQCERT}) {
                if (exception != null || type != typeProcessedInLastProcess && typeProcessedInLastProcess != null) continue;
                exception = this.exportEntries(type, certstore, processLogFile, idProcessedInLastProcess);
                typeProcessedInLastProcess = null;
                idProcessedInLastProcess = null;
            }
            JAXBElement<CertstoreType> root = new ObjectFactory().createCertstore(certstore);
            try {
                this.marshaller.marshal(root, new File(this.baseDir + File.separator + "ca-certstore.xml"));
            }
            catch (JAXBException ex) {
                throw XmlUtil.convert((JAXBException)ex);
            }
        }
        catch (Exception ex) {
            System.err.println("could not export CA certstore from database");
            exception = ex;
        }
        if (exception != null) {
            throw exception;
        }
        System.out.println(" exported CA certstore from database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception exportEntries(DbPorter.CaDbEntryType type, CertstoreType certstore, File processLogFile, Long idProcessedInLastProcess) {
        Exception exception;
        block5: {
            String tablesText = "table " + type.getTableName();
            File dir = new File(this.baseDir, type.getDirName());
            dir.mkdirs();
            FileOutputStream entriesFileOs = null;
            try {
                entriesFileOs = new FileOutputStream(new File(this.baseDir, type.getDirName() + ".mf"), true);
                this.exportEntries(type, certstore, processLogFile, entriesFileOs, idProcessedInLastProcess);
                exception = null;
                if (entriesFileOs == null) break block5;
            }
            catch (Exception ex) {
                Exception exception2;
                block6: {
                    try {
                        CaCertstoreDbExporter.deleteTmpFiles(this.baseDir, "tmp-");
                        System.err.println("\nexporting " + tablesText + " has been cancelled due to error,\nplease continue with the option '--resume'");
                        LOG.error("Exception", (Throwable)ex);
                        exception2 = ex;
                        if (entriesFileOs == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (entriesFileOs != null) {
                            IoUtil.closeStream(entriesFileOs);
                        }
                        throw throwable;
                    }
                    IoUtil.closeStream((OutputStream)entriesFileOs);
                }
                return exception2;
            }
            IoUtil.closeStream((OutputStream)entriesFileOs);
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntries(DbPorter.CaDbEntryType type, CertstoreType certstore, File processLogFile, FileOutputStream filenameListOs, Long idProcessedInLastProcess) throws Exception {
        String coreSql;
        int numProcessedBefore;
        int numEntriesPerSelect = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerSelect));
        int numEntriesPerZip = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsInBundle));
        File entriesDir = new File(this.baseDir, type.getDirName());
        String tableName = type.getTableName();
        switch (type) {
            case CERT: {
                numProcessedBefore = certstore.getCountCerts();
                coreSql = "ID,SN,CA_ID,PID,RID,RTYPE,TID,UID,EE,LUPDATE,REV,RR,RT,RIT,FP_RS,REQ_SUBJECT,CERT FROM CERT WHERE ID>=?";
                break;
            }
            case CRL: {
                numProcessedBefore = certstore.getCountCrls();
                coreSql = "ID,CA_ID,CRL FROM CRL WHERE ID>=?";
                break;
            }
            case REQUEST: {
                numProcessedBefore = certstore.getCountRequests();
                coreSql = "ID,LUPDATE,DATA FROM REQUEST WHERE ID>=?";
                break;
            }
            case REQCERT: {
                numProcessedBefore = certstore.getCountReqCerts();
                coreSql = "ID,RID,CID FROM REQCERT WHERE ID>=?";
                break;
            }
            default: {
                throw new RuntimeException("unknown CaDbEntryType " + (Object)((Object)type));
            }
        }
        Long minId = idProcessedInLastProcess != null ? idProcessedInLastProcess + 1L : this.min(tableName, "ID");
        String tablesText = "table " + type.getTableName();
        System.out.println("exporting " + tablesText + " from ID " + minId);
        long maxId = this.max(tableName, "ID");
        long total = this.count(tableName) - numProcessedBefore;
        if (total < 1L) {
            total = 1L;
        }
        String sql = this.datasource.buildSelectFirstSql(numEntriesPerSelect, "ID ASC", coreSql);
        DbiXmlWriter entriesInCurrentFile = CaCertstoreDbExporter.createWriter(type);
        PreparedStatement ps = this.prepareStatement(sql.toString());
        int numEntriesInCurrentFile = 0;
        int sum = 0;
        File currentEntriesZipFile = new File(this.baseDir, "tmp-" + type.getDirName() + "-" + System.currentTimeMillis() + ".zip");
        ZipOutputStream currentEntriesZip = CaCertstoreDbExporter.getZipOutputStream(currentEntriesZipFile);
        long minIdOfCurrentFile = -1L;
        long maxIdOfCurrentFile = -1L;
        ProcessLog processLog = new ProcessLog(total);
        processLog.printHeader();
        try {
            Long id = null;
            boolean interrupted = false;
            long lastMaxId = minId - 1L;
            while (true) {
                if (this.stopMe.get()) {
                    interrupted = true;
                    break;
                }
                ps.setLong(1, lastMaxId + 1L);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break;
                do {
                    ZipEntry certZipEntry;
                    String sha1;
                    if (lastMaxId < (id = Long.valueOf(rs.getLong("ID")))) {
                        lastMaxId = id;
                    }
                    if (minIdOfCurrentFile == -1L) {
                        minIdOfCurrentFile = id;
                    } else if (minIdOfCurrentFile > id) {
                        minIdOfCurrentFile = id;
                    }
                    if (maxIdOfCurrentFile == -1L) {
                        maxIdOfCurrentFile = id;
                    } else if (maxIdOfCurrentFile < id) {
                        maxIdOfCurrentFile = id;
                    }
                    if (DbPorter.CaDbEntryType.CERT == type) {
                        int userId;
                        byte[] certBytes = Base64.decodeFast((String)rs.getString("CERT"));
                        sha1 = HashAlgo.SHA1.hexHash(certBytes);
                        String certFileName = sha1 + ".der";
                        certZipEntry = new ZipEntry(certFileName);
                        currentEntriesZip.putNextEntry(certZipEntry);
                        try {
                            currentEntriesZip.write(certBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        CertType cert = new CertType();
                        cert.setId(id);
                        cert.setCaId(rs.getInt("CA_ID"));
                        cert.setEe(rs.getBoolean("EE"));
                        cert.setFile(certFileName);
                        long fpReqSubject = rs.getLong("FP_RS");
                        if (fpReqSubject != 0L) {
                            cert.setFpRs(fpReqSubject);
                            cert.setRs(rs.getString("REQ_SUBJECT"));
                        }
                        cert.setPid(rs.getInt("PID"));
                        cert.setReqType(rs.getInt("RTYPE"));
                        cert.setRid(rs.getInt("RID"));
                        cert.setSn(rs.getString("SN"));
                        String str = rs.getString("TID");
                        if (StringUtil.isNotBlank((String)str)) {
                            cert.setTid(str);
                        }
                        if ((userId = rs.getInt("UID")) != 0) {
                            cert.setUid(userId);
                        }
                        cert.setUpdate(rs.getLong("LUPDATE"));
                        boolean revoked = rs.getBoolean("REV");
                        cert.setRev(revoked);
                        if (revoked) {
                            cert.setRr(rs.getInt("RR"));
                            cert.setRt(rs.getLong("RT"));
                            long revInvTime = rs.getLong("RIT");
                            if (revInvTime != 0L) {
                                cert.setRit(revInvTime);
                            }
                        }
                        ((CertsWriter)entriesInCurrentFile).add(cert);
                    } else if (DbPorter.CaDbEntryType.CRL == type) {
                        byte[] crlBytes = Base64.decodeFast((String)rs.getString("CRL"));
                        X509CRL x509Crl = null;
                        try {
                            x509Crl = X509Util.parseCrl((byte[])crlBytes);
                        }
                        catch (CRLException ex) {
                            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse CRL with id " + id));
                            throw ex;
                        }
                        catch (Exception ex) {
                            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse CRL with id " + id));
                            throw new CRLException(ex.getMessage(), ex);
                        }
                        byte[] octetString = x509Crl.getExtensionValue(Extension.cRLNumber.getId());
                        if (octetString == null) {
                            LOG.warn("CRL without CRL number, ignore it");
                            continue;
                        }
                        String sha12 = HashAlgo.SHA1.hexHash(crlBytes);
                        String crlFilename = sha12 + ".crl";
                        ZipEntry certZipEntry2 = new ZipEntry(crlFilename);
                        currentEntriesZip.putNextEntry(certZipEntry2);
                        try {
                            currentEntriesZip.write(crlBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        CrlType crl = new CrlType();
                        crl.setId(id);
                        crl.setCaId(rs.getInt("CA_ID"));
                        byte[] extnValue = DEROctetString.getInstance((Object)octetString).getOctets();
                        BigInteger crlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                        crl.setCrlNo(crlNumber.toString());
                        crl.setFile(crlFilename);
                        ((CrlsWriter)entriesInCurrentFile).add(crl);
                    } else if (DbPorter.CaDbEntryType.REQUEST == type) {
                        byte[] dataBytes = Base64.decodeFast((String)rs.getString("DATA"));
                        sha1 = HashAlgo.SHA1.hexHash(dataBytes);
                        String dataFilename = sha1 + ".req";
                        certZipEntry = new ZipEntry(dataFilename);
                        currentEntriesZip.putNextEntry(certZipEntry);
                        try {
                            currentEntriesZip.write(dataBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        RequestType entry = new RequestType();
                        entry.setId(id);
                        entry.setUpdate(rs.getLong("LUPDATE"));
                        entry.setFile(dataFilename);
                        ((RequestsWriter)entriesInCurrentFile).add(entry);
                    } else if (DbPorter.CaDbEntryType.REQCERT == type) {
                        RequestCertType entry = new RequestCertType();
                        entry.setId(id);
                        entry.setCid(rs.getLong("CID"));
                        entry.setRid(rs.getLong("RID"));
                        ((RequestCertsWriter)entriesInCurrentFile).add(entry);
                    } else {
                        throw new RuntimeException("unknown CaDbEntryType " + (Object)((Object)type));
                    }
                    ++sum;
                    if (++numEntriesInCurrentFile != numEntriesPerZip) continue;
                    String currentEntriesFilename = CaCertstoreDbExporter.buildFilename(type.getDirName() + "_", ".zip", minIdOfCurrentFile, maxIdOfCurrentFile, maxId);
                    this.finalizeZip(currentEntriesZip, "overview.xml", entriesInCurrentFile);
                    currentEntriesZipFile.renameTo(new File(entriesDir, currentEntriesFilename));
                    CaCertstoreDbExporter.writeLine(filenameListOs, currentEntriesFilename);
                    CaCertstoreDbExporter.setCount(type, certstore, numProcessedBefore + sum);
                    CaCertstoreDbExporter.echoToFile(tableName + ":" + Long.toString(id), processLogFile);
                    processLog.addNumProcessed((long)numEntriesInCurrentFile);
                    processLog.printStatus();
                    entriesInCurrentFile = CaCertstoreDbExporter.createWriter(type);
                    numEntriesInCurrentFile = 0;
                    minIdOfCurrentFile = -1L;
                    maxIdOfCurrentFile = -1L;
                    currentEntriesZipFile = new File(this.baseDir, "tmp-" + type.getDirName() + "-" + System.currentTimeMillis() + ".zip");
                    currentEntriesZip = CaCertstoreDbExporter.getZipOutputStream(currentEntriesZipFile);
                } while (rs.next());
                rs.close();
            }
            if (interrupted) {
                currentEntriesZip.close();
                throw new InterruptedException("interrupted by the user");
            }
            if (numEntriesInCurrentFile > 0) {
                this.finalizeZip(currentEntriesZip, "overview.xml", entriesInCurrentFile);
                String currentEntriesFilename = CaCertstoreDbExporter.buildFilename(type.getDirName() + "_", ".zip", minIdOfCurrentFile, maxIdOfCurrentFile, maxId);
                currentEntriesZipFile.renameTo(new File(entriesDir, currentEntriesFilename));
                CaCertstoreDbExporter.writeLine(filenameListOs, currentEntriesFilename);
                CaCertstoreDbExporter.setCount(type, certstore, numProcessedBefore + sum);
                if (id != null) {
                    CaCertstoreDbExporter.echoToFile(Long.toString(id), processLogFile);
                }
                processLog.addNumProcessed((long)numEntriesInCurrentFile);
            } else {
                currentEntriesZip.close();
                currentEntriesZipFile.delete();
            }
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
        finally {
            this.releaseResources(ps, null);
        }
        processLog.printTrailer();
        processLogFile.delete();
        System.out.println(" exported " + sum + " entries from " + tablesText);
    }

    private void exportPublishQueue(CertstoreType certstore) throws DataAccessException {
        System.out.println("exporting table PUBLISHQUEUE");
        String sql = "SELECT CID,PID,CA_ID FROM PUBLISHQUEUE WHERE CID>=? AND CID<? ORDER BY CID ASC";
        int minId = (int)this.min("PUBLISHQUEUE", "CID");
        int maxId = (int)this.max("PUBLISHQUEUE", "CID");
        CertstoreType.PublishQueue queue = new CertstoreType.PublishQueue();
        certstore.setPublishQueue(queue);
        if (maxId == 0) {
            System.out.println(" exported table PUBLISHQUEUE");
            return;
        }
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSet rs = null;
        List<ToPublishType> list = queue.getTop();
        int n = 500;
        try {
            for (int i = minId; i <= maxId; i += 500) {
                ps.setInt(1, i);
                ps.setInt(2, i + 500);
                rs = ps.executeQuery();
                while (rs.next()) {
                    ToPublishType toPub = new ToPublishType();
                    toPub.setPubId(rs.getInt("PID"));
                    toPub.setCertId(rs.getInt("CID"));
                    toPub.setCaId(rs.getInt("CA_ID"));
                    list.add(toPub);
                }
            }
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(ps, rs);
        }
        System.out.println(" exported table PUBLISHQUEUE");
    }

    private void exportDeltaCrlCache(CertstoreType certstore) throws DataAccessException {
        System.out.println("exporting table DELTACRL_CACHE");
        String sql = "SELECT SN,CA_ID FROM DELTACRL_CACHE";
        CertstoreType.DeltaCrlCache deltaCache = new CertstoreType.DeltaCrlCache();
        certstore.setDeltaCrlCache(deltaCache);
        PreparedStatement ps = this.prepareStatement("SELECT SN,CA_ID FROM DELTACRL_CACHE");
        ResultSet rs = null;
        List<DeltaCrlCacheEntryType> list = deltaCache.getEntry();
        try {
            rs = ps.executeQuery();
            while (rs.next()) {
                DeltaCrlCacheEntryType entry = new DeltaCrlCacheEntryType();
                entry.setCaId(rs.getInt("CA_ID"));
                entry.setSerial(rs.getString("SN"));
                list.add(entry);
            }
        }
        catch (SQLException ex) {
            throw this.translate("SELECT SN,CA_ID FROM DELTACRL_CACHE", ex);
        }
        finally {
            this.releaseResources(ps, rs);
        }
        System.out.println(" exported table DELTACRL_CACHE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeZip(ZipOutputStream zipOutStream, String filename, DbiXmlWriter os) throws IOException, XMLStreamException {
        ZipEntry certZipEntry = new ZipEntry(filename);
        zipOutStream.putNextEntry(certZipEntry);
        try {
            os.rewriteToZipStream(zipOutStream);
        }
        finally {
            zipOutStream.closeEntry();
        }
        zipOutStream.close();
    }

    private static DbiXmlWriter createWriter(DbPorter.CaDbEntryType type) throws IOException, XMLStreamException {
        switch (type) {
            case CERT: {
                return new CertsWriter();
            }
            case CRL: {
                return new CrlsWriter();
            }
            case REQUEST: {
                return new RequestsWriter();
            }
            case REQCERT: {
                return new RequestCertsWriter();
            }
        }
        throw new RuntimeException("unknown CaDbEntryType " + (Object)((Object)type));
    }

    private static void setCount(DbPorter.CaDbEntryType type, CertstoreType certstore, int num) {
        switch (type) {
            case CERT: {
                certstore.setCountCerts(num);
                break;
            }
            case CRL: {
                certstore.setCountCrls(num);
                break;
            }
            case REQUEST: {
                certstore.setCountRequests(num);
                break;
            }
            case REQCERT: {
                certstore.setCountReqCerts(num);
                break;
            }
            default: {
                throw new RuntimeException("unknown CaDbEntryType " + (Object)((Object)type));
            }
        }
    }
}

