/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ca;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.jaxb.ca.CertstoreType;
import org.xipki.ca.dbtool.jaxb.ca.ObjectFactory;
import org.xipki.ca.dbtool.port.DbPortFileNameIterator;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.xmlio.DbiXmlReader;
import org.xipki.ca.dbtool.xmlio.IdentifidDbObjectType;
import org.xipki.ca.dbtool.xmlio.InvalidDataObjectException;
import org.xipki.ca.dbtool.xmlio.ca.CertType;
import org.xipki.ca.dbtool.xmlio.ca.CertsReader;
import org.xipki.ca.dbtool.xmlio.ca.CrlType;
import org.xipki.ca.dbtool.xmlio.ca.CrlsReader;
import org.xipki.ca.dbtool.xmlio.ca.RequestCertType;
import org.xipki.ca.dbtool.xmlio.ca.RequestCertsReader;
import org.xipki.ca.dbtool.xmlio.ca.RequestType;
import org.xipki.ca.dbtool.xmlio.ca.RequestsReader;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.FpIdCalculator;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;
import org.xipki.util.XmlUtil;

class CaCertstoreDbImporter
extends DbPorter {
    private static final Logger LOG = LoggerFactory.getLogger(CaCertstoreDbImporter.class);
    private static final String SQL_ADD_CERT = "INSERT INTO CERT (ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,NBEFORE,NAFTER,REV,RR,RT,RIT,PID,CA_ID,RID,UID,FP_K,EE,RTYPE,TID,SHA1,REQ_SUBJECT,CERT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_ADD_CRL = "INSERT INTO CRL (ID,CA_ID,CRL_NO,THISUPDATE,NEXTUPDATE,DELTACRL,BASECRL_NO,CRL) VALUES (?,?,?,?,?,?,?,?)";
    private static final String SQL_ADD_REQUEST = "INSERT INTO REQUEST (ID,LUPDATE,DATA) VALUES (?,?,?)";
    private static final String SQL_ADD_REQCERT = "INSERT INTO REQCERT (ID,RID,CID) VALUES (?,?,?)";
    private final Unmarshaller unmarshaller;
    private final boolean resume;
    private final int numCertsPerCommit;

    CaCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, int numCertsPerCommit, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
        this.numCertsPerCommit = ParamUtil.requireMin((String)"numCertsPerCommit", (int)numCertsPerCommit, (int)1);
        this.resume = resume;
        File processLogFile = new File(this.baseDir, "import.process");
        if (resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        this.unmarshaller = jaxbContext.createUnmarshaller();
        this.unmarshaller.setSchema(DbPorter.retrieveSchema("/xsd/dbi-ca.xsd"));
    }

    public void importToDb() throws Exception {
        CertstoreType certstore;
        try {
            JAXBElement root = (JAXBElement)this.unmarshaller.unmarshal(new File(this.baseDir, "ca-certstore.xml"));
            certstore = (CertstoreType)root.getValue();
        }
        catch (JAXBException ex) {
            throw XmlUtil.convert((JAXBException)ex);
        }
        if (certstore.getVersion() > 1) {
            throw new Exception("could not import Certstore greater than 1: " + certstore.getVersion());
        }
        File processLogFile = new File(this.baseDir, "import.process");
        System.out.println("importing CA certstore to database");
        try {
            byte[] content;
            if (!this.resume) {
                this.dropIndexes();
            }
            Enum typeProcessedInLastProcess = null;
            Integer numProcessedInLastProcess = null;
            Long idProcessedInLastProcess = null;
            if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)) != null && content.length > 5) {
                String str = new String(content);
                StringTokenizer st = new StringTokenizer(str, ":");
                String type = st.nextToken();
                typeProcessedInLastProcess = DbPorter.CaDbEntryType.valueOf(type);
                numProcessedInLastProcess = Integer.parseInt(st.nextToken());
                idProcessedInLastProcess = Long.parseLong(st.nextToken());
            }
            boolean entriesFinished = false;
            if (typeProcessedInLastProcess != null && idProcessedInLastProcess != null && idProcessedInLastProcess == -1L) {
                numProcessedInLastProcess = 0;
                idProcessedInLastProcess = 0L;
                switch (1.$SwitchMap$org$xipki$ca$dbtool$port$DbPorter$CaDbEntryType[typeProcessedInLastProcess.ordinal()]) {
                    case 1: {
                        typeProcessedInLastProcess = DbPorter.CaDbEntryType.CERT;
                        break;
                    }
                    case 2: {
                        typeProcessedInLastProcess = DbPorter.CaDbEntryType.REQUEST;
                        break;
                    }
                    case 3: {
                        typeProcessedInLastProcess = DbPorter.CaDbEntryType.REQCERT;
                        break;
                    }
                    case 4: {
                        entriesFinished = true;
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported CaDbEntryType " + typeProcessedInLastProcess);
                    }
                }
            }
            if (!entriesFinished) {
                DbPorter.CaDbEntryType[] types;
                Exception exception = null;
                if (DbPorter.CaDbEntryType.CRL == typeProcessedInLastProcess || typeProcessedInLastProcess == null) {
                    exception = this.importEntries(DbPorter.CaDbEntryType.CRL, certstore, processLogFile, numProcessedInLastProcess, idProcessedInLastProcess);
                    typeProcessedInLastProcess = null;
                    numProcessedInLastProcess = null;
                    idProcessedInLastProcess = null;
                }
                for (DbPorter.CaDbEntryType type : types = new DbPorter.CaDbEntryType[]{DbPorter.CaDbEntryType.CERT, DbPorter.CaDbEntryType.REQUEST, DbPorter.CaDbEntryType.REQCERT}) {
                    if (exception != null || type != typeProcessedInLastProcess && typeProcessedInLastProcess != null) continue;
                    exception = this.importEntries(type, certstore, processLogFile, numProcessedInLastProcess, idProcessedInLastProcess);
                }
                if (exception != null) {
                    throw exception;
                }
            }
            this.importPublishQueue(certstore.getPublishQueue());
            this.importDeltaCrlCache(certstore.getDeltaCrlCache());
            this.recoverIndexes();
            processLogFile.delete();
        }
        catch (Exception ex) {
            System.err.println("could not import CA certstore to database");
            throw ex;
        }
        System.out.println(" imported CA certstore to database");
    }

    /*
     * Exception decompiling
     */
    private void importPublishQueue(CertstoreType.PublishQueue publishQueue) throws DataAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void importDeltaCrlCache(CertstoreType.DeltaCrlCache deltaCrlCache) throws DataAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Exception importEntries(DbPorter.CaDbEntryType type, CertstoreType certstore, File processLogFile, Integer numProcessedInLastProcess, Long idProcessedInLastProcess) {
        String tablesText = "table " + type.getTableName();
        try {
            String sql;
            long total;
            int numProcessedBefore = 0;
            long minId = 1L;
            if (idProcessedInLastProcess != null) {
                minId = idProcessedInLastProcess + 1L;
                numProcessedBefore = numProcessedInLastProcess;
            }
            this.deleteFromTableWithLargerId(type.getTableName(), "ID", minId - 1L, LOG);
            switch (type) {
                case CERT: {
                    total = certstore.getCountCerts();
                    sql = SQL_ADD_CERT;
                    break;
                }
                case CRL: {
                    total = certstore.getCountCrls();
                    sql = SQL_ADD_CRL;
                    break;
                }
                case REQUEST: {
                    total = certstore.getCountRequests();
                    sql = SQL_ADD_REQUEST;
                    break;
                }
                case REQCERT: {
                    total = certstore.getCountReqCerts();
                    sql = SQL_ADD_REQCERT;
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported DbEntryType " + (Object)((Object)type));
                }
            }
            long remainingTotal = total - (long)numProcessedBefore;
            ProcessLog processLog = new ProcessLog(remainingTotal);
            System.out.println("importing entries to " + tablesText + " from ID " + minId);
            processLog.printHeader();
            DbPortFileNameIterator entriesFileIterator = null;
            PreparedStatement stmt = null;
            try {
                entriesFileIterator = new DbPortFileNameIterator(this.baseDir + File.separator + type.getDirName() + ".mf");
                stmt = this.prepareStatement(sql);
                while (entriesFileIterator.hasNext()) {
                    String entriesFile;
                    block22: {
                        entriesFile = this.baseDir + File.separator + type.getDirName() + File.separator + entriesFileIterator.next();
                        int fromIdx = entriesFile.indexOf(45);
                        int toIdx = entriesFile.indexOf(".zip");
                        if (fromIdx != -1 && toIdx != -1) {
                            try {
                                long toId = Integer.parseInt(entriesFile.substring(fromIdx + 1, toIdx));
                                if (toId < minId) {
                                    continue;
                                }
                                break block22;
                            }
                            catch (Exception ex) {
                                LOG.warn("invalid file name '{}', but will still be processed", (Object)entriesFile);
                                break block22;
                            }
                        }
                        LOG.warn("invalid file name '{}', but will still be processed", (Object)entriesFile);
                    }
                    try {
                        long lastId = this.importEntries(type, entriesFile, minId, processLogFile, processLog, numProcessedBefore, stmt, sql);
                        minId = lastId + 1L;
                    }
                    catch (Exception ex) {
                        System.err.println("\ncould not import entries from file " + entriesFile + ".\nplease continue with the option '--resume'");
                        LOG.error("Exception", (Throwable)ex);
                        Exception exception = ex;
                        this.releaseResources(stmt, null);
                        if (entriesFileIterator != null) {
                            entriesFileIterator.close();
                        }
                        return exception;
                    }
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null);
                if (entriesFileIterator != null) {
                    entriesFileIterator.close();
                }
                throw throwable;
            }
            this.releaseResources(stmt, null);
            if (entriesFileIterator != null) {
                entriesFileIterator.close();
            }
            processLog.printTrailer();
            CaCertstoreDbImporter.echoToFile((Object)((Object)type) + ":" + ((long)numProcessedBefore + processLog.numProcessed()) + ":-1", processLogFile);
            System.out.println(" imported " + processLog.numProcessed() + " entries");
            return null;
        }
        catch (Exception ex) {
            System.err.println("\nimporting " + tablesText + " has been cancelled due to error,\nplease continue with the option '--resume'");
            LOG.error("Exception", (Throwable)ex);
            return ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importEntries(DbPorter.CaDbEntryType type, String entriesZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, PreparedStatement stmt, String sql) throws Exception {
        DbiXmlReader entries;
        int numEntriesPerCommit = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerCommit));
        ZipFile zipFile = new ZipFile(new File(entriesZipFile));
        ZipEntry entriesXmlEntry = zipFile.getEntry("overview.xml");
        try {
            entries = CaCertstoreDbImporter.createReader(type, zipFile.getInputStream(entriesXmlEntry));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)entriesZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + entriesZipFile, (Throwable)e2);
            }
            throw ex;
        }
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulEntryId = 0L;
            while (entries.hasNext()) {
                boolean isLastBlock;
                ZipEntry zipEnty;
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                IdentifidDbObjectType entry = (IdentifidDbObjectType)entries.next();
                long id = entry.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                if (DbPorter.CaDbEntryType.CERT == type) {
                    TBSCertificate tbsCert;
                    CertType cert = (CertType)entry;
                    String filename = cert.getFile();
                    ZipEntry certZipEnty = zipFile.getEntry(filename);
                    byte[] encodedCert = IoUtil.read((InputStream)zipFile.getInputStream(certZipEnty));
                    try {
                        Certificate cc = Certificate.getInstance((Object)encodedCert);
                        tbsCert = cc.getTBSCertificate();
                    }
                    catch (RuntimeException ex) {
                        LOG.error("could not parse certificate in file {}", (Object)filename);
                        LOG.debug("could not parse certificate in file " + filename, (Throwable)ex);
                        throw new CertificateException(ex.getMessage(), ex);
                    }
                    byte[] encodedKey = tbsCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
                    String b64Sha1FpCert = HashAlgo.SHA1.base64Hash(encodedCert);
                    String subjectText = X509Util.cutX500Name((X500Name)tbsCert.getSubject(), (int)this.maxX500nameLen);
                    try {
                        int idx = 1;
                        stmt.setLong(idx++, id);
                        stmt.setLong(idx++, cert.getUpdate());
                        stmt.setString(idx++, tbsCert.getSerialNumber().getPositiveValue().toString(16));
                        stmt.setString(idx++, subjectText);
                        long fpSubject = X509Util.fpCanonicalizedName((X500Name)tbsCert.getSubject());
                        stmt.setLong(idx++, fpSubject);
                        if (cert.getFpRs() != null) {
                            stmt.setLong(idx++, cert.getFpRs());
                        } else {
                            stmt.setNull(idx++, -5);
                        }
                        stmt.setLong(idx++, tbsCert.getStartDate().getDate().getTime() / 1000L);
                        stmt.setLong(idx++, tbsCert.getEndDate().getDate().getTime() / 1000L);
                        CaCertstoreDbImporter.setBoolean(stmt, idx++, cert.getRev());
                        CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRr());
                        CaCertstoreDbImporter.setLong(stmt, idx++, cert.getRt());
                        CaCertstoreDbImporter.setLong(stmt, idx++, cert.getRit());
                        CaCertstoreDbImporter.setInt(stmt, idx++, cert.getPid());
                        CaCertstoreDbImporter.setInt(stmt, idx++, cert.getCaId());
                        CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRid());
                        CaCertstoreDbImporter.setInt(stmt, idx++, cert.getUid());
                        stmt.setLong(idx++, FpIdCalculator.hash((byte[])encodedKey));
                        Extension extension = tbsCert.getExtensions().getExtension(Extension.basicConstraints);
                        boolean ee = true;
                        if (extension != null) {
                            ASN1Encodable asn1 = extension.getParsedValue();
                            ee = !BasicConstraints.getInstance((Object)asn1).isCA();
                        }
                        stmt.setInt(idx++, ee ? 1 : 0);
                        stmt.setInt(idx++, cert.getReqType());
                        String tidS = null;
                        if (cert.getTid() != null) {
                            tidS = cert.getTid();
                        }
                        stmt.setString(idx++, tidS);
                        stmt.setString(idx++, b64Sha1FpCert);
                        stmt.setString(idx++, cert.getRs());
                        stmt.setString(idx++, Base64.encodeToString((byte[])encodedCert));
                        stmt.addBatch();
                    }
                    catch (SQLException ex) {
                        throw this.translate(sql, ex);
                    }
                }
                if (DbPorter.CaDbEntryType.CRL == type) {
                    CrlType crl = (CrlType)entry;
                    String filename = crl.getFile();
                    zipEnty = zipFile.getEntry(filename);
                    byte[] encodedCrl = IoUtil.read((InputStream)zipFile.getInputStream(zipEnty));
                    X509CRL x509crl = null;
                    try {
                        x509crl = X509Util.parseCrl((byte[])encodedCrl);
                    }
                    catch (Exception ex) {
                        LOG.error("could not parse CRL in file {}", (Object)filename);
                        LOG.debug("could not parse CRL in file " + filename, (Throwable)ex);
                        if (ex instanceof CRLException) {
                            throw (CRLException)ex;
                        }
                        throw new CRLException(ex.getMessage(), ex);
                    }
                    try {
                        byte[] octetString = x509crl.getExtensionValue(Extension.cRLNumber.getId());
                        if (octetString == null) {
                            LOG.warn("CRL without CRL number, ignore it");
                            continue;
                        }
                        byte[] extnValue = DEROctetString.getInstance((Object)octetString).getOctets();
                        BigInteger crlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                        BigInteger baseCrlNumber = null;
                        octetString = x509crl.getExtensionValue(Extension.deltaCRLIndicator.getId());
                        if (octetString != null) {
                            extnValue = DEROctetString.getInstance((Object)octetString).getOctets();
                            baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                        }
                        int idx = 1;
                        stmt.setLong(idx++, crl.getId());
                        stmt.setInt(idx++, crl.getCaId());
                        stmt.setLong(idx++, crlNumber.longValue());
                        stmt.setLong(idx++, x509crl.getThisUpdate().getTime() / 1000L);
                        if (x509crl.getNextUpdate() != null) {
                            stmt.setLong(idx++, x509crl.getNextUpdate().getTime() / 1000L);
                        } else {
                            stmt.setNull(idx++, 4);
                        }
                        if (baseCrlNumber == null) {
                            CaCertstoreDbImporter.setBoolean(stmt, idx++, false);
                            stmt.setNull(idx++, -5);
                        } else {
                            CaCertstoreDbImporter.setBoolean(stmt, idx++, true);
                            stmt.setLong(idx++, baseCrlNumber.longValue());
                        }
                        String str = Base64.encodeToString((byte[])encodedCrl);
                        stmt.setString(idx++, str);
                        stmt.addBatch();
                    }
                    catch (SQLException ex) {
                        System.err.println("could not import CRL with ID=" + crl.getId() + ", message: " + ex.getMessage());
                        throw ex;
                    }
                }
                if (DbPorter.CaDbEntryType.REQUEST == type) {
                    RequestType request = (RequestType)entry;
                    String filename = request.getFile();
                    zipEnty = zipFile.getEntry(filename);
                    byte[] encodedRequest = IoUtil.read((InputStream)zipFile.getInputStream(zipEnty));
                    try {
                        int idx = 1;
                        stmt.setLong(idx++, request.getId());
                        stmt.setLong(idx++, request.getUpdate());
                        stmt.setString(idx++, Base64.encodeToString((byte[])encodedRequest));
                        stmt.addBatch();
                    }
                    catch (SQLException ex) {
                        System.err.println("could not import REQUEST with ID=" + request.getId() + ", message: " + ex.getMessage());
                        throw ex;
                    }
                } else if (DbPorter.CaDbEntryType.REQCERT == type) {
                    RequestCertType reqCert = (RequestCertType)entry;
                    try {
                        int idx = 1;
                        stmt.setLong(idx++, reqCert.getId());
                        stmt.setLong(idx++, reqCert.getRid());
                        stmt.setLong(idx++, reqCert.getCid());
                        stmt.addBatch();
                    }
                    catch (SQLException ex) {
                        System.err.println("could not import REQUEST with ID=" + reqCert.getId() + ", message: " + ex.getMessage());
                        throw ex;
                    }
                } else {
                    throw new RuntimeException("Unknown CaDbEntryType " + (Object)((Object)type));
                }
                boolean bl = isLastBlock = !entries.hasNext();
                if (numEntriesInBatch <= 0 || numEntriesInBatch % numEntriesPerCommit != 0 && !isLastBlock) continue;
                try {
                    stmt.executeBatch();
                    this.commit("(commit import to CA)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteFromTableWithLargerId(type.getTableName(), "ID", id, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(sql, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulEntryId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                CaCertstoreDbImporter.echoToFile((Object)((Object)type) + ":" + ((long)numProcessedInLastProcess + processLog.numProcessed()) + ":" + lastSuccessfulEntryId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulEntryId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }

    private static DbiXmlReader createReader(DbPorter.CaDbEntryType type, InputStream is) throws XMLStreamException, InvalidDataObjectException {
        switch (type) {
            case CERT: {
                return new CertsReader(is);
            }
            case CRL: {
                return new CrlsReader(is);
            }
            case REQUEST: {
                return new RequestsReader(is);
            }
            case REQCERT: {
                return new RequestCertsReader(is);
            }
        }
        throw new RuntimeException("unknown CaDbEntryType " + (Object)((Object)type));
    }

    private void dropIndexes() throws DataAccessException {
        long start = System.currentTimeMillis();
        this.datasource.dropIndex(null, "CERT", "IDX_CA_FPK");
        this.datasource.dropIndex(null, "CERT", "IDX_CA_FPS");
        this.datasource.dropIndex(null, "CERT", "IDX_CA_FPRS");
        this.datasource.dropForeignKeyConstraint(null, "FK_CERT_CA1", "CERT");
        this.datasource.dropForeignKeyConstraint(null, "FK_CERT_USER1", "CERT");
        this.datasource.dropUniqueConstrain(null, "CONST_CA_SN", "CERT");
        this.datasource.dropForeignKeyConstraint(null, "FK_PUBLISHQUEUE_CERT1", "PUBLISHQUEUE");
        this.datasource.dropForeignKeyConstraint(null, "FK_REQCERT_REQ1", "REQCERT");
        this.datasource.dropForeignKeyConstraint(null, "FK_REQCERT_CERT1", "REQCERT");
        this.datasource.dropPrimaryKey(null, "PK_CERT", "CERT");
        this.datasource.dropPrimaryKey(null, "PK_REQUEST", "REQUEST");
        this.datasource.dropPrimaryKey(null, "PK_REQCERT", "REQCERT");
        long duration = (System.currentTimeMillis() - start) / 1000L;
        System.out.println(" dropped indexes in " + StringUtil.formatTime((long)duration, (boolean)false));
    }

    private void recoverIndexes() throws DataAccessException {
        long start = System.currentTimeMillis();
        this.datasource.addPrimaryKey(null, "PK_CERT", "CERT", new String[]{"ID"});
        this.datasource.addPrimaryKey(null, "PK_REQUEST", "REQUEST", new String[]{"ID"});
        this.datasource.addPrimaryKey(null, "PK_REQCERT", "REQCERT", new String[]{"ID"});
        this.datasource.addForeignKeyConstraint(null, "FK_PUBLISHQUEUE_CERT1", "PUBLISHQUEUE", "CID", "CERT", "ID", "CASCADE", "NO ACTION");
        this.datasource.addForeignKeyConstraint(null, "FK_CERT_CA1", "CERT", "CA_ID", "CA", "ID", "CASCADE", "NO ACTION");
        this.datasource.addForeignKeyConstraint(null, "FK_CERT_USER1", "CERT", "UID", "TUSER", "ID", "CASCADE", "NO ACTION");
        this.datasource.addForeignKeyConstraint(null, "FK_REQCERT_REQ1", "REQCERT", "RID", "REQUEST", "ID", "CASCADE", "NO ACTION");
        this.datasource.addForeignKeyConstraint(null, "FK_REQCERT_CERT1", "REQCERT", "CID", "CERT", "ID", "CASCADE", "NO ACTION");
        this.datasource.addUniqueConstrain(null, "CONST_CA_SN", "CERT", new String[]{"CA_ID", "SN"});
        this.datasource.createIndex(null, "IDX_CA_FPK", "CERT", new String[]{"CA_ID", "FP_K"});
        this.datasource.createIndex(null, "IDX_CA_FPS", "CERT", new String[]{"CA_ID", "FP_S"});
        this.datasource.createIndex(null, "IDX_CA_FPRS", "CERT", new String[]{"CA_ID", "FP_RS"});
        long duration = (System.currentTimeMillis() - start) / 1000L;
        System.out.println(" recovered indexes in " + StringUtil.formatTime((long)duration, (boolean)false));
    }
}

