/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ca;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.port.DbPortWorker;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.port.ca.CaCertstoreDbExporter;
import org.xipki.ca.dbtool.port.ca.CaconfDbExporter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class CaDbExportWorker
extends DbPortWorker {
    private static final Logger LOG = LoggerFactory.getLogger(CaDbExportWorker.class);
    private final DataSourceWrapper datasource;
    private final String destFolder;
    private final boolean resume;
    private final int numCertsInBundle;
    private final int numCertsPerSelect;

    public CaDbExportWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect) throws PasswordResolverException, IOException {
        ParamUtil.requireNonBlank((String)"dbConfFile", (String)dbConfFile);
        ParamUtil.requireNonBlank((String)"destFolder", (String)destFolder);
        ParamUtil.requireNonNull((String)"datasourceFactory", (Object)datasourceFactory);
        Properties props = DbPorter.getDbConfProperties(new FileInputStream(IoUtil.expandFilepath((String)dbConfFile)));
        this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, props, passwordResolver);
        this.destFolder = IoUtil.expandFilepath((String)destFolder);
        this.resume = resume;
        this.numCertsInBundle = numCertsInBundle;
        this.numCertsPerSelect = numCertsPerSelect;
        this.checkDestFolder();
    }

    private void checkDestFolder() throws IOException {
        File file = new File(this.destFolder);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            if (!file.isDirectory()) {
                throw new IOException(this.destFolder + " is not a folder");
            }
            if (!file.canWrite()) {
                throw new IOException(this.destFolder + " is not writable");
            }
        }
        File processLogFile = new File(this.destFolder, "export.process");
        if (this.resume) {
            if (!processLogFile.exists()) {
                throw new IOException("could not process with '--resume' option");
            }
        } else {
            String[] children = file.list();
            if (children != null && children.length > 0) {
                throw new IOException(this.destFolder + " is not empty");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run0() throws Exception {
        long start = System.currentTimeMillis();
        try {
            if (!this.resume) {
                CaconfDbExporter caConfExporter = new CaconfDbExporter(this.datasource, this.destFolder, this.stopMe);
                caConfExporter.export();
                caConfExporter.shutdown();
            }
            CaCertstoreDbExporter certStoreExporter = new CaCertstoreDbExporter(this.datasource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
            certStoreExporter.export();
            certStoreExporter.shutdown();
        }
        finally {
            try {
                this.datasource.close();
            }
            catch (Throwable th) {
                LOG.error("datasource.close()", th);
            }
            long end = System.currentTimeMillis();
            System.out.println("Finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
        }
    }
}

